// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/functions/v1/functions.proto

#include "google/cloud/functions/cloud_functions_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace functions {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

CloudFunctionsServiceConnectionIdempotencyPolicy::
    ~CloudFunctionsServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultCloudFunctionsServiceConnectionIdempotencyPolicy
    : public CloudFunctionsServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultCloudFunctionsServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<CloudFunctionsServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<
        DefaultCloudFunctionsServiceConnectionIdempotencyPolicy>(*this);
  }

  Idempotency ListFunctions(
      google::cloud::functions::v1::ListFunctionsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetFunction(
      google::cloud::functions::v1::GetFunctionRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateFunction(
      google::cloud::functions::v1::CreateFunctionRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateFunction(
      google::cloud::functions::v1::UpdateFunctionRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteFunction(
      google::cloud::functions::v1::DeleteFunctionRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CallFunction(
      google::cloud::functions::v1::CallFunctionRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GenerateUploadUrl(
      google::cloud::functions::v1::GenerateUploadUrlRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GenerateDownloadUrl(
      google::cloud::functions::v1::GenerateDownloadUrlRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<CloudFunctionsServiceConnectionIdempotencyPolicy>
MakeDefaultCloudFunctionsServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<
      DefaultCloudFunctionsServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace functions
}  // namespace cloud
}  // namespace google
