// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/functions/v1/functions.proto

#include "google/cloud/functions/cloud_functions_connection.h"
#include "google/cloud/functions/cloud_functions_options.h"
#include "google/cloud/functions/internal/cloud_functions_connection_impl.h"
#include "google/cloud/functions/internal/cloud_functions_option_defaults.h"
#include "google/cloud/functions/internal/cloud_functions_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace functions {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudFunctionsServiceConnection::~CloudFunctionsServiceConnection() = default;

StreamRange<google::cloud::functions::v1::CloudFunction>
CloudFunctionsServiceConnection::ListFunctions(
    google::cloud::functions::v1::ListFunctionsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::functions::v1::CloudFunction>>(
      std::move(request),
      [](google::cloud::functions::v1::ListFunctionsRequest const&) {
        return StatusOr<google::cloud::functions::v1::ListFunctionsResponse>{};
      },
      [](google::cloud::functions::v1::ListFunctionsResponse const&) {
        return std::vector<google::cloud::functions::v1::CloudFunction>();
      });
}

StatusOr<google::cloud::functions::v1::CloudFunction>
CloudFunctionsServiceConnection::GetFunction(
    google::cloud::functions::v1::GetFunctionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::functions::v1::CloudFunction>>
CloudFunctionsServiceConnection::CreateFunction(
    google::cloud::functions::v1::CreateFunctionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::functions::v1::CloudFunction>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::functions::v1::CloudFunction>>
CloudFunctionsServiceConnection::UpdateFunction(
    google::cloud::functions::v1::UpdateFunctionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::functions::v1::CloudFunction>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::functions::v1::OperationMetadataV1>>
CloudFunctionsServiceConnection::DeleteFunction(
    google::cloud::functions::v1::DeleteFunctionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::functions::v1::OperationMetadataV1>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::functions::v1::CallFunctionResponse>
CloudFunctionsServiceConnection::CallFunction(
    google::cloud::functions::v1::CallFunctionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::functions::v1::GenerateUploadUrlResponse>
CloudFunctionsServiceConnection::GenerateUploadUrl(
    google::cloud::functions::v1::GenerateUploadUrlRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::functions::v1::GenerateDownloadUrlResponse>
CloudFunctionsServiceConnection::GenerateDownloadUrl(
    google::cloud::functions::v1::GenerateDownloadUrlRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> CloudFunctionsServiceConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> CloudFunctionsServiceConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
CloudFunctionsServiceConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<CloudFunctionsServiceConnection>
MakeCloudFunctionsServiceConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 CloudFunctionsServicePolicyOptionList>(
      options, __func__);
  options = functions_internal::CloudFunctionsServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = functions_internal::CreateDefaultCloudFunctionsServiceStub(
      background->cq(), options);
  return std::make_shared<
      functions_internal::CloudFunctionsServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace functions
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace functions_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<functions::CloudFunctionsServiceConnection>
MakeCloudFunctionsServiceConnection(
    std::shared_ptr<CloudFunctionsServiceStub> stub, Options options) {
  options = CloudFunctionsServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<
      functions_internal::CloudFunctionsServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace functions_internal
}  // namespace cloud
}  // namespace google
