// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/filestore/v1/cloud_filestore_service.proto

#include "google/cloud/filestore/internal/cloud_filestore_manager_connection_impl.h"
#include "google/cloud/filestore/internal/cloud_filestore_manager_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace filestore_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudFilestoreManagerConnectionImpl::CloudFilestoreManagerConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<filestore_internal::CloudFilestoreManagerStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options),
          filestore_internal::CloudFilestoreManagerDefaultOptions(
              CloudFilestoreManagerConnection::options()))) {}

StreamRange<google::cloud::filestore::v1::Instance>
CloudFilestoreManagerConnectionImpl::ListInstances(
    google::cloud::filestore::v1::ListInstancesRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<filestore::CloudFilestoreManagerRetryPolicy const>(
          retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListInstances(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::filestore::v1::Instance>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::filestore::v1::ListInstancesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::filestore::v1::ListInstancesRequest const&
                       request) {
              return stub->ListInstances(context, request);
            },
            r, function_name);
      },
      [](google::cloud::filestore::v1::ListInstancesResponse r) {
        std::vector<google::cloud::filestore::v1::Instance> result(
            r.instances().size());
        auto& messages = *r.mutable_instances();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::filestore::v1::Instance>
CloudFilestoreManagerConnectionImpl::GetInstance(
    google::cloud::filestore::v1::GetInstanceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetInstance(request),
      [this](grpc::ClientContext& context,
             google::cloud::filestore::v1::GetInstanceRequest const& request) {
        return stub_->GetInstance(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerConnectionImpl::CreateInstance(
    google::cloud::filestore::v1::CreateInstanceRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::filestore::v1::Instance>(
      background_->cq(), request,
      [stub](
          google::cloud::CompletionQueue& cq,
          std::unique_ptr<grpc::ClientContext> context,
          google::cloud::filestore::v1::CreateInstanceRequest const& request) {
        return stub->AsyncCreateInstance(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::filestore::v1::Instance>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateInstance(request), polling_policy(),
      __func__);
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerConnectionImpl::UpdateInstance(
    google::cloud::filestore::v1::UpdateInstanceRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::filestore::v1::Instance>(
      background_->cq(), request,
      [stub](
          google::cloud::CompletionQueue& cq,
          std::unique_ptr<grpc::ClientContext> context,
          google::cloud::filestore::v1::UpdateInstanceRequest const& request) {
        return stub->AsyncUpdateInstance(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::filestore::v1::Instance>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateInstance(request), polling_policy(),
      __func__);
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerConnectionImpl::RestoreInstance(
    google::cloud::filestore::v1::RestoreInstanceRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::filestore::v1::Instance>(
      background_->cq(), request,
      [stub](
          google::cloud::CompletionQueue& cq,
          std::unique_ptr<grpc::ClientContext> context,
          google::cloud::filestore::v1::RestoreInstanceRequest const& request) {
        return stub->AsyncRestoreInstance(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::filestore::v1::Instance>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->RestoreInstance(request), polling_policy(),
      __func__);
}

future<StatusOr<google::cloud::common::OperationMetadata>>
CloudFilestoreManagerConnectionImpl::DeleteInstance(
    google::cloud::filestore::v1::DeleteInstanceRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::common::OperationMetadata>(
      background_->cq(), request,
      [stub](
          google::cloud::CompletionQueue& cq,
          std::unique_ptr<grpc::ClientContext> context,
          google::cloud::filestore::v1::DeleteInstanceRequest const& request) {
        return stub->AsyncDeleteInstance(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::common::OperationMetadata>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteInstance(request), polling_policy(),
      __func__);
}

StreamRange<google::cloud::filestore::v1::Backup>
CloudFilestoreManagerConnectionImpl::ListBackups(
    google::cloud::filestore::v1::ListBackupsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<filestore::CloudFilestoreManagerRetryPolicy const>(
          retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListBackups(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::filestore::v1::Backup>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::filestore::v1::ListBackupsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::filestore::v1::ListBackupsRequest const&
                       request) { return stub->ListBackups(context, request); },
            r, function_name);
      },
      [](google::cloud::filestore::v1::ListBackupsResponse r) {
        std::vector<google::cloud::filestore::v1::Backup> result(
            r.backups().size());
        auto& messages = *r.mutable_backups();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::filestore::v1::Backup>
CloudFilestoreManagerConnectionImpl::GetBackup(
    google::cloud::filestore::v1::GetBackupRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetBackup(request),
      [this](grpc::ClientContext& context,
             google::cloud::filestore::v1::GetBackupRequest const& request) {
        return stub_->GetBackup(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::filestore::v1::Backup>>
CloudFilestoreManagerConnectionImpl::CreateBackup(
    google::cloud::filestore::v1::CreateBackupRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::filestore::v1::Backup>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::filestore::v1::CreateBackupRequest const& request) {
        return stub->AsyncCreateBackup(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::filestore::v1::Backup>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateBackup(request), polling_policy(), __func__);
}

future<StatusOr<google::cloud::common::OperationMetadata>>
CloudFilestoreManagerConnectionImpl::DeleteBackup(
    google::cloud::filestore::v1::DeleteBackupRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::common::OperationMetadata>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::filestore::v1::DeleteBackupRequest const& request) {
        return stub->AsyncDeleteBackup(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::common::OperationMetadata>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteBackup(request), polling_policy(), __func__);
}

future<StatusOr<google::cloud::filestore::v1::Backup>>
CloudFilestoreManagerConnectionImpl::UpdateBackup(
    google::cloud::filestore::v1::UpdateBackupRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::filestore::v1::Backup>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::filestore::v1::UpdateBackupRequest const& request) {
        return stub->AsyncUpdateBackup(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::filestore::v1::Backup>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateBackup(request), polling_policy(), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace filestore_internal
}  // namespace cloud
}  // namespace google
