// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/filestore/v1/cloud_filestore_service.proto

#include "google/cloud/filestore/cloud_filestore_manager_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace filestore {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

CloudFilestoreManagerConnectionIdempotencyPolicy::
    ~CloudFilestoreManagerConnectionIdempotencyPolicy() = default;

namespace {
class DefaultCloudFilestoreManagerConnectionIdempotencyPolicy
    : public CloudFilestoreManagerConnectionIdempotencyPolicy {
 public:
  ~DefaultCloudFilestoreManagerConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<CloudFilestoreManagerConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<
        DefaultCloudFilestoreManagerConnectionIdempotencyPolicy>(*this);
  }

  Idempotency ListInstances(
      google::cloud::filestore::v1::ListInstancesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetInstance(
      google::cloud::filestore::v1::GetInstanceRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateInstance(
      google::cloud::filestore::v1::CreateInstanceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateInstance(
      google::cloud::filestore::v1::UpdateInstanceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency RestoreInstance(
      google::cloud::filestore::v1::RestoreInstanceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteInstance(
      google::cloud::filestore::v1::DeleteInstanceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListBackups(
      google::cloud::filestore::v1::ListBackupsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetBackup(
      google::cloud::filestore::v1::GetBackupRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateBackup(
      google::cloud::filestore::v1::CreateBackupRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteBackup(
      google::cloud::filestore::v1::DeleteBackupRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateBackup(
      google::cloud::filestore::v1::UpdateBackupRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<CloudFilestoreManagerConnectionIdempotencyPolicy>
MakeDefaultCloudFilestoreManagerConnectionIdempotencyPolicy() {
  return absl::make_unique<
      DefaultCloudFilestoreManagerConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace filestore
}  // namespace cloud
}  // namespace google
