// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/eventarc/publishing/v1/publisher.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EVENTARC_PUBLISHER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EVENTARC_PUBLISHER_CLIENT_H

#include "google/cloud/eventarc/publisher_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace eventarc {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Eventarc processes events generated by an event provider and delivers them
/// to a subscriber.
///
/// An event provider is a software-as-a-service (SaaS) system or
/// product that can generate and deliver events through Eventarc.
///
/// A third-party event provider is an event provider from outside of Google.
///
/// A partner is a third-party event provider that is integrated with Eventarc.
///
/// A subscriber is a GCP customer interested in receiving events.
///
/// Channel is a first-class Eventarc resource that is created and managed
/// by the subscriber in their GCP project. A Channel represents a subscriber's
/// intent to receive events from an event provider. A Channel is associated
/// with exactly one event provider.
///
/// ChannelConnection is a first-class Eventarc resource that
/// is created and managed by the partner in their GCP project. A
/// ChannelConnection represents a connection between a partner and a
/// subscriber's Channel. A ChannelConnection has a one-to-one mapping with a
/// Channel.
///
/// Publisher allows an event provider to publish events to Eventarc.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class PublisherClient {
 public:
  explicit PublisherClient(std::shared_ptr<PublisherConnection> connection,
                           Options options = {});
  ~PublisherClient();

  //@{
  // @name Copy and move support
  PublisherClient(PublisherClient const&) = default;
  PublisherClient& operator=(PublisherClient const&) = default;
  PublisherClient(PublisherClient&&) = default;
  PublisherClient& operator=(PublisherClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(PublisherClient const& a, PublisherClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(PublisherClient const& a, PublisherClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Publish events to a ChannelConnection in a partner's project.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::eventarc::publishing::v1::PublishChannelConnectionEventsRequest,google/cloud/eventarc/publishing/v1/publisher.proto#L69}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::eventarc::publishing::v1::PublishChannelConnectionEventsResponse,google/cloud/eventarc/publishing/v1/publisher.proto#L79}
  ///
  /// [google.cloud.eventarc.publishing.v1.PublishChannelConnectionEventsRequest]:
  /// @googleapis_reference_link{google/cloud/eventarc/publishing/v1/publisher.proto#L69}
  /// [google.cloud.eventarc.publishing.v1.PublishChannelConnectionEventsResponse]:
  /// @googleapis_reference_link{google/cloud/eventarc/publishing/v1/publisher.proto#L79}
  ///
  StatusOr<google::cloud::eventarc::publishing::v1::
               PublishChannelConnectionEventsResponse>
  PublishChannelConnectionEvents(
      google::cloud::eventarc::publishing::v1::
          PublishChannelConnectionEventsRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<PublisherConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace eventarc
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EVENTARC_PUBLISHER_CLIENT_H
