// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/eventarc/v1/eventarc.proto

#include "google/cloud/eventarc/internal/eventarc_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/cloud/eventarc/v1/eventarc.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace eventarc_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EventarcMetadata::EventarcMetadata(std::shared_ptr<EventarcStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::cloud::eventarc::v1::Trigger> EventarcMetadata::GetTrigger(
    grpc::ClientContext& context,
    google::cloud::eventarc::v1::GetTriggerRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetTrigger(context, request);
}

StatusOr<google::cloud::eventarc::v1::ListTriggersResponse>
EventarcMetadata::ListTriggers(
    grpc::ClientContext& context,
    google::cloud::eventarc::v1::ListTriggersRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListTriggers(context, request);
}

future<StatusOr<google::longrunning::Operation>>
EventarcMetadata::AsyncCreateTrigger(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncCreateTrigger(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
EventarcMetadata::AsyncUpdateTrigger(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
  SetMetadata(*context, "trigger.name=" + request.trigger().name());
  return child_->AsyncUpdateTrigger(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
EventarcMetadata::AsyncDeleteTrigger(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncDeleteTrigger(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
EventarcMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncGetOperation(cq, std::move(context), request);
}

future<Status> EventarcMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncCancelOperation(cq, std::move(context), request);
}

void EventarcMetadata::SetMetadata(grpc::ClientContext& context,
                                   std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void EventarcMetadata::SetMetadata(grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace eventarc_internal
}  // namespace cloud
}  // namespace google
