// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/eventarc/v1/eventarc.proto

#include "google/cloud/eventarc/internal/eventarc_connection_impl.h"
#include "google/cloud/eventarc/internal/eventarc_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace eventarc_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EventarcConnectionImpl::EventarcConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<eventarc_internal::EventarcStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      eventarc_internal::EventarcDefaultOptions(
                                          EventarcConnection::options()))) {}

StatusOr<google::cloud::eventarc::v1::Trigger>
EventarcConnectionImpl::GetTrigger(
    google::cloud::eventarc::v1::GetTriggerRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetTrigger(request),
      [this](grpc::ClientContext& context,
             google::cloud::eventarc::v1::GetTriggerRequest const& request) {
        return stub_->GetTrigger(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::eventarc::v1::Trigger>
EventarcConnectionImpl::ListTriggers(
    google::cloud::eventarc::v1::ListTriggersRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<eventarc::EventarcRetryPolicy const>(retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListTriggers(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::eventarc::v1::Trigger>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::eventarc::v1::ListTriggersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::eventarc::v1::ListTriggersRequest const&
                       request) {
              return stub->ListTriggers(context, request);
            },
            r, function_name);
      },
      [](google::cloud::eventarc::v1::ListTriggersResponse r) {
        std::vector<google::cloud::eventarc::v1::Trigger> result(
            r.triggers().size());
        auto& messages = *r.mutable_triggers();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnectionImpl::CreateTrigger(
    google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Trigger>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
        return stub->AsyncCreateTrigger(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Trigger>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateTrigger(request), polling_policy(), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnectionImpl::UpdateTrigger(
    google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Trigger>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
        return stub->AsyncUpdateTrigger(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Trigger>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateTrigger(request), polling_policy(), __func__);
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnectionImpl::DeleteTrigger(
    google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::eventarc::v1::Trigger>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
        return stub->AsyncDeleteTrigger(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::eventarc::v1::Trigger>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteTrigger(request), polling_policy(), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace eventarc_internal
}  // namespace cloud
}  // namespace google
