// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/eventarc/v1/eventarc.proto

#include "google/cloud/eventarc/eventarc_connection.h"
#include "google/cloud/eventarc/eventarc_options.h"
#include "google/cloud/eventarc/internal/eventarc_connection_impl.h"
#include "google/cloud/eventarc/internal/eventarc_option_defaults.h"
#include "google/cloud/eventarc/internal/eventarc_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace eventarc {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EventarcConnection::~EventarcConnection() = default;

StatusOr<google::cloud::eventarc::v1::Trigger> EventarcConnection::GetTrigger(
    google::cloud::eventarc::v1::GetTriggerRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::eventarc::v1::Trigger>
EventarcConnection::ListTriggers(
    google::cloud::eventarc::v1::ListTriggersRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::eventarc::v1::Trigger>>(
      std::move(request),
      [](google::cloud::eventarc::v1::ListTriggersRequest const&) {
        return StatusOr<google::cloud::eventarc::v1::ListTriggersResponse>{};
      },
      [](google::cloud::eventarc::v1::ListTriggersResponse const&) {
        return std::vector<google::cloud::eventarc::v1::Trigger>();
      });
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnection::CreateTrigger(
    google::cloud::eventarc::v1::CreateTriggerRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::eventarc::v1::Trigger>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnection::UpdateTrigger(
    google::cloud::eventarc::v1::UpdateTriggerRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::eventarc::v1::Trigger>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcConnection::DeleteTrigger(
    google::cloud::eventarc::v1::DeleteTriggerRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::eventarc::v1::Trigger>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<EventarcConnection> MakeEventarcConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 EventarcPolicyOptionList>(options, __func__);
  options = eventarc_internal::EventarcDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub =
      eventarc_internal::CreateDefaultEventarcStub(background->cq(), options);
  return std::make_shared<eventarc_internal::EventarcConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace eventarc
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace eventarc_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<eventarc::EventarcConnection> MakeEventarcConnection(
    std::shared_ptr<EventarcStub> stub, Options options) {
  options = EventarcDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<eventarc_internal::EventarcConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace eventarc_internal
}  // namespace cloud
}  // namespace google
