// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/eventarc/v1/eventarc.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EVENTARC_EVENTARC_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EVENTARC_EVENTARC_CLIENT_H

#include "google/cloud/eventarc/eventarc_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace eventarc {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Eventarc allows users to subscribe to various events that are provided by
/// Google Cloud services and forward them to supported destinations.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class EventarcClient {
 public:
  explicit EventarcClient(std::shared_ptr<EventarcConnection> connection,
                          Options options = {});
  ~EventarcClient();

  //@{
  // @name Copy and move support
  EventarcClient(EventarcClient const&) = default;
  EventarcClient& operator=(EventarcClient const&) = default;
  EventarcClient(EventarcClient&&) = default;
  EventarcClient& operator=(EventarcClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(EventarcClient const& a, EventarcClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(EventarcClient const& a, EventarcClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Get a single trigger.
  ///
  /// @param name  Required. The name of the trigger to get.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::eventarc::v1::Trigger,google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  /// [google.cloud.eventarc.v1.GetTriggerRequest]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L98}
  /// [google.cloud.eventarc.v1.Trigger]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  StatusOr<google::cloud::eventarc::v1::Trigger> GetTrigger(
      std::string const& name, Options options = {});

  ///
  /// Get a single trigger.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::eventarc::v1::GetTriggerRequest,google/cloud/eventarc/v1/eventarc.proto#L98}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::eventarc::v1::Trigger,google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  /// [google.cloud.eventarc.v1.GetTriggerRequest]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L98}
  /// [google.cloud.eventarc.v1.Trigger]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  StatusOr<google::cloud::eventarc::v1::Trigger> GetTrigger(
      google::cloud::eventarc::v1::GetTriggerRequest const& request,
      Options options = {});

  ///
  /// List triggers.
  ///
  /// @param parent  Required. The parent collection to list triggers on.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::eventarc::v1::Trigger,google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  /// [google.cloud.eventarc.v1.ListTriggersRequest]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L109}
  /// [google.cloud.eventarc.v1.Trigger]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  StreamRange<google::cloud::eventarc::v1::Trigger> ListTriggers(
      std::string const& parent, Options options = {});

  ///
  /// List triggers.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::eventarc::v1::ListTriggersRequest,google/cloud/eventarc/v1/eventarc.proto#L109}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::eventarc::v1::Trigger,google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  /// [google.cloud.eventarc.v1.ListTriggersRequest]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L109}
  /// [google.cloud.eventarc.v1.Trigger]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  StreamRange<google::cloud::eventarc::v1::Trigger> ListTriggers(
      google::cloud::eventarc::v1::ListTriggersRequest request,
      Options options = {});

  ///
  /// Create a new trigger in a particular project and location.
  ///
  /// @param parent  Required. The parent collection in which to add this
  /// trigger.
  /// @param trigger  Required. The trigger to create.
  /// @param trigger_id  Required. The user-provided ID to be assigned to the
  /// trigger.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::eventarc::v1::Trigger,google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  /// [google.cloud.eventarc.v1.CreateTriggerRequest]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L150}
  /// [google.cloud.eventarc.v1.Trigger]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  future<StatusOr<google::cloud::eventarc::v1::Trigger>> CreateTrigger(
      std::string const& parent,
      google::cloud::eventarc::v1::Trigger const& trigger,
      std::string const& trigger_id, Options options = {});

  ///
  /// Create a new trigger in a particular project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::eventarc::v1::CreateTriggerRequest,google/cloud/eventarc/v1/eventarc.proto#L150}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::eventarc::v1::Trigger,google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  /// [google.cloud.eventarc.v1.CreateTriggerRequest]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L150}
  /// [google.cloud.eventarc.v1.Trigger]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  future<StatusOr<google::cloud::eventarc::v1::Trigger>> CreateTrigger(
      google::cloud::eventarc::v1::CreateTriggerRequest const& request,
      Options options = {});

  ///
  /// Update a single trigger.
  ///
  /// @param trigger  The trigger to be updated.
  /// @param update_mask  The fields to be updated; only fields explicitly
  /// provided will be updated.
  ///  If no field mask is provided, all provided fields in the request will be
  ///  updated. To update all fields, provide a field mask of "*".
  /// @param allow_missing  If set to true, and the trigger is not found, a new
  /// trigger will be
  ///  created. In this situation, `update_mask` is ignored.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::eventarc::v1::Trigger,google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  /// [google.cloud.eventarc.v1.UpdateTriggerRequest]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L171}
  /// [google.cloud.eventarc.v1.Trigger]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  future<StatusOr<google::cloud::eventarc::v1::Trigger>> UpdateTrigger(
      google::cloud::eventarc::v1::Trigger const& trigger,
      google::protobuf::FieldMask const& update_mask, bool allow_missing,
      Options options = {});

  ///
  /// Update a single trigger.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::eventarc::v1::UpdateTriggerRequest,google/cloud/eventarc/v1/eventarc.proto#L171}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::eventarc::v1::Trigger,google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  /// [google.cloud.eventarc.v1.UpdateTriggerRequest]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L171}
  /// [google.cloud.eventarc.v1.Trigger]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  future<StatusOr<google::cloud::eventarc::v1::Trigger>> UpdateTrigger(
      google::cloud::eventarc::v1::UpdateTriggerRequest const& request,
      Options options = {});

  ///
  /// Delete a single trigger.
  ///
  /// @param name  Required. The name of the trigger to be deleted.
  /// @param allow_missing  If set to true, and the trigger is not found, the
  /// request will succeed
  ///  but no action will be taken on the server.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::eventarc::v1::Trigger,google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  /// [google.cloud.eventarc.v1.DeleteTriggerRequest]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L190}
  /// [google.cloud.eventarc.v1.Trigger]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  future<StatusOr<google::cloud::eventarc::v1::Trigger>> DeleteTrigger(
      std::string const& name, bool allow_missing, Options options = {});

  ///
  /// Delete a single trigger.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::eventarc::v1::DeleteTriggerRequest,google/cloud/eventarc/v1/eventarc.proto#L190}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::eventarc::v1::Trigger,google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  /// [google.cloud.eventarc.v1.DeleteTriggerRequest]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/eventarc.proto#L190}
  /// [google.cloud.eventarc.v1.Trigger]:
  /// @googleapis_reference_link{google/cloud/eventarc/v1/trigger.proto#L42}
  ///
  future<StatusOr<google::cloud::eventarc::v1::Trigger>> DeleteTrigger(
      google::cloud::eventarc::v1::DeleteTriggerRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<EventarcConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace eventarc
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EVENTARC_EVENTARC_CLIENT_H
