// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/privacy/dlp/v2/dlp.proto

#include "google/cloud/dlp/dlp_connection.h"
#include "google/cloud/dlp/dlp_options.h"
#include "google/cloud/dlp/internal/dlp_connection_impl.h"
#include "google/cloud/dlp/internal/dlp_option_defaults.h"
#include "google/cloud/dlp/internal/dlp_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace dlp {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DlpServiceConnection::~DlpServiceConnection() = default;

StatusOr<google::privacy::dlp::v2::InspectContentResponse>
DlpServiceConnection::InspectContent(
    google::privacy::dlp::v2::InspectContentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::RedactImageResponse>
DlpServiceConnection::RedactImage(
    google::privacy::dlp::v2::RedactImageRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::DeidentifyContentResponse>
DlpServiceConnection::DeidentifyContent(
    google::privacy::dlp::v2::DeidentifyContentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::ReidentifyContentResponse>
DlpServiceConnection::ReidentifyContent(
    google::privacy::dlp::v2::ReidentifyContentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::ListInfoTypesResponse>
DlpServiceConnection::ListInfoTypes(
    google::privacy::dlp::v2::ListInfoTypesRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::InspectTemplate>
DlpServiceConnection::CreateInspectTemplate(
    google::privacy::dlp::v2::CreateInspectTemplateRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::InspectTemplate>
DlpServiceConnection::UpdateInspectTemplate(
    google::privacy::dlp::v2::UpdateInspectTemplateRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::InspectTemplate>
DlpServiceConnection::GetInspectTemplate(
    google::privacy::dlp::v2::GetInspectTemplateRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::privacy::dlp::v2::InspectTemplate>
DlpServiceConnection::ListInspectTemplates(
    google::privacy::dlp::v2::ListInspectTemplatesRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::privacy::dlp::v2::InspectTemplate>>(
      std::move(request),
      [](google::privacy::dlp::v2::ListInspectTemplatesRequest const&) {
        return StatusOr<
            google::privacy::dlp::v2::ListInspectTemplatesResponse>{};
      },
      [](google::privacy::dlp::v2::ListInspectTemplatesResponse const&) {
        return std::vector<google::privacy::dlp::v2::InspectTemplate>();
      });
}

Status DlpServiceConnection::DeleteInspectTemplate(
    google::privacy::dlp::v2::DeleteInspectTemplateRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceConnection::CreateDeidentifyTemplate(
    google::privacy::dlp::v2::CreateDeidentifyTemplateRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceConnection::UpdateDeidentifyTemplate(
    google::privacy::dlp::v2::UpdateDeidentifyTemplateRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceConnection::GetDeidentifyTemplate(
    google::privacy::dlp::v2::GetDeidentifyTemplateRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceConnection::ListDeidentifyTemplates(
    google::privacy::dlp::v2::ListDeidentifyTemplatesRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::privacy::dlp::v2::DeidentifyTemplate>>(
      std::move(request),
      [](google::privacy::dlp::v2::ListDeidentifyTemplatesRequest const&) {
        return StatusOr<
            google::privacy::dlp::v2::ListDeidentifyTemplatesResponse>{};
      },
      [](google::privacy::dlp::v2::ListDeidentifyTemplatesResponse const&) {
        return std::vector<google::privacy::dlp::v2::DeidentifyTemplate>();
      });
}

Status DlpServiceConnection::DeleteDeidentifyTemplate(
    google::privacy::dlp::v2::DeleteDeidentifyTemplateRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::JobTrigger>
DlpServiceConnection::CreateJobTrigger(
    google::privacy::dlp::v2::CreateJobTriggerRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::JobTrigger>
DlpServiceConnection::UpdateJobTrigger(
    google::privacy::dlp::v2::UpdateJobTriggerRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::HybridInspectResponse>
DlpServiceConnection::HybridInspectJobTrigger(
    google::privacy::dlp::v2::HybridInspectJobTriggerRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::JobTrigger>
DlpServiceConnection::GetJobTrigger(
    google::privacy::dlp::v2::GetJobTriggerRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::privacy::dlp::v2::JobTrigger>
DlpServiceConnection::ListJobTriggers(
    google::privacy::dlp::v2::ListJobTriggersRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::privacy::dlp::v2::JobTrigger>>(
      std::move(request),
      [](google::privacy::dlp::v2::ListJobTriggersRequest const&) {
        return StatusOr<google::privacy::dlp::v2::ListJobTriggersResponse>{};
      },
      [](google::privacy::dlp::v2::ListJobTriggersResponse const&) {
        return std::vector<google::privacy::dlp::v2::JobTrigger>();
      });
}

Status DlpServiceConnection::DeleteJobTrigger(
    google::privacy::dlp::v2::DeleteJobTriggerRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::DlpJob>
DlpServiceConnection::ActivateJobTrigger(
    google::privacy::dlp::v2::ActivateJobTriggerRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::DlpJob> DlpServiceConnection::CreateDlpJob(
    google::privacy::dlp::v2::CreateDlpJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::privacy::dlp::v2::DlpJob> DlpServiceConnection::ListDlpJobs(
    google::privacy::dlp::v2::ListDlpJobsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::privacy::dlp::v2::DlpJob>>(
      std::move(request),
      [](google::privacy::dlp::v2::ListDlpJobsRequest const&) {
        return StatusOr<google::privacy::dlp::v2::ListDlpJobsResponse>{};
      },
      [](google::privacy::dlp::v2::ListDlpJobsResponse const&) {
        return std::vector<google::privacy::dlp::v2::DlpJob>();
      });
}

StatusOr<google::privacy::dlp::v2::DlpJob> DlpServiceConnection::GetDlpJob(
    google::privacy::dlp::v2::GetDlpJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DlpServiceConnection::DeleteDlpJob(
    google::privacy::dlp::v2::DeleteDlpJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DlpServiceConnection::CancelDlpJob(
    google::privacy::dlp::v2::CancelDlpJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::StoredInfoType>
DlpServiceConnection::CreateStoredInfoType(
    google::privacy::dlp::v2::CreateStoredInfoTypeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::StoredInfoType>
DlpServiceConnection::UpdateStoredInfoType(
    google::privacy::dlp::v2::UpdateStoredInfoTypeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::StoredInfoType>
DlpServiceConnection::GetStoredInfoType(
    google::privacy::dlp::v2::GetStoredInfoTypeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::privacy::dlp::v2::StoredInfoType>
DlpServiceConnection::ListStoredInfoTypes(
    google::privacy::dlp::v2::ListStoredInfoTypesRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::privacy::dlp::v2::StoredInfoType>>(
      std::move(request),
      [](google::privacy::dlp::v2::ListStoredInfoTypesRequest const&) {
        return StatusOr<
            google::privacy::dlp::v2::ListStoredInfoTypesResponse>{};
      },
      [](google::privacy::dlp::v2::ListStoredInfoTypesResponse const&) {
        return std::vector<google::privacy::dlp::v2::StoredInfoType>();
      });
}

Status DlpServiceConnection::DeleteStoredInfoType(
    google::privacy::dlp::v2::DeleteStoredInfoTypeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::privacy::dlp::v2::HybridInspectResponse>
DlpServiceConnection::HybridInspectDlpJob(
    google::privacy::dlp::v2::HybridInspectDlpJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DlpServiceConnection::FinishDlpJob(
    google::privacy::dlp::v2::FinishDlpJobRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<DlpServiceConnection> MakeDlpServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 DlpServicePolicyOptionList>(options, __func__);
  options = dlp_internal::DlpServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub =
      dlp_internal::CreateDefaultDlpServiceStub(background->cq(), options);
  return std::make_shared<dlp_internal::DlpServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dlp
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace dlp_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<dlp::DlpServiceConnection> MakeDlpServiceConnection(
    std::shared_ptr<DlpServiceStub> stub, Options options) {
  options = DlpServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<dlp_internal::DlpServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dlp_internal
}  // namespace cloud
}  // namespace google
