// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/privacy/dlp/v2/dlp.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DLP_DLP_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DLP_DLP_CLIENT_H

#include "google/cloud/dlp/dlp_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace dlp {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The Cloud Data Loss Prevention (DLP) API is a service that allows clients
/// to detect the presence of Personally Identifiable Information (PII) and
/// other privacy-sensitive data in user-supplied, unstructured data streams,
/// like text blocks or images. The service also includes methods for sensitive
/// data redaction and scheduling of data scans on Google Cloud Platform based
/// data sets.
///
/// To learn more about concepts and find how-to guides see
/// https://cloud.google.com/dlp/docs/.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class DlpServiceClient {
 public:
  explicit DlpServiceClient(std::shared_ptr<DlpServiceConnection> connection,
                            Options options = {});
  ~DlpServiceClient();

  //@{
  // @name Copy and move support
  DlpServiceClient(DlpServiceClient const&) = default;
  DlpServiceClient& operator=(DlpServiceClient const&) = default;
  DlpServiceClient(DlpServiceClient&&) = default;
  DlpServiceClient& operator=(DlpServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(DlpServiceClient const& a, DlpServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(DlpServiceClient const& a, DlpServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Finds potentially sensitive info in content.
  /// This method has limits on input size, processing time, and output size.
  ///
  /// When no InfoTypes or CustomInfoTypes are specified in this request, the
  /// system will automatically choose what detectors to run. By default this
  /// may be all types, but may change over time as detectors are updated.
  ///
  /// For how to guides, see https://cloud.google.com/dlp/docs/inspecting-images
  /// and https://cloud.google.com/dlp/docs/inspecting-text,
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::InspectContentRequest,google/privacy/dlp/v2/dlp.proto#L1372}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::InspectContentResponse,google/privacy/dlp/v2/dlp.proto#L1412}
  ///
  /// [google.privacy.dlp.v2.InspectContentRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L1372}
  /// [google.privacy.dlp.v2.InspectContentResponse]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L1412}
  ///
  StatusOr<google::privacy::dlp::v2::InspectContentResponse> InspectContent(
      google::privacy::dlp::v2::InspectContentRequest const& request,
      Options options = {});

  ///
  /// Redacts potentially sensitive info from an image.
  /// This method has limits on input size, processing time, and output size.
  /// See https://cloud.google.com/dlp/docs/redacting-sensitive-data-images to
  /// learn more.
  ///
  /// When no InfoTypes or CustomInfoTypes are specified in this request, the
  /// system will automatically choose what detectors to run. By default this
  /// may be all types, but may change over time as detectors are updated.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::RedactImageRequest,google/privacy/dlp/v2/dlp.proto#L1153}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::RedactImageResponse,google/privacy/dlp/v2/dlp.proto#L1224}
  ///
  /// [google.privacy.dlp.v2.RedactImageRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L1153}
  /// [google.privacy.dlp.v2.RedactImageResponse]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L1224}
  ///
  StatusOr<google::privacy::dlp::v2::RedactImageResponse> RedactImage(
      google::privacy::dlp::v2::RedactImageRequest const& request,
      Options options = {});

  ///
  /// De-identifies potentially sensitive info from a ContentItem.
  /// This method has limits on input size and output size.
  /// See https://cloud.google.com/dlp/docs/deidentify-sensitive-data to
  /// learn more.
  ///
  /// When no InfoTypes or CustomInfoTypes are specified in this request, the
  /// system will automatically choose what detectors to run. By default this
  /// may be all types, but may change over time as detectors are updated.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::DeidentifyContentRequest,google/privacy/dlp/v2/dlp.proto#L1238}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::DeidentifyContentResponse,google/privacy/dlp/v2/dlp.proto#L1291}
  ///
  /// [google.privacy.dlp.v2.DeidentifyContentRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L1238}
  /// [google.privacy.dlp.v2.DeidentifyContentResponse]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L1291}
  ///
  StatusOr<google::privacy::dlp::v2::DeidentifyContentResponse>
  DeidentifyContent(
      google::privacy::dlp::v2::DeidentifyContentRequest const& request,
      Options options = {});

  ///
  /// Re-identifies content that has been de-identified.
  /// See
  /// https://cloud.google.com/dlp/docs/pseudonymization#re-identification_in_free_text_code_example
  /// to learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::ReidentifyContentRequest,google/privacy/dlp/v2/dlp.proto#L1300}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::ReidentifyContentResponse,google/privacy/dlp/v2/dlp.proto#L1363}
  ///
  /// [google.privacy.dlp.v2.ReidentifyContentRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L1300}
  /// [google.privacy.dlp.v2.ReidentifyContentResponse]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L1363}
  ///
  StatusOr<google::privacy::dlp::v2::ReidentifyContentResponse>
  ReidentifyContent(
      google::privacy::dlp::v2::ReidentifyContentRequest const& request,
      Options options = {});

  ///
  /// Returns a list of the sensitive information types that the DLP API
  /// supports. See https://cloud.google.com/dlp/docs/infotypes-reference to
  /// learn more.
  ///
  /// @param parent  The parent resource name.
  ///  The format of this value is as follows:
  ///      locations/<var>LOCATION_ID</var>
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::ListInfoTypesResponse,google/privacy/dlp/v2/dlp.proto#L1574}
  ///
  /// [google.privacy.dlp.v2.ListInfoTypesRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L1552}
  /// [google.privacy.dlp.v2.ListInfoTypesResponse]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L1574}
  ///
  StatusOr<google::privacy::dlp::v2::ListInfoTypesResponse> ListInfoTypes(
      std::string const& parent, Options options = {});

  ///
  /// Returns a list of the sensitive information types that the DLP API
  /// supports. See https://cloud.google.com/dlp/docs/infotypes-reference to
  /// learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::ListInfoTypesRequest,google/privacy/dlp/v2/dlp.proto#L1552}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::ListInfoTypesResponse,google/privacy/dlp/v2/dlp.proto#L1574}
  ///
  /// [google.privacy.dlp.v2.ListInfoTypesRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L1552}
  /// [google.privacy.dlp.v2.ListInfoTypesResponse]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L1574}
  ///
  StatusOr<google::privacy::dlp::v2::ListInfoTypesResponse> ListInfoTypes(
      google::privacy::dlp::v2::ListInfoTypesRequest const& request,
      Options options = {});

  ///
  /// Creates an InspectTemplate for re-using frequently used configuration
  /// for inspecting content, images, and storage.
  /// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
  ///
  /// @param parent  Required. Parent resource name.
  ///  The format of this value varies depending on the scope of the request
  ///  (project or organization) and whether you have [specified a processing
  ///  location](https://cloud.google.com/dlp/docs/specifying-location):
  ///  + Projects scope, location specified:<br/>
  ///    `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
  ///  + Projects scope, no location specified (defaults to global):<br/>
  ///    `projects/`<var>PROJECT_ID</var>
  ///  + Organizations scope, location specified:<br/>
  ///    `organizations/`<var>ORG_ID</var>`/locations/`<var>LOCATION_ID</var>
  ///  + Organizations scope, no location specified (defaults to global):<br/>
  ///    `organizations/`<var>ORG_ID</var>
  ///  The following example `parent` string specifies a parent project with the
  ///  identifier `example-project`, and specifies the `europe-west3` location
  ///  for processing data:
  ///      parent=projects/example-project/locations/europe-west3
  /// @param inspect_template  Required. The InspectTemplate to create.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::InspectTemplate,google/privacy/dlp/v2/dlp.proto#L2935}
  ///
  /// [google.privacy.dlp.v2.CreateInspectTemplateRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3180}
  /// [google.privacy.dlp.v2.InspectTemplate]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L2935}
  ///
  StatusOr<google::privacy::dlp::v2::InspectTemplate> CreateInspectTemplate(
      std::string const& parent,
      google::privacy::dlp::v2::InspectTemplate const& inspect_template,
      Options options = {});

  ///
  /// Creates an InspectTemplate for re-using frequently used configuration
  /// for inspecting content, images, and storage.
  /// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::CreateInspectTemplateRequest,google/privacy/dlp/v2/dlp.proto#L3180}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::InspectTemplate,google/privacy/dlp/v2/dlp.proto#L2935}
  ///
  /// [google.privacy.dlp.v2.CreateInspectTemplateRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3180}
  /// [google.privacy.dlp.v2.InspectTemplate]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L2935}
  ///
  StatusOr<google::privacy::dlp::v2::InspectTemplate> CreateInspectTemplate(
      google::privacy::dlp::v2::CreateInspectTemplateRequest const& request,
      Options options = {});

  ///
  /// Updates the InspectTemplate.
  /// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
  ///
  /// @param name  Required. Resource name of organization and inspectTemplate
  /// to be updated, for
  ///  example `organizations/433245324/inspectTemplates/432452342` or
  ///  projects/project-id/inspectTemplates/432452342.
  /// @param inspect_template  New InspectTemplate value.
  /// @param update_mask  Mask to control which fields get updated.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::InspectTemplate,google/privacy/dlp/v2/dlp.proto#L2935}
  ///
  /// [google.privacy.dlp.v2.UpdateInspectTemplateRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3222}
  /// [google.privacy.dlp.v2.InspectTemplate]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L2935}
  ///
  StatusOr<google::privacy::dlp::v2::InspectTemplate> UpdateInspectTemplate(
      std::string const& name,
      google::privacy::dlp::v2::InspectTemplate const& inspect_template,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates the InspectTemplate.
  /// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::UpdateInspectTemplateRequest,google/privacy/dlp/v2/dlp.proto#L3222}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::InspectTemplate,google/privacy/dlp/v2/dlp.proto#L2935}
  ///
  /// [google.privacy.dlp.v2.UpdateInspectTemplateRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3222}
  /// [google.privacy.dlp.v2.InspectTemplate]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L2935}
  ///
  StatusOr<google::privacy::dlp::v2::InspectTemplate> UpdateInspectTemplate(
      google::privacy::dlp::v2::UpdateInspectTemplateRequest const& request,
      Options options = {});

  ///
  /// Gets an InspectTemplate.
  /// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
  ///
  /// @param name  Required. Resource name of the organization and
  /// inspectTemplate to be read, for
  ///  example `organizations/433245324/inspectTemplates/432452342` or
  ///  projects/project-id/inspectTemplates/432452342.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::InspectTemplate,google/privacy/dlp/v2/dlp.proto#L2935}
  ///
  /// [google.privacy.dlp.v2.GetInspectTemplateRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3241}
  /// [google.privacy.dlp.v2.InspectTemplate]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L2935}
  ///
  StatusOr<google::privacy::dlp::v2::InspectTemplate> GetInspectTemplate(
      std::string const& name, Options options = {});

  ///
  /// Gets an InspectTemplate.
  /// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::GetInspectTemplateRequest,google/privacy/dlp/v2/dlp.proto#L3241}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::InspectTemplate,google/privacy/dlp/v2/dlp.proto#L2935}
  ///
  /// [google.privacy.dlp.v2.GetInspectTemplateRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3241}
  /// [google.privacy.dlp.v2.InspectTemplate]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L2935}
  ///
  StatusOr<google::privacy::dlp::v2::InspectTemplate> GetInspectTemplate(
      google::privacy::dlp::v2::GetInspectTemplateRequest const& request,
      Options options = {});

  ///
  /// Lists InspectTemplates.
  /// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
  ///
  /// @param parent  Required. Parent resource name.
  ///  The format of this value varies depending on the scope of the request
  ///  (project or organization) and whether you have [specified a processing
  ///  location](https://cloud.google.com/dlp/docs/specifying-location):
  ///  + Projects scope, location specified:<br/>
  ///    `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
  ///  + Projects scope, no location specified (defaults to global):<br/>
  ///    `projects/`<var>PROJECT_ID</var>
  ///  + Organizations scope, location specified:<br/>
  ///    `organizations/`<var>ORG_ID</var>`/locations/`<var>LOCATION_ID</var>
  ///  + Organizations scope, no location specified (defaults to global):<br/>
  ///    `organizations/`<var>ORG_ID</var>
  ///  The following example `parent` string specifies a parent project with the
  ///  identifier `example-project`, and specifies the `europe-west3` location
  ///  for processing data:
  ///      parent=projects/example-project/locations/europe-west3
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::InspectTemplate,google/privacy/dlp/v2/dlp.proto#L2935}
  ///
  /// [google.privacy.dlp.v2.ListInspectTemplatesRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3254}
  /// [google.privacy.dlp.v2.InspectTemplate]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L2935}
  ///
  StreamRange<google::privacy::dlp::v2::InspectTemplate> ListInspectTemplates(
      std::string const& parent, Options options = {});

  ///
  /// Lists InspectTemplates.
  /// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::ListInspectTemplatesRequest,google/privacy/dlp/v2/dlp.proto#L3254}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::InspectTemplate,google/privacy/dlp/v2/dlp.proto#L2935}
  ///
  /// [google.privacy.dlp.v2.ListInspectTemplatesRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3254}
  /// [google.privacy.dlp.v2.InspectTemplate]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L2935}
  ///
  StreamRange<google::privacy::dlp::v2::InspectTemplate> ListInspectTemplates(
      google::privacy::dlp::v2::ListInspectTemplatesRequest request,
      Options options = {});

  ///
  /// Deletes an InspectTemplate.
  /// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
  ///
  /// @param name  Required. Resource name of the organization and
  /// inspectTemplate to be deleted, for
  ///  example `organizations/433245324/inspectTemplates/432452342` or
  ///  projects/project-id/inspectTemplates/432452342.
  /// @param options  Optional. Operation options.
  ///
  /// [google.privacy.dlp.v2.DeleteInspectTemplateRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3320}
  ///
  Status DeleteInspectTemplate(std::string const& name, Options options = {});

  ///
  /// Deletes an InspectTemplate.
  /// See https://cloud.google.com/dlp/docs/creating-templates to learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::DeleteInspectTemplateRequest,google/privacy/dlp/v2/dlp.proto#L3320}
  /// @param options  Optional. Operation options.
  ///
  /// [google.privacy.dlp.v2.DeleteInspectTemplateRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3320}
  ///
  Status DeleteInspectTemplate(
      google::privacy::dlp::v2::DeleteInspectTemplateRequest const& request,
      Options options = {});

  ///
  /// Creates a DeidentifyTemplate for re-using frequently used configuration
  /// for de-identifying content, images, and storage.
  /// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
  /// more.
  ///
  /// @param parent  Required. Parent resource name.
  ///  The format of this value varies depending on the scope of the request
  ///  (project or organization) and whether you have [specified a processing
  ///  location](https://cloud.google.com/dlp/docs/specifying-location):
  ///  + Projects scope, location specified:<br/>
  ///    `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
  ///  + Projects scope, no location specified (defaults to global):<br/>
  ///    `projects/`<var>PROJECT_ID</var>
  ///  + Organizations scope, location specified:<br/>
  ///    `organizations/`<var>ORG_ID</var>`/locations/`<var>LOCATION_ID</var>
  ///  + Organizations scope, no location specified (defaults to global):<br/>
  ///    `organizations/`<var>ORG_ID</var>
  ///  The following example `parent` string specifies a parent project with the
  ///  identifier `example-project`, and specifies the `europe-west3` location
  ///  for processing data:
  ///      parent=projects/example-project/locations/europe-west3
  /// @param deidentify_template  Required. The DeidentifyTemplate to create.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::DeidentifyTemplate,google/privacy/dlp/v2/dlp.proto#L2969}
  ///
  /// [google.privacy.dlp.v2.CreateDeidentifyTemplateRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3788}
  /// [google.privacy.dlp.v2.DeidentifyTemplate]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L2969}
  ///
  StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
  CreateDeidentifyTemplate(
      std::string const& parent,
      google::privacy::dlp::v2::DeidentifyTemplate const& deidentify_template,
      Options options = {});

  ///
  /// Creates a DeidentifyTemplate for re-using frequently used configuration
  /// for de-identifying content, images, and storage.
  /// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
  /// more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::CreateDeidentifyTemplateRequest,google/privacy/dlp/v2/dlp.proto#L3788}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::DeidentifyTemplate,google/privacy/dlp/v2/dlp.proto#L2969}
  ///
  /// [google.privacy.dlp.v2.CreateDeidentifyTemplateRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3788}
  /// [google.privacy.dlp.v2.DeidentifyTemplate]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L2969}
  ///
  StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
  CreateDeidentifyTemplate(
      google::privacy::dlp::v2::CreateDeidentifyTemplateRequest const& request,
      Options options = {});

  ///
  /// Updates the DeidentifyTemplate.
  /// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
  /// more.
  ///
  /// @param name  Required. Resource name of organization and deidentify
  /// template to be updated, for
  ///  example `organizations/433245324/deidentifyTemplates/432452342` or
  ///  projects/project-id/deidentifyTemplates/432452342.
  /// @param deidentify_template  New DeidentifyTemplate value.
  /// @param update_mask  Mask to control which fields get updated.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::DeidentifyTemplate,google/privacy/dlp/v2/dlp.proto#L2969}
  ///
  /// [google.privacy.dlp.v2.UpdateDeidentifyTemplateRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3830}
  /// [google.privacy.dlp.v2.DeidentifyTemplate]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L2969}
  ///
  StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
  UpdateDeidentifyTemplate(
      std::string const& name,
      google::privacy::dlp::v2::DeidentifyTemplate const& deidentify_template,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates the DeidentifyTemplate.
  /// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
  /// more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::UpdateDeidentifyTemplateRequest,google/privacy/dlp/v2/dlp.proto#L3830}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::DeidentifyTemplate,google/privacy/dlp/v2/dlp.proto#L2969}
  ///
  /// [google.privacy.dlp.v2.UpdateDeidentifyTemplateRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3830}
  /// [google.privacy.dlp.v2.DeidentifyTemplate]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L2969}
  ///
  StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
  UpdateDeidentifyTemplate(
      google::privacy::dlp::v2::UpdateDeidentifyTemplateRequest const& request,
      Options options = {});

  ///
  /// Gets a DeidentifyTemplate.
  /// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
  /// more.
  ///
  /// @param name  Required. Resource name of the organization and deidentify
  /// template to be read, for
  ///  example `organizations/433245324/deidentifyTemplates/432452342` or
  ///  projects/project-id/deidentifyTemplates/432452342.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::DeidentifyTemplate,google/privacy/dlp/v2/dlp.proto#L2969}
  ///
  /// [google.privacy.dlp.v2.GetDeidentifyTemplateRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3849}
  /// [google.privacy.dlp.v2.DeidentifyTemplate]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L2969}
  ///
  StatusOr<google::privacy::dlp::v2::DeidentifyTemplate> GetDeidentifyTemplate(
      std::string const& name, Options options = {});

  ///
  /// Gets a DeidentifyTemplate.
  /// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
  /// more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::GetDeidentifyTemplateRequest,google/privacy/dlp/v2/dlp.proto#L3849}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::DeidentifyTemplate,google/privacy/dlp/v2/dlp.proto#L2969}
  ///
  /// [google.privacy.dlp.v2.GetDeidentifyTemplateRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3849}
  /// [google.privacy.dlp.v2.DeidentifyTemplate]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L2969}
  ///
  StatusOr<google::privacy::dlp::v2::DeidentifyTemplate> GetDeidentifyTemplate(
      google::privacy::dlp::v2::GetDeidentifyTemplateRequest const& request,
      Options options = {});

  ///
  /// Lists DeidentifyTemplates.
  /// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
  /// more.
  ///
  /// @param parent  Required. Parent resource name.
  ///  The format of this value varies depending on the scope of the request
  ///  (project or organization) and whether you have [specified a processing
  ///  location](https://cloud.google.com/dlp/docs/specifying-location):
  ///  + Projects scope, location specified:<br/>
  ///    `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
  ///  + Projects scope, no location specified (defaults to global):<br/>
  ///    `projects/`<var>PROJECT_ID</var>
  ///  + Organizations scope, location specified:<br/>
  ///    `organizations/`<var>ORG_ID</var>`/locations/`<var>LOCATION_ID</var>
  ///  + Organizations scope, no location specified (defaults to global):<br/>
  ///    `organizations/`<var>ORG_ID</var>
  ///  The following example `parent` string specifies a parent project with the
  ///  identifier `example-project`, and specifies the `europe-west3` location
  ///  for processing data:
  ///      parent=projects/example-project/locations/europe-west3
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::DeidentifyTemplate,google/privacy/dlp/v2/dlp.proto#L2969}
  ///
  /// [google.privacy.dlp.v2.ListDeidentifyTemplatesRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3862}
  /// [google.privacy.dlp.v2.DeidentifyTemplate]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L2969}
  ///
  StreamRange<google::privacy::dlp::v2::DeidentifyTemplate>
  ListDeidentifyTemplates(std::string const& parent, Options options = {});

  ///
  /// Lists DeidentifyTemplates.
  /// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
  /// more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::ListDeidentifyTemplatesRequest,google/privacy/dlp/v2/dlp.proto#L3862}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::DeidentifyTemplate,google/privacy/dlp/v2/dlp.proto#L2969}
  ///
  /// [google.privacy.dlp.v2.ListDeidentifyTemplatesRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3862}
  /// [google.privacy.dlp.v2.DeidentifyTemplate]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L2969}
  ///
  StreamRange<google::privacy::dlp::v2::DeidentifyTemplate>
  ListDeidentifyTemplates(
      google::privacy::dlp::v2::ListDeidentifyTemplatesRequest request,
      Options options = {});

  ///
  /// Deletes a DeidentifyTemplate.
  /// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
  /// more.
  ///
  /// @param name  Required. Resource name of the organization and deidentify
  /// template to be deleted,
  ///  for example `organizations/433245324/deidentifyTemplates/432452342` or
  ///  projects/project-id/deidentifyTemplates/432452342.
  /// @param options  Optional. Operation options.
  ///
  /// [google.privacy.dlp.v2.DeleteDeidentifyTemplateRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3929}
  ///
  Status DeleteDeidentifyTemplate(std::string const& name,
                                  Options options = {});

  ///
  /// Deletes a DeidentifyTemplate.
  /// See https://cloud.google.com/dlp/docs/creating-templates-deid to learn
  /// more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::DeleteDeidentifyTemplateRequest,google/privacy/dlp/v2/dlp.proto#L3929}
  /// @param options  Optional. Operation options.
  ///
  /// [google.privacy.dlp.v2.DeleteDeidentifyTemplateRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3929}
  ///
  Status DeleteDeidentifyTemplate(
      google::privacy::dlp::v2::DeleteDeidentifyTemplateRequest const& request,
      Options options = {});

  ///
  /// Creates a job trigger to run DLP actions such as scanning storage for
  /// sensitive information on a set schedule.
  /// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
  ///
  /// @param parent  Required. Parent resource name.
  ///  The format of this value varies depending on whether you have [specified
  ///  a processing
  ///  location](https://cloud.google.com/dlp/docs/specifying-location):
  ///  + Projects scope, location specified:<br/>
  ///    `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
  ///  + Projects scope, no location specified (defaults to global):<br/>
  ///    `projects/`<var>PROJECT_ID</var>
  ///  The following example `parent` string specifies a parent project with the
  ///  identifier `example-project`, and specifies the `europe-west3` location
  ///  for processing data:
  ///      parent=projects/example-project/locations/europe-west3
  /// @param job_trigger  Required. The JobTrigger to create.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::JobTrigger,google/privacy/dlp/v2/dlp.proto#L3013}
  ///
  /// [google.privacy.dlp.v2.CreateJobTriggerRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3333}
  /// [google.privacy.dlp.v2.JobTrigger]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3013}
  ///
  StatusOr<google::privacy::dlp::v2::JobTrigger> CreateJobTrigger(
      std::string const& parent,
      google::privacy::dlp::v2::JobTrigger const& job_trigger,
      Options options = {});

  ///
  /// Creates a job trigger to run DLP actions such as scanning storage for
  /// sensitive information on a set schedule.
  /// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::CreateJobTriggerRequest,google/privacy/dlp/v2/dlp.proto#L3333}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::JobTrigger,google/privacy/dlp/v2/dlp.proto#L3013}
  ///
  /// [google.privacy.dlp.v2.CreateJobTriggerRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3333}
  /// [google.privacy.dlp.v2.JobTrigger]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3013}
  ///
  StatusOr<google::privacy::dlp::v2::JobTrigger> CreateJobTrigger(
      google::privacy::dlp::v2::CreateJobTriggerRequest const& request,
      Options options = {});

  ///
  /// Updates a job trigger.
  /// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
  ///
  /// @param name  Required. Resource name of the project and the triggeredJob,
  /// for example
  ///  `projects/dlp-test-project/jobTriggers/53234423`.
  /// @param job_trigger  New JobTrigger value.
  /// @param update_mask  Mask to control which fields get updated.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::JobTrigger,google/privacy/dlp/v2/dlp.proto#L3013}
  ///
  /// [google.privacy.dlp.v2.UpdateJobTriggerRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3383}
  /// [google.privacy.dlp.v2.JobTrigger]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3013}
  ///
  StatusOr<google::privacy::dlp::v2::JobTrigger> UpdateJobTrigger(
      std::string const& name,
      google::privacy::dlp::v2::JobTrigger const& job_trigger,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates a job trigger.
  /// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::UpdateJobTriggerRequest,google/privacy/dlp/v2/dlp.proto#L3383}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::JobTrigger,google/privacy/dlp/v2/dlp.proto#L3013}
  ///
  /// [google.privacy.dlp.v2.UpdateJobTriggerRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3383}
  /// [google.privacy.dlp.v2.JobTrigger]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3013}
  ///
  StatusOr<google::privacy::dlp::v2::JobTrigger> UpdateJobTrigger(
      google::privacy::dlp::v2::UpdateJobTriggerRequest const& request,
      Options options = {});

  ///
  /// Inspect hybrid content and store findings to a trigger. The inspection
  /// will be processed asynchronously. To review the findings monitor the
  /// jobs within the trigger.
  ///
  /// @param name  Required. Resource name of the trigger to execute a hybrid
  /// inspect on, for example
  ///  `projects/dlp-test-project/jobTriggers/53234423`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::HybridInspectResponse,google/privacy/dlp/v2/dlp.proto#L4295}
  ///
  /// [google.privacy.dlp.v2.HybridInspectJobTriggerRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4213}
  /// [google.privacy.dlp.v2.HybridInspectResponse]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4295}
  ///
  StatusOr<google::privacy::dlp::v2::HybridInspectResponse>
  HybridInspectJobTrigger(std::string const& name, Options options = {});

  ///
  /// Inspect hybrid content and store findings to a trigger. The inspection
  /// will be processed asynchronously. To review the findings monitor the
  /// jobs within the trigger.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::HybridInspectJobTriggerRequest,google/privacy/dlp/v2/dlp.proto#L4213}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::HybridInspectResponse,google/privacy/dlp/v2/dlp.proto#L4295}
  ///
  /// [google.privacy.dlp.v2.HybridInspectJobTriggerRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4213}
  /// [google.privacy.dlp.v2.HybridInspectResponse]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4295}
  ///
  StatusOr<google::privacy::dlp::v2::HybridInspectResponse>
  HybridInspectJobTrigger(
      google::privacy::dlp::v2::HybridInspectJobTriggerRequest const& request,
      Options options = {});

  ///
  /// Gets a job trigger.
  /// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
  ///
  /// @param name  Required. Resource name of the project and the triggeredJob,
  /// for example
  ///  `projects/dlp-test-project/jobTriggers/53234423`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::JobTrigger,google/privacy/dlp/v2/dlp.proto#L3013}
  ///
  /// [google.privacy.dlp.v2.GetJobTriggerRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3401}
  /// [google.privacy.dlp.v2.JobTrigger]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3013}
  ///
  StatusOr<google::privacy::dlp::v2::JobTrigger> GetJobTrigger(
      std::string const& name, Options options = {});

  ///
  /// Gets a job trigger.
  /// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::GetJobTriggerRequest,google/privacy/dlp/v2/dlp.proto#L3401}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::JobTrigger,google/privacy/dlp/v2/dlp.proto#L3013}
  ///
  /// [google.privacy.dlp.v2.GetJobTriggerRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3401}
  /// [google.privacy.dlp.v2.JobTrigger]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3013}
  ///
  StatusOr<google::privacy::dlp::v2::JobTrigger> GetJobTrigger(
      google::privacy::dlp::v2::GetJobTriggerRequest const& request,
      Options options = {});

  ///
  /// Lists job triggers.
  /// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
  ///
  /// @param parent  Required. Parent resource name.
  ///  The format of this value varies depending on whether you have [specified
  ///  a processing
  ///  location](https://cloud.google.com/dlp/docs/specifying-location):
  ///  + Projects scope, location specified:<br/>
  ///    `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
  ///  + Projects scope, no location specified (defaults to global):<br/>
  ///    `projects/`<var>PROJECT_ID</var>
  ///  The following example `parent` string specifies a parent project with the
  ///  identifier `example-project`, and specifies the `europe-west3` location
  ///  for processing data:
  ///      parent=projects/example-project/locations/europe-west3
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::JobTrigger,google/privacy/dlp/v2/dlp.proto#L3013}
  ///
  /// [google.privacy.dlp.v2.ListJobTriggersRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3460}
  /// [google.privacy.dlp.v2.JobTrigger]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3013}
  ///
  StreamRange<google::privacy::dlp::v2::JobTrigger> ListJobTriggers(
      std::string const& parent, Options options = {});

  ///
  /// Lists job triggers.
  /// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::ListJobTriggersRequest,google/privacy/dlp/v2/dlp.proto#L3460}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::JobTrigger,google/privacy/dlp/v2/dlp.proto#L3013}
  ///
  /// [google.privacy.dlp.v2.ListJobTriggersRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3460}
  /// [google.privacy.dlp.v2.JobTrigger]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3013}
  ///
  StreamRange<google::privacy::dlp::v2::JobTrigger> ListJobTriggers(
      google::privacy::dlp::v2::ListJobTriggersRequest request,
      Options options = {});

  ///
  /// Deletes a job trigger.
  /// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
  ///
  /// @param name  Required. Resource name of the project and the triggeredJob,
  /// for example
  ///  `projects/dlp-test-project/jobTriggers/53234423`.
  /// @param options  Optional. Operation options.
  ///
  /// [google.privacy.dlp.v2.DeleteJobTriggerRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3553}
  ///
  Status DeleteJobTrigger(std::string const& name, Options options = {});

  ///
  /// Deletes a job trigger.
  /// See https://cloud.google.com/dlp/docs/creating-job-triggers to learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::DeleteJobTriggerRequest,google/privacy/dlp/v2/dlp.proto#L3553}
  /// @param options  Optional. Operation options.
  ///
  /// [google.privacy.dlp.v2.DeleteJobTriggerRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3553}
  ///
  Status DeleteJobTrigger(
      google::privacy::dlp::v2::DeleteJobTriggerRequest const& request,
      Options options = {});

  ///
  /// Activate a job trigger. Causes the immediate execute of a trigger
  /// instead of waiting on the trigger event to occur.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::ActivateJobTriggerRequest,google/privacy/dlp/v2/dlp.proto#L3371}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::DlpJob,google/privacy/dlp/v2/dlp.proto#L3582}
  ///
  /// [google.privacy.dlp.v2.ActivateJobTriggerRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3371}
  /// [google.privacy.dlp.v2.DlpJob]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3582}
  ///
  StatusOr<google::privacy::dlp::v2::DlpJob> ActivateJobTrigger(
      google::privacy::dlp::v2::ActivateJobTriggerRequest const& request,
      Options options = {});

  ///
  /// Creates a new job to inspect storage or calculate risk metrics.
  /// See https://cloud.google.com/dlp/docs/inspecting-storage and
  /// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
  ///
  /// When no InfoTypes or CustomInfoTypes are specified in inspect jobs, the
  /// system will automatically choose what detectors to run. By default this
  /// may be all types, but may change over time as detectors are updated.
  ///
  /// @param parent  Required. Parent resource name.
  ///  The format of this value varies depending on whether you have [specified
  ///  a processing
  ///  location](https://cloud.google.com/dlp/docs/specifying-location):
  ///  + Projects scope, location specified:<br/>
  ///    `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
  ///  + Projects scope, no location specified (defaults to global):<br/>
  ///    `projects/`<var>PROJECT_ID</var>
  ///  The following example `parent` string specifies a parent project with the
  ///  identifier `example-project`, and specifies the `europe-west3` location
  ///  for processing data:
  ///      parent=projects/example-project/locations/europe-west3
  /// @param inspect_job  An inspection job scans a storage repository for
  /// InfoTypes.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::DlpJob,google/privacy/dlp/v2/dlp.proto#L3582}
  ///
  /// [google.privacy.dlp.v2.CreateDlpJobRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3415}
  /// [google.privacy.dlp.v2.DlpJob]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3582}
  ///
  StatusOr<google::privacy::dlp::v2::DlpJob> CreateDlpJob(
      std::string const& parent,
      google::privacy::dlp::v2::InspectJobConfig const& inspect_job,
      Options options = {});

  ///
  /// Creates a new job to inspect storage or calculate risk metrics.
  /// See https://cloud.google.com/dlp/docs/inspecting-storage and
  /// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
  ///
  /// When no InfoTypes or CustomInfoTypes are specified in inspect jobs, the
  /// system will automatically choose what detectors to run. By default this
  /// may be all types, but may change over time as detectors are updated.
  ///
  /// @param parent  Required. Parent resource name.
  ///  The format of this value varies depending on whether you have [specified
  ///  a processing
  ///  location](https://cloud.google.com/dlp/docs/specifying-location):
  ///  + Projects scope, location specified:<br/>
  ///    `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
  ///  + Projects scope, no location specified (defaults to global):<br/>
  ///    `projects/`<var>PROJECT_ID</var>
  ///  The following example `parent` string specifies a parent project with the
  ///  identifier `example-project`, and specifies the `europe-west3` location
  ///  for processing data:
  ///      parent=projects/example-project/locations/europe-west3
  /// @param risk_job  A risk analysis job calculates re-identification risk
  /// metrics for a
  ///  BigQuery table.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::DlpJob,google/privacy/dlp/v2/dlp.proto#L3582}
  ///
  /// [google.privacy.dlp.v2.CreateDlpJobRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3415}
  /// [google.privacy.dlp.v2.DlpJob]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3582}
  ///
  StatusOr<google::privacy::dlp::v2::DlpJob> CreateDlpJob(
      std::string const& parent,
      google::privacy::dlp::v2::RiskAnalysisJobConfig const& risk_job,
      Options options = {});

  ///
  /// Creates a new job to inspect storage or calculate risk metrics.
  /// See https://cloud.google.com/dlp/docs/inspecting-storage and
  /// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
  ///
  /// When no InfoTypes or CustomInfoTypes are specified in inspect jobs, the
  /// system will automatically choose what detectors to run. By default this
  /// may be all types, but may change over time as detectors are updated.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::CreateDlpJobRequest,google/privacy/dlp/v2/dlp.proto#L3415}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::DlpJob,google/privacy/dlp/v2/dlp.proto#L3582}
  ///
  /// [google.privacy.dlp.v2.CreateDlpJobRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3415}
  /// [google.privacy.dlp.v2.DlpJob]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3582}
  ///
  StatusOr<google::privacy::dlp::v2::DlpJob> CreateDlpJob(
      google::privacy::dlp::v2::CreateDlpJobRequest const& request,
      Options options = {});

  ///
  /// Lists DlpJobs that match the specified filter in the request.
  /// See https://cloud.google.com/dlp/docs/inspecting-storage and
  /// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
  ///
  /// @param parent  Required. Parent resource name.
  ///  The format of this value varies depending on whether you have [specified
  ///  a processing
  ///  location](https://cloud.google.com/dlp/docs/specifying-location):
  ///  + Projects scope, location specified:<br/>
  ///    `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
  ///  + Projects scope, no location specified (defaults to global):<br/>
  ///    `projects/`<var>PROJECT_ID</var>
  ///  The following example `parent` string specifies a parent project with the
  ///  identifier `example-project`, and specifies the `europe-west3` location
  ///  for processing data:
  ///      parent=projects/example-project/locations/europe-west3
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::DlpJob,google/privacy/dlp/v2/dlp.proto#L3582}
  ///
  /// [google.privacy.dlp.v2.ListDlpJobsRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3663}
  /// [google.privacy.dlp.v2.DlpJob]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3582}
  ///
  StreamRange<google::privacy::dlp::v2::DlpJob> ListDlpJobs(
      std::string const& parent, Options options = {});

  ///
  /// Lists DlpJobs that match the specified filter in the request.
  /// See https://cloud.google.com/dlp/docs/inspecting-storage and
  /// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::ListDlpJobsRequest,google/privacy/dlp/v2/dlp.proto#L3663}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::DlpJob,google/privacy/dlp/v2/dlp.proto#L3582}
  ///
  /// [google.privacy.dlp.v2.ListDlpJobsRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3663}
  /// [google.privacy.dlp.v2.DlpJob]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3582}
  ///
  StreamRange<google::privacy::dlp::v2::DlpJob> ListDlpJobs(
      google::privacy::dlp::v2::ListDlpJobsRequest request,
      Options options = {});

  ///
  /// Gets the latest state of a long-running DlpJob.
  /// See https://cloud.google.com/dlp/docs/inspecting-storage and
  /// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
  ///
  /// @param name  Required. The name of the DlpJob resource.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::DlpJob,google/privacy/dlp/v2/dlp.proto#L3582}
  ///
  /// [google.privacy.dlp.v2.GetDlpJobRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3652}
  /// [google.privacy.dlp.v2.DlpJob]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3582}
  ///
  StatusOr<google::privacy::dlp::v2::DlpJob> GetDlpJob(std::string const& name,
                                                       Options options = {});

  ///
  /// Gets the latest state of a long-running DlpJob.
  /// See https://cloud.google.com/dlp/docs/inspecting-storage and
  /// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::GetDlpJobRequest,google/privacy/dlp/v2/dlp.proto#L3652}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::DlpJob,google/privacy/dlp/v2/dlp.proto#L3582}
  ///
  /// [google.privacy.dlp.v2.GetDlpJobRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3652}
  /// [google.privacy.dlp.v2.DlpJob]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3582}
  ///
  StatusOr<google::privacy::dlp::v2::DlpJob> GetDlpJob(
      google::privacy::dlp::v2::GetDlpJobRequest const& request,
      Options options = {});

  ///
  /// Deletes a long-running DlpJob. This method indicates that the client is
  /// no longer interested in the DlpJob result. The job will be cancelled if
  /// possible.
  /// See https://cloud.google.com/dlp/docs/inspecting-storage and
  /// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
  ///
  /// @param name  Required. The name of the DlpJob resource to be deleted.
  /// @param options  Optional. Operation options.
  ///
  /// [google.privacy.dlp.v2.DeleteDlpJobRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3777}
  ///
  Status DeleteDlpJob(std::string const& name, Options options = {});

  ///
  /// Deletes a long-running DlpJob. This method indicates that the client is
  /// no longer interested in the DlpJob result. The job will be cancelled if
  /// possible.
  /// See https://cloud.google.com/dlp/docs/inspecting-storage and
  /// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::DeleteDlpJobRequest,google/privacy/dlp/v2/dlp.proto#L3777}
  /// @param options  Optional. Operation options.
  ///
  /// [google.privacy.dlp.v2.DeleteDlpJobRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3777}
  ///
  Status DeleteDlpJob(
      google::privacy::dlp::v2::DeleteDlpJobRequest const& request,
      Options options = {});

  ///
  /// Starts asynchronous cancellation on a long-running DlpJob. The server
  /// makes a best effort to cancel the DlpJob, but success is not
  /// guaranteed.
  /// See https://cloud.google.com/dlp/docs/inspecting-storage and
  /// https://cloud.google.com/dlp/docs/compute-risk-analysis to learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::CancelDlpJobRequest,google/privacy/dlp/v2/dlp.proto#L3755}
  /// @param options  Optional. Operation options.
  ///
  /// [google.privacy.dlp.v2.CancelDlpJobRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3755}
  ///
  Status CancelDlpJob(
      google::privacy::dlp::v2::CancelDlpJobRequest const& request,
      Options options = {});

  ///
  /// Creates a pre-built stored infoType to be used for inspection.
  /// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
  /// learn more.
  ///
  /// @param parent  Required. Parent resource name.
  ///  The format of this value varies depending on the scope of the request
  ///  (project or organization) and whether you have [specified a processing
  ///  location](https://cloud.google.com/dlp/docs/specifying-location):
  ///  + Projects scope, location specified:<br/>
  ///    `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
  ///  + Projects scope, no location specified (defaults to global):<br/>
  ///    `projects/`<var>PROJECT_ID</var>
  ///  + Organizations scope, location specified:<br/>
  ///    `organizations/`<var>ORG_ID</var>`/locations/`<var>LOCATION_ID</var>
  ///  + Organizations scope, no location specified (defaults to global):<br/>
  ///    `organizations/`<var>ORG_ID</var>
  ///  The following example `parent` string specifies a parent project with the
  ///  identifier `example-project`, and specifies the `europe-west3` location
  ///  for processing data:
  ///      parent=projects/example-project/locations/europe-west3
  /// @param config  Required. Configuration of the storedInfoType to create.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::StoredInfoType,google/privacy/dlp/v2/dlp.proto#L4036}
  ///
  /// [google.privacy.dlp.v2.CreateStoredInfoTypeRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4057}
  /// [google.privacy.dlp.v2.StoredInfoType]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4036}
  ///
  StatusOr<google::privacy::dlp::v2::StoredInfoType> CreateStoredInfoType(
      std::string const& parent,
      google::privacy::dlp::v2::StoredInfoTypeConfig const& config,
      Options options = {});

  ///
  /// Creates a pre-built stored infoType to be used for inspection.
  /// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
  /// learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::CreateStoredInfoTypeRequest,google/privacy/dlp/v2/dlp.proto#L4057}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::StoredInfoType,google/privacy/dlp/v2/dlp.proto#L4036}
  ///
  /// [google.privacy.dlp.v2.CreateStoredInfoTypeRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4057}
  /// [google.privacy.dlp.v2.StoredInfoType]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4036}
  ///
  StatusOr<google::privacy::dlp::v2::StoredInfoType> CreateStoredInfoType(
      google::privacy::dlp::v2::CreateStoredInfoTypeRequest const& request,
      Options options = {});

  ///
  /// Updates the stored infoType by creating a new version. The existing
  /// version will continue to be used until the new version is ready. See
  /// https://cloud.google.com/dlp/docs/creating-stored-infotypes to learn more.
  ///
  /// @param name  Required. Resource name of organization and storedInfoType to
  /// be updated, for
  ///  example `organizations/433245324/storedInfoTypes/432452342` or
  ///  projects/project-id/storedInfoTypes/432452342.
  /// @param config  Updated configuration for the storedInfoType. If not
  /// provided, a new
  ///  version of the storedInfoType will be created with the existing
  ///  configuration.
  /// @param update_mask  Mask to control which fields get updated.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::StoredInfoType,google/privacy/dlp/v2/dlp.proto#L4036}
  ///
  /// [google.privacy.dlp.v2.UpdateStoredInfoTypeRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4099}
  /// [google.privacy.dlp.v2.StoredInfoType]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4036}
  ///
  StatusOr<google::privacy::dlp::v2::StoredInfoType> UpdateStoredInfoType(
      std::string const& name,
      google::privacy::dlp::v2::StoredInfoTypeConfig const& config,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates the stored infoType by creating a new version. The existing
  /// version will continue to be used until the new version is ready. See
  /// https://cloud.google.com/dlp/docs/creating-stored-infotypes to learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::UpdateStoredInfoTypeRequest,google/privacy/dlp/v2/dlp.proto#L4099}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::StoredInfoType,google/privacy/dlp/v2/dlp.proto#L4036}
  ///
  /// [google.privacy.dlp.v2.UpdateStoredInfoTypeRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4099}
  /// [google.privacy.dlp.v2.StoredInfoType]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4036}
  ///
  StatusOr<google::privacy::dlp::v2::StoredInfoType> UpdateStoredInfoType(
      google::privacy::dlp::v2::UpdateStoredInfoTypeRequest const& request,
      Options options = {});

  ///
  /// Gets a stored infoType.
  /// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
  /// learn more.
  ///
  /// @param name  Required. Resource name of the organization and
  /// storedInfoType to be read, for
  ///  example `organizations/433245324/storedInfoTypes/432452342` or
  ///  projects/project-id/storedInfoTypes/432452342.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::StoredInfoType,google/privacy/dlp/v2/dlp.proto#L4036}
  ///
  /// [google.privacy.dlp.v2.GetStoredInfoTypeRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4120}
  /// [google.privacy.dlp.v2.StoredInfoType]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4036}
  ///
  StatusOr<google::privacy::dlp::v2::StoredInfoType> GetStoredInfoType(
      std::string const& name, Options options = {});

  ///
  /// Gets a stored infoType.
  /// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
  /// learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::GetStoredInfoTypeRequest,google/privacy/dlp/v2/dlp.proto#L4120}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::StoredInfoType,google/privacy/dlp/v2/dlp.proto#L4036}
  ///
  /// [google.privacy.dlp.v2.GetStoredInfoTypeRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4120}
  /// [google.privacy.dlp.v2.StoredInfoType]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4036}
  ///
  StatusOr<google::privacy::dlp::v2::StoredInfoType> GetStoredInfoType(
      google::privacy::dlp::v2::GetStoredInfoTypeRequest const& request,
      Options options = {});

  ///
  /// Lists stored infoTypes.
  /// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
  /// learn more.
  ///
  /// @param parent  Required. Parent resource name.
  ///  The format of this value varies depending on the scope of the request
  ///  (project or organization) and whether you have [specified a processing
  ///  location](https://cloud.google.com/dlp/docs/specifying-location):
  ///  + Projects scope, location specified:<br/>
  ///    `projects/`<var>PROJECT_ID</var>`/locations/`<var>LOCATION_ID</var>
  ///  + Projects scope, no location specified (defaults to global):<br/>
  ///    `projects/`<var>PROJECT_ID</var>
  ///  + Organizations scope, location specified:<br/>
  ///    `organizations/`<var>ORG_ID</var>`/locations/`<var>LOCATION_ID</var>
  ///  + Organizations scope, no location specified (defaults to global):<br/>
  ///    `organizations/`<var>ORG_ID</var>
  ///  The following example `parent` string specifies a parent project with the
  ///  identifier `example-project`, and specifies the `europe-west3` location
  ///  for processing data:
  ///      parent=projects/example-project/locations/europe-west3
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::StoredInfoType,google/privacy/dlp/v2/dlp.proto#L4036}
  ///
  /// [google.privacy.dlp.v2.ListStoredInfoTypesRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4133}
  /// [google.privacy.dlp.v2.StoredInfoType]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4036}
  ///
  StreamRange<google::privacy::dlp::v2::StoredInfoType> ListStoredInfoTypes(
      std::string const& parent, Options options = {});

  ///
  /// Lists stored infoTypes.
  /// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
  /// learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::ListStoredInfoTypesRequest,google/privacy/dlp/v2/dlp.proto#L4133}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::StoredInfoType,google/privacy/dlp/v2/dlp.proto#L4036}
  ///
  /// [google.privacy.dlp.v2.ListStoredInfoTypesRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4133}
  /// [google.privacy.dlp.v2.StoredInfoType]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4036}
  ///
  StreamRange<google::privacy::dlp::v2::StoredInfoType> ListStoredInfoTypes(
      google::privacy::dlp::v2::ListStoredInfoTypesRequest request,
      Options options = {});

  ///
  /// Deletes a stored infoType.
  /// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
  /// learn more.
  ///
  /// @param name  Required. Resource name of the organization and
  /// storedInfoType to be deleted, for
  ///  example `organizations/433245324/storedInfoTypes/432452342` or
  ///  projects/project-id/storedInfoTypes/432452342.
  /// @param options  Optional. Operation options.
  ///
  /// [google.privacy.dlp.v2.DeleteStoredInfoTypeRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4200}
  ///
  Status DeleteStoredInfoType(std::string const& name, Options options = {});

  ///
  /// Deletes a stored infoType.
  /// See https://cloud.google.com/dlp/docs/creating-stored-infotypes to
  /// learn more.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::DeleteStoredInfoTypeRequest,google/privacy/dlp/v2/dlp.proto#L4200}
  /// @param options  Optional. Operation options.
  ///
  /// [google.privacy.dlp.v2.DeleteStoredInfoTypeRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4200}
  ///
  Status DeleteStoredInfoType(
      google::privacy::dlp::v2::DeleteStoredInfoTypeRequest const& request,
      Options options = {});

  ///
  /// Inspect hybrid content and store findings to a job.
  /// To review the findings, inspect the job. Inspection will occur
  /// asynchronously.
  ///
  /// @param name  Required. Resource name of the job to execute a hybrid
  /// inspect on, for example
  ///  `projects/dlp-test-project/dlpJob/53234423`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::HybridInspectResponse,google/privacy/dlp/v2/dlp.proto#L4295}
  ///
  /// [google.privacy.dlp.v2.HybridInspectDlpJobRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4228}
  /// [google.privacy.dlp.v2.HybridInspectResponse]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4295}
  ///
  StatusOr<google::privacy::dlp::v2::HybridInspectResponse> HybridInspectDlpJob(
      std::string const& name, Options options = {});

  ///
  /// Inspect hybrid content and store findings to a job.
  /// To review the findings, inspect the job. Inspection will occur
  /// asynchronously.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::HybridInspectDlpJobRequest,google/privacy/dlp/v2/dlp.proto#L4228}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::privacy::dlp::v2::HybridInspectResponse,google/privacy/dlp/v2/dlp.proto#L4295}
  ///
  /// [google.privacy.dlp.v2.HybridInspectDlpJobRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4228}
  /// [google.privacy.dlp.v2.HybridInspectResponse]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L4295}
  ///
  StatusOr<google::privacy::dlp::v2::HybridInspectResponse> HybridInspectDlpJob(
      google::privacy::dlp::v2::HybridInspectDlpJobRequest const& request,
      Options options = {});

  ///
  /// Finish a running hybrid DlpJob. Triggers the finalization steps and
  /// running of any enabled actions that have not yet run.
  ///
  /// @param request
  /// @googleapis_link{google::privacy::dlp::v2::FinishDlpJobRequest,google/privacy/dlp/v2/dlp.proto#L3766}
  /// @param options  Optional. Operation options.
  ///
  /// [google.privacy.dlp.v2.FinishDlpJobRequest]:
  /// @googleapis_reference_link{google/privacy/dlp/v2/dlp.proto#L3766}
  ///
  Status FinishDlpJob(
      google::privacy::dlp::v2::FinishDlpJobRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<DlpServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dlp
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DLP_DLP_CLIENT_H
