// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/clouddebugger/v2/debugger.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DEBUGGER_INTERNAL_DEBUGGER2_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DEBUGGER_INTERNAL_DEBUGGER2_STUB_H

#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/devtools/clouddebugger/v2/debugger.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace debugger_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class Debugger2Stub {
 public:
  virtual ~Debugger2Stub() = 0;

  virtual StatusOr<google::devtools::clouddebugger::v2::SetBreakpointResponse>
  SetBreakpoint(grpc::ClientContext& context,
                google::devtools::clouddebugger::v2::SetBreakpointRequest const&
                    request) = 0;

  virtual StatusOr<google::devtools::clouddebugger::v2::GetBreakpointResponse>
  GetBreakpoint(grpc::ClientContext& context,
                google::devtools::clouddebugger::v2::GetBreakpointRequest const&
                    request) = 0;

  virtual Status DeleteBreakpoint(
      grpc::ClientContext& context,
      google::devtools::clouddebugger::v2::DeleteBreakpointRequest const&
          request) = 0;

  virtual StatusOr<google::devtools::clouddebugger::v2::ListBreakpointsResponse>
  ListBreakpoints(
      grpc::ClientContext& context,
      google::devtools::clouddebugger::v2::ListBreakpointsRequest const&
          request) = 0;

  virtual StatusOr<google::devtools::clouddebugger::v2::ListDebuggeesResponse>
  ListDebuggees(grpc::ClientContext& context,
                google::devtools::clouddebugger::v2::ListDebuggeesRequest const&
                    request) = 0;
};

class DefaultDebugger2Stub : public Debugger2Stub {
 public:
  explicit DefaultDebugger2Stub(
      std::unique_ptr<
          google::devtools::clouddebugger::v2::Debugger2::StubInterface>
          grpc_stub)
      : grpc_stub_(std::move(grpc_stub)) {}

  StatusOr<google::devtools::clouddebugger::v2::SetBreakpointResponse>
  SetBreakpoint(grpc::ClientContext& client_context,
                google::devtools::clouddebugger::v2::SetBreakpointRequest const&
                    request) override;

  StatusOr<google::devtools::clouddebugger::v2::GetBreakpointResponse>
  GetBreakpoint(grpc::ClientContext& client_context,
                google::devtools::clouddebugger::v2::GetBreakpointRequest const&
                    request) override;

  Status DeleteBreakpoint(
      grpc::ClientContext& client_context,
      google::devtools::clouddebugger::v2::DeleteBreakpointRequest const&
          request) override;

  StatusOr<google::devtools::clouddebugger::v2::ListBreakpointsResponse>
  ListBreakpoints(
      grpc::ClientContext& client_context,
      google::devtools::clouddebugger::v2::ListBreakpointsRequest const&
          request) override;

  StatusOr<google::devtools::clouddebugger::v2::ListDebuggeesResponse>
  ListDebuggees(grpc::ClientContext& client_context,
                google::devtools::clouddebugger::v2::ListDebuggeesRequest const&
                    request) override;

 private:
  std::unique_ptr<google::devtools::clouddebugger::v2::Debugger2::StubInterface>
      grpc_stub_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace debugger_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DEBUGGER_INTERNAL_DEBUGGER2_STUB_H
