// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/clouddebugger/v2/debugger.proto

#include "google/cloud/debugger/internal/debugger2_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/devtools/clouddebugger/v2/debugger.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace debugger_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

Debugger2Metadata::Debugger2Metadata(std::shared_ptr<Debugger2Stub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::devtools::clouddebugger::v2::SetBreakpointResponse>
Debugger2Metadata::SetBreakpoint(
    grpc::ClientContext& context,
    google::devtools::clouddebugger::v2::SetBreakpointRequest const& request) {
  SetMetadata(context, {});
  return child_->SetBreakpoint(context, request);
}

StatusOr<google::devtools::clouddebugger::v2::GetBreakpointResponse>
Debugger2Metadata::GetBreakpoint(
    grpc::ClientContext& context,
    google::devtools::clouddebugger::v2::GetBreakpointRequest const& request) {
  SetMetadata(context, {});
  return child_->GetBreakpoint(context, request);
}

Status Debugger2Metadata::DeleteBreakpoint(
    grpc::ClientContext& context,
    google::devtools::clouddebugger::v2::DeleteBreakpointRequest const&
        request) {
  SetMetadata(context, {});
  return child_->DeleteBreakpoint(context, request);
}

StatusOr<google::devtools::clouddebugger::v2::ListBreakpointsResponse>
Debugger2Metadata::ListBreakpoints(
    grpc::ClientContext& context,
    google::devtools::clouddebugger::v2::ListBreakpointsRequest const&
        request) {
  SetMetadata(context, {});
  return child_->ListBreakpoints(context, request);
}

StatusOr<google::devtools::clouddebugger::v2::ListDebuggeesResponse>
Debugger2Metadata::ListDebuggees(
    grpc::ClientContext& context,
    google::devtools::clouddebugger::v2::ListDebuggeesRequest const& request) {
  SetMetadata(context, {});
  return child_->ListDebuggees(context, request);
}

void Debugger2Metadata::SetMetadata(grpc::ClientContext& context,
                                    std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void Debugger2Metadata::SetMetadata(grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace debugger_internal
}  // namespace cloud
}  // namespace google
