// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/clouddebugger/v2/controller.proto

#include "google/cloud/debugger/internal/controller2_connection_impl.h"
#include "google/cloud/debugger/internal/controller2_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace debugger_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

Controller2ConnectionImpl::Controller2ConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<debugger_internal::Controller2Stub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), debugger_internal::Controller2DefaultOptions(
                                  Controller2Connection::options()))) {}

StatusOr<google::devtools::clouddebugger::v2::RegisterDebuggeeResponse>
Controller2ConnectionImpl::RegisterDebuggee(
    google::devtools::clouddebugger::v2::RegisterDebuggeeRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->RegisterDebuggee(request),
      [this](grpc::ClientContext& context,
             google::devtools::clouddebugger::v2::RegisterDebuggeeRequest const&
                 request) { return stub_->RegisterDebuggee(context, request); },
      request, __func__);
}

StatusOr<google::devtools::clouddebugger::v2::ListActiveBreakpointsResponse>
Controller2ConnectionImpl::ListActiveBreakpoints(
    google::devtools::clouddebugger::v2::ListActiveBreakpointsRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->ListActiveBreakpoints(request),
      [this](grpc::ClientContext& context,
             google::devtools::clouddebugger::v2::
                 ListActiveBreakpointsRequest const& request) {
        return stub_->ListActiveBreakpoints(context, request);
      },
      request, __func__);
}

StatusOr<google::devtools::clouddebugger::v2::UpdateActiveBreakpointResponse>
Controller2ConnectionImpl::UpdateActiveBreakpoint(
    google::devtools::clouddebugger::v2::UpdateActiveBreakpointRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateActiveBreakpoint(request),
      [this](grpc::ClientContext& context,
             google::devtools::clouddebugger::v2::
                 UpdateActiveBreakpointRequest const& request) {
        return stub_->UpdateActiveBreakpoint(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace debugger_internal
}  // namespace cloud
}  // namespace google
