// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/clouddebugger/v2/controller.proto

#include "google/cloud/debugger/internal/controller2_auth_decorator.h"
#include <google/devtools/clouddebugger/v2/controller.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace debugger_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

Controller2Auth::Controller2Auth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<Controller2Stub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::devtools::clouddebugger::v2::RegisterDebuggeeResponse>
Controller2Auth::RegisterDebuggee(
    grpc::ClientContext& context,
    google::devtools::clouddebugger::v2::RegisterDebuggeeRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->RegisterDebuggee(context, request);
}

StatusOr<google::devtools::clouddebugger::v2::ListActiveBreakpointsResponse>
Controller2Auth::ListActiveBreakpoints(
    grpc::ClientContext& context,
    google::devtools::clouddebugger::v2::ListActiveBreakpointsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListActiveBreakpoints(context, request);
}

StatusOr<google::devtools::clouddebugger::v2::UpdateActiveBreakpointResponse>
Controller2Auth::UpdateActiveBreakpoint(
    grpc::ClientContext& context,
    google::devtools::clouddebugger::v2::UpdateActiveBreakpointRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateActiveBreakpoint(context, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace debugger_internal
}  // namespace cloud
}  // namespace google
