// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/clouddebugger/v2/debugger.proto

#include "google/cloud/debugger/debugger2_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace debugger {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

Debugger2ConnectionIdempotencyPolicy::~Debugger2ConnectionIdempotencyPolicy() =
    default;

namespace {
class DefaultDebugger2ConnectionIdempotencyPolicy
    : public Debugger2ConnectionIdempotencyPolicy {
 public:
  ~DefaultDebugger2ConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<Debugger2ConnectionIdempotencyPolicy> clone() const override {
    return absl::make_unique<DefaultDebugger2ConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency SetBreakpoint(
      google::devtools::clouddebugger::v2::SetBreakpointRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetBreakpoint(
      google::devtools::clouddebugger::v2::GetBreakpointRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency DeleteBreakpoint(
      google::devtools::clouddebugger::v2::DeleteBreakpointRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListBreakpoints(
      google::devtools::clouddebugger::v2::ListBreakpointsRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListDebuggees(
      google::devtools::clouddebugger::v2::ListDebuggeesRequest const&)
      override {
    return Idempotency::kIdempotent;
  }
};
}  // namespace

std::unique_ptr<Debugger2ConnectionIdempotencyPolicy>
MakeDefaultDebugger2ConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultDebugger2ConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace debugger
}  // namespace cloud
}  // namespace google
