// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/clouddebugger/v2/debugger.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DEBUGGER_DEBUGGER2_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DEBUGGER_DEBUGGER2_CLIENT_H

#include "google/cloud/debugger/debugger2_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace debugger {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The Debugger service provides the API that allows users to collect run-time
/// information from a running application, without stopping or slowing it down
/// and without modifying its state.  An application may include one or
/// more replicated processes performing the same work.
///
/// A debugged application is represented using the Debuggee concept. The
/// Debugger service provides a way to query for available debuggees, but does
/// not provide a way to create one.  A debuggee is created using the Controller
/// service, usually by running a debugger agent with the application.
///
/// The Debugger service enables the client to set one or more Breakpoints on a
/// Debuggee and collect the results of the set Breakpoints.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class Debugger2Client {
 public:
  explicit Debugger2Client(std::shared_ptr<Debugger2Connection> connection,
                           Options options = {});
  ~Debugger2Client();

  //@{
  // @name Copy and move support
  Debugger2Client(Debugger2Client const&) = default;
  Debugger2Client& operator=(Debugger2Client const&) = default;
  Debugger2Client(Debugger2Client&&) = default;
  Debugger2Client& operator=(Debugger2Client&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(Debugger2Client const& a, Debugger2Client const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(Debugger2Client const& a, Debugger2Client const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Sets the breakpoint to the debuggee.
  ///
  /// @param debuggee_id  Required. ID of the debuggee where the breakpoint is
  /// to be set.
  /// @param breakpoint  Required. Breakpoint specification to set.
  ///  The field `location` of the breakpoint must be set.
  /// @param client_version  Required. The client version making the call.
  ///  Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::clouddebugger::v2::SetBreakpointResponse,google/devtools/clouddebugger/v2/debugger.proto#L109}
  ///
  /// [google.devtools.clouddebugger.v2.SetBreakpointRequest]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L95}
  /// [google.devtools.clouddebugger.v2.SetBreakpointResponse]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L109}
  ///
  StatusOr<google::devtools::clouddebugger::v2::SetBreakpointResponse>
  SetBreakpoint(
      std::string const& debuggee_id,
      google::devtools::clouddebugger::v2::Breakpoint const& breakpoint,
      std::string const& client_version, Options options = {});

  ///
  /// Sets the breakpoint to the debuggee.
  ///
  /// @param request
  /// @googleapis_link{google::devtools::clouddebugger::v2::SetBreakpointRequest,google/devtools/clouddebugger/v2/debugger.proto#L95}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::clouddebugger::v2::SetBreakpointResponse,google/devtools/clouddebugger/v2/debugger.proto#L109}
  ///
  /// [google.devtools.clouddebugger.v2.SetBreakpointRequest]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L95}
  /// [google.devtools.clouddebugger.v2.SetBreakpointResponse]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L109}
  ///
  StatusOr<google::devtools::clouddebugger::v2::SetBreakpointResponse>
  SetBreakpoint(
      google::devtools::clouddebugger::v2::SetBreakpointRequest const& request,
      Options options = {});

  ///
  /// Gets breakpoint information.
  ///
  /// @param debuggee_id  Required. ID of the debuggee whose breakpoint to get.
  /// @param breakpoint_id  Required. ID of the breakpoint to get.
  /// @param client_version  Required. The client version making the call.
  ///  Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::clouddebugger::v2::GetBreakpointResponse,google/devtools/clouddebugger/v2/debugger.proto#L129}
  ///
  /// [google.devtools.clouddebugger.v2.GetBreakpointRequest]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L116}
  /// [google.devtools.clouddebugger.v2.GetBreakpointResponse]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L129}
  ///
  StatusOr<google::devtools::clouddebugger::v2::GetBreakpointResponse>
  GetBreakpoint(std::string const& debuggee_id,
                std::string const& breakpoint_id,
                std::string const& client_version, Options options = {});

  ///
  /// Gets breakpoint information.
  ///
  /// @param request
  /// @googleapis_link{google::devtools::clouddebugger::v2::GetBreakpointRequest,google/devtools/clouddebugger/v2/debugger.proto#L116}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::clouddebugger::v2::GetBreakpointResponse,google/devtools/clouddebugger/v2/debugger.proto#L129}
  ///
  /// [google.devtools.clouddebugger.v2.GetBreakpointRequest]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L116}
  /// [google.devtools.clouddebugger.v2.GetBreakpointResponse]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L129}
  ///
  StatusOr<google::devtools::clouddebugger::v2::GetBreakpointResponse>
  GetBreakpoint(
      google::devtools::clouddebugger::v2::GetBreakpointRequest const& request,
      Options options = {});

  ///
  /// Deletes the breakpoint from the debuggee.
  ///
  /// @param debuggee_id  Required. ID of the debuggee whose breakpoint to
  /// delete.
  /// @param breakpoint_id  Required. ID of the breakpoint to delete.
  /// @param client_version  Required. The client version making the call.
  ///  Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
  /// @param options  Optional. Operation options.
  ///
  /// [google.devtools.clouddebugger.v2.DeleteBreakpointRequest]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L136}
  ///
  Status DeleteBreakpoint(std::string const& debuggee_id,
                          std::string const& breakpoint_id,
                          std::string const& client_version,
                          Options options = {});

  ///
  /// Deletes the breakpoint from the debuggee.
  ///
  /// @param request
  /// @googleapis_link{google::devtools::clouddebugger::v2::DeleteBreakpointRequest,google/devtools/clouddebugger/v2/debugger.proto#L136}
  /// @param options  Optional. Operation options.
  ///
  /// [google.devtools.clouddebugger.v2.DeleteBreakpointRequest]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L136}
  ///
  Status DeleteBreakpoint(
      google::devtools::clouddebugger::v2::DeleteBreakpointRequest const&
          request,
      Options options = {});

  ///
  /// Lists all breakpoints for the debuggee.
  ///
  /// @param debuggee_id  Required. ID of the debuggee whose breakpoints to
  /// list.
  /// @param client_version  Required. The client version making the call.
  ///  Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::clouddebugger::v2::ListBreakpointsResponse,google/devtools/clouddebugger/v2/debugger.proto#L188}
  ///
  /// [google.devtools.clouddebugger.v2.ListBreakpointsRequest]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L149}
  /// [google.devtools.clouddebugger.v2.ListBreakpointsResponse]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L188}
  ///
  StatusOr<google::devtools::clouddebugger::v2::ListBreakpointsResponse>
  ListBreakpoints(std::string const& debuggee_id,
                  std::string const& client_version, Options options = {});

  ///
  /// Lists all breakpoints for the debuggee.
  ///
  /// @param request
  /// @googleapis_link{google::devtools::clouddebugger::v2::ListBreakpointsRequest,google/devtools/clouddebugger/v2/debugger.proto#L149}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::clouddebugger::v2::ListBreakpointsResponse,google/devtools/clouddebugger/v2/debugger.proto#L188}
  ///
  /// [google.devtools.clouddebugger.v2.ListBreakpointsRequest]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L149}
  /// [google.devtools.clouddebugger.v2.ListBreakpointsResponse]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L188}
  ///
  StatusOr<google::devtools::clouddebugger::v2::ListBreakpointsResponse>
  ListBreakpoints(
      google::devtools::clouddebugger::v2::ListBreakpointsRequest const&
          request,
      Options options = {});

  ///
  /// Lists all the debuggees that the user has access to.
  ///
  /// @param project  Required. Project number of a Google Cloud project whose
  /// debuggees to list.
  /// @param client_version  Required. The client version making the call.
  ///  Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::clouddebugger::v2::ListDebuggeesResponse,google/devtools/clouddebugger/v2/debugger.proto#L215}
  ///
  /// [google.devtools.clouddebugger.v2.ListDebuggeesRequest]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L201}
  /// [google.devtools.clouddebugger.v2.ListDebuggeesResponse]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L215}
  ///
  StatusOr<google::devtools::clouddebugger::v2::ListDebuggeesResponse>
  ListDebuggees(std::string const& project, std::string const& client_version,
                Options options = {});

  ///
  /// Lists all the debuggees that the user has access to.
  ///
  /// @param request
  /// @googleapis_link{google::devtools::clouddebugger::v2::ListDebuggeesRequest,google/devtools/clouddebugger/v2/debugger.proto#L201}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::clouddebugger::v2::ListDebuggeesResponse,google/devtools/clouddebugger/v2/debugger.proto#L215}
  ///
  /// [google.devtools.clouddebugger.v2.ListDebuggeesRequest]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L201}
  /// [google.devtools.clouddebugger.v2.ListDebuggeesResponse]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/debugger.proto#L215}
  ///
  StatusOr<google::devtools::clouddebugger::v2::ListDebuggeesResponse>
  ListDebuggees(
      google::devtools::clouddebugger::v2::ListDebuggeesRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<Debugger2Connection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace debugger
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DEBUGGER_DEBUGGER2_CLIENT_H
