// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/clouddebugger/v2/debugger.proto

#include "google/cloud/debugger/debugger2_client.h"
#include "google/cloud/debugger/internal/debugger2_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace debugger {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

Debugger2Client::Debugger2Client(
    std::shared_ptr<Debugger2Connection> connection, Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options),
          debugger_internal::Debugger2DefaultOptions(connection_->options()))) {
}
Debugger2Client::~Debugger2Client() = default;

StatusOr<google::devtools::clouddebugger::v2::SetBreakpointResponse>
Debugger2Client::SetBreakpoint(
    std::string const& debuggee_id,
    google::devtools::clouddebugger::v2::Breakpoint const& breakpoint,
    std::string const& client_version, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::devtools::clouddebugger::v2::SetBreakpointRequest request;
  request.set_debuggee_id(debuggee_id);
  *request.mutable_breakpoint() = breakpoint;
  request.set_client_version(client_version);
  return connection_->SetBreakpoint(request);
}

StatusOr<google::devtools::clouddebugger::v2::SetBreakpointResponse>
Debugger2Client::SetBreakpoint(
    google::devtools::clouddebugger::v2::SetBreakpointRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->SetBreakpoint(request);
}

StatusOr<google::devtools::clouddebugger::v2::GetBreakpointResponse>
Debugger2Client::GetBreakpoint(std::string const& debuggee_id,
                               std::string const& breakpoint_id,
                               std::string const& client_version,
                               Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::devtools::clouddebugger::v2::GetBreakpointRequest request;
  request.set_debuggee_id(debuggee_id);
  request.set_breakpoint_id(breakpoint_id);
  request.set_client_version(client_version);
  return connection_->GetBreakpoint(request);
}

StatusOr<google::devtools::clouddebugger::v2::GetBreakpointResponse>
Debugger2Client::GetBreakpoint(
    google::devtools::clouddebugger::v2::GetBreakpointRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetBreakpoint(request);
}

Status Debugger2Client::DeleteBreakpoint(std::string const& debuggee_id,
                                         std::string const& breakpoint_id,
                                         std::string const& client_version,
                                         Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::devtools::clouddebugger::v2::DeleteBreakpointRequest request;
  request.set_debuggee_id(debuggee_id);
  request.set_breakpoint_id(breakpoint_id);
  request.set_client_version(client_version);
  return connection_->DeleteBreakpoint(request);
}

Status Debugger2Client::DeleteBreakpoint(
    google::devtools::clouddebugger::v2::DeleteBreakpointRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteBreakpoint(request);
}

StatusOr<google::devtools::clouddebugger::v2::ListBreakpointsResponse>
Debugger2Client::ListBreakpoints(std::string const& debuggee_id,
                                 std::string const& client_version,
                                 Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::devtools::clouddebugger::v2::ListBreakpointsRequest request;
  request.set_debuggee_id(debuggee_id);
  request.set_client_version(client_version);
  return connection_->ListBreakpoints(request);
}

StatusOr<google::devtools::clouddebugger::v2::ListBreakpointsResponse>
Debugger2Client::ListBreakpoints(
    google::devtools::clouddebugger::v2::ListBreakpointsRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListBreakpoints(request);
}

StatusOr<google::devtools::clouddebugger::v2::ListDebuggeesResponse>
Debugger2Client::ListDebuggees(std::string const& project,
                               std::string const& client_version,
                               Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::devtools::clouddebugger::v2::ListDebuggeesRequest request;
  request.set_project(project);
  request.set_client_version(client_version);
  return connection_->ListDebuggees(request);
}

StatusOr<google::devtools::clouddebugger::v2::ListDebuggeesResponse>
Debugger2Client::ListDebuggees(
    google::devtools::clouddebugger::v2::ListDebuggeesRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListDebuggees(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace debugger
}  // namespace cloud
}  // namespace google
