// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/clouddebugger/v2/controller.proto

#include "google/cloud/debugger/controller2_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace debugger {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

Controller2ConnectionIdempotencyPolicy::
    ~Controller2ConnectionIdempotencyPolicy() = default;

namespace {
class DefaultController2ConnectionIdempotencyPolicy
    : public Controller2ConnectionIdempotencyPolicy {
 public:
  ~DefaultController2ConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<Controller2ConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultController2ConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency RegisterDebuggee(
      google::devtools::clouddebugger::v2::RegisterDebuggeeRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListActiveBreakpoints(
      google::devtools::clouddebugger::v2::ListActiveBreakpointsRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateActiveBreakpoint(
      google::devtools::clouddebugger::v2::UpdateActiveBreakpointRequest const&)
      override {
    return Idempotency::kIdempotent;
  }
};
}  // namespace

std::unique_ptr<Controller2ConnectionIdempotencyPolicy>
MakeDefaultController2ConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultController2ConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace debugger
}  // namespace cloud
}  // namespace google
