// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/clouddebugger/v2/controller.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DEBUGGER_CONTROLLER2_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DEBUGGER_CONTROLLER2_CLIENT_H

#include "google/cloud/debugger/controller2_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace debugger {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The Controller service provides the API for orchestrating a collection of
/// debugger agents to perform debugging tasks. These agents are each attached
/// to a process of an application which may include one or more replicas.
///
/// The debugger agents register with the Controller to identify the application
/// being debugged, the Debuggee. All agents that register with the same data,
/// represent the same Debuggee, and are assigned the same `debuggee_id`.
///
/// The debugger agents call the Controller to retrieve  the list of active
/// Breakpoints. Agents with the same `debuggee_id` get the same breakpoints
/// list. An agent that can fulfill the breakpoint request updates the
/// Controller with the breakpoint result. The controller selects the first
/// result received and discards the rest of the results.
/// Agents that poll again for active breakpoints will no longer have
/// the completed breakpoint in the list and should remove that breakpoint from
/// their attached process.
///
/// The Controller service does not provide a way to retrieve the results of
/// a completed breakpoint. This functionality is available using the Debugger
/// service.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class Controller2Client {
 public:
  explicit Controller2Client(std::shared_ptr<Controller2Connection> connection,
                             Options options = {});
  ~Controller2Client();

  //@{
  // @name Copy and move support
  Controller2Client(Controller2Client const&) = default;
  Controller2Client& operator=(Controller2Client const&) = default;
  Controller2Client(Controller2Client&&) = default;
  Controller2Client& operator=(Controller2Client&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(Controller2Client const& a,
                         Controller2Client const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(Controller2Client const& a,
                         Controller2Client const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Registers the debuggee with the controller service.
  ///
  /// All agents attached to the same application must call this method with
  /// exactly the same request content to get back the same stable
  /// `debuggee_id`. Agents should call this method again whenever
  /// `google.rpc.Code.NOT_FOUND` is returned from any controller method.
  ///
  /// This protocol allows the controller service to disable debuggees, recover
  /// from data loss, or change the `debuggee_id` format. Agents must handle
  /// `debuggee_id` value changing upon re-registration.
  ///
  /// @param debuggee  Required. Debuggee information to register.
  ///  The fields `project`, `uniquifier`, `description` and `agent_version`
  ///  of the debuggee must be set.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::clouddebugger::v2::RegisterDebuggeeResponse,google/devtools/clouddebugger/v2/controller.proto#L124}
  ///
  /// [google.devtools.clouddebugger.v2.RegisterDebuggeeRequest]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/controller.proto#L116}
  /// [google.devtools.clouddebugger.v2.RegisterDebuggeeResponse]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/controller.proto#L124}
  ///
  StatusOr<google::devtools::clouddebugger::v2::RegisterDebuggeeResponse>
  RegisterDebuggee(
      google::devtools::clouddebugger::v2::Debuggee const& debuggee,
      Options options = {});

  ///
  /// Registers the debuggee with the controller service.
  ///
  /// All agents attached to the same application must call this method with
  /// exactly the same request content to get back the same stable
  /// `debuggee_id`. Agents should call this method again whenever
  /// `google.rpc.Code.NOT_FOUND` is returned from any controller method.
  ///
  /// This protocol allows the controller service to disable debuggees, recover
  /// from data loss, or change the `debuggee_id` format. Agents must handle
  /// `debuggee_id` value changing upon re-registration.
  ///
  /// @param request
  /// @googleapis_link{google::devtools::clouddebugger::v2::RegisterDebuggeeRequest,google/devtools/clouddebugger/v2/controller.proto#L116}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::clouddebugger::v2::RegisterDebuggeeResponse,google/devtools/clouddebugger/v2/controller.proto#L124}
  ///
  /// [google.devtools.clouddebugger.v2.RegisterDebuggeeRequest]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/controller.proto#L116}
  /// [google.devtools.clouddebugger.v2.RegisterDebuggeeResponse]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/controller.proto#L124}
  ///
  StatusOr<google::devtools::clouddebugger::v2::RegisterDebuggeeResponse>
  RegisterDebuggee(
      google::devtools::clouddebugger::v2::RegisterDebuggeeRequest const&
          request,
      Options options = {});

  ///
  /// Returns the list of all active breakpoints for the debuggee.
  ///
  /// The breakpoint specification (`location`, `condition`, and `expressions`
  /// fields) is semantically immutable, although the field values may
  /// change. For example, an agent may update the location line number
  /// to reflect the actual line where the breakpoint was set, but this
  /// doesn't change the breakpoint semantics.
  ///
  /// This means that an agent does not need to check if a breakpoint has
  /// changed when it encounters the same breakpoint on a successive call.
  /// Moreover, an agent should remember the breakpoints that are completed
  /// until the controller removes them from the active list to avoid
  /// setting those breakpoints again.
  ///
  /// @param debuggee_id  Required. Identifies the debuggee.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::clouddebugger::v2::ListActiveBreakpointsResponse,google/devtools/clouddebugger/v2/controller.proto#L154}
  ///
  /// [google.devtools.clouddebugger.v2.ListActiveBreakpointsRequest]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/controller.proto#L134}
  /// [google.devtools.clouddebugger.v2.ListActiveBreakpointsResponse]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/controller.proto#L154}
  ///
  StatusOr<google::devtools::clouddebugger::v2::ListActiveBreakpointsResponse>
  ListActiveBreakpoints(std::string const& debuggee_id, Options options = {});

  ///
  /// Returns the list of all active breakpoints for the debuggee.
  ///
  /// The breakpoint specification (`location`, `condition`, and `expressions`
  /// fields) is semantically immutable, although the field values may
  /// change. For example, an agent may update the location line number
  /// to reflect the actual line where the breakpoint was set, but this
  /// doesn't change the breakpoint semantics.
  ///
  /// This means that an agent does not need to check if a breakpoint has
  /// changed when it encounters the same breakpoint on a successive call.
  /// Moreover, an agent should remember the breakpoints that are completed
  /// until the controller removes them from the active list to avoid
  /// setting those breakpoints again.
  ///
  /// @param request
  /// @googleapis_link{google::devtools::clouddebugger::v2::ListActiveBreakpointsRequest,google/devtools/clouddebugger/v2/controller.proto#L134}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::clouddebugger::v2::ListActiveBreakpointsResponse,google/devtools/clouddebugger/v2/controller.proto#L154}
  ///
  /// [google.devtools.clouddebugger.v2.ListActiveBreakpointsRequest]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/controller.proto#L134}
  /// [google.devtools.clouddebugger.v2.ListActiveBreakpointsResponse]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/controller.proto#L154}
  ///
  StatusOr<google::devtools::clouddebugger::v2::ListActiveBreakpointsResponse>
  ListActiveBreakpoints(
      google::devtools::clouddebugger::v2::ListActiveBreakpointsRequest const&
          request,
      Options options = {});

  ///
  /// Updates the breakpoint state or mutable fields.
  /// The entire Breakpoint message must be sent back to the controller service.
  ///
  /// Updates to active breakpoint fields are only allowed if the new value
  /// does not change the breakpoint specification. Updates to the `location`,
  /// `condition` and `expressions` fields should not alter the breakpoint
  /// semantics. These may only make changes such as canonicalizing a value
  /// or snapping the location to the correct line of code.
  ///
  /// @param debuggee_id  Required. Identifies the debuggee being debugged.
  /// @param breakpoint  Required. Updated breakpoint information.
  ///  The field `id` must be set.
  ///  The agent must echo all Breakpoint specification fields in the update.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::clouddebugger::v2::UpdateActiveBreakpointResponse,google/devtools/clouddebugger/v2/controller.proto#L182}
  ///
  /// [google.devtools.clouddebugger.v2.UpdateActiveBreakpointRequest]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/controller.proto#L170}
  /// [google.devtools.clouddebugger.v2.UpdateActiveBreakpointResponse]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/controller.proto#L182}
  ///
  StatusOr<google::devtools::clouddebugger::v2::UpdateActiveBreakpointResponse>
  UpdateActiveBreakpoint(
      std::string const& debuggee_id,
      google::devtools::clouddebugger::v2::Breakpoint const& breakpoint,
      Options options = {});

  ///
  /// Updates the breakpoint state or mutable fields.
  /// The entire Breakpoint message must be sent back to the controller service.
  ///
  /// Updates to active breakpoint fields are only allowed if the new value
  /// does not change the breakpoint specification. Updates to the `location`,
  /// `condition` and `expressions` fields should not alter the breakpoint
  /// semantics. These may only make changes such as canonicalizing a value
  /// or snapping the location to the correct line of code.
  ///
  /// @param request
  /// @googleapis_link{google::devtools::clouddebugger::v2::UpdateActiveBreakpointRequest,google/devtools/clouddebugger/v2/controller.proto#L170}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::clouddebugger::v2::UpdateActiveBreakpointResponse,google/devtools/clouddebugger/v2/controller.proto#L182}
  ///
  /// [google.devtools.clouddebugger.v2.UpdateActiveBreakpointRequest]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/controller.proto#L170}
  /// [google.devtools.clouddebugger.v2.UpdateActiveBreakpointResponse]:
  /// @googleapis_reference_link{google/devtools/clouddebugger/v2/controller.proto#L182}
  ///
  StatusOr<google::devtools::clouddebugger::v2::UpdateActiveBreakpointResponse>
  UpdateActiveBreakpoint(
      google::devtools::clouddebugger::v2::UpdateActiveBreakpointRequest const&
          request,
      Options options = {});

 private:
  std::shared_ptr<Controller2Connection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace debugger
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DEBUGGER_CONTROLLER2_CLIENT_H
