// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/clouddebugger/v2/controller.proto

#include "google/cloud/debugger/controller2_client.h"
#include "google/cloud/debugger/internal/controller2_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace debugger {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

Controller2Client::Controller2Client(
    std::shared_ptr<Controller2Connection> connection, Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options), debugger_internal::Controller2DefaultOptions(
                                  connection_->options()))) {}
Controller2Client::~Controller2Client() = default;

StatusOr<google::devtools::clouddebugger::v2::RegisterDebuggeeResponse>
Controller2Client::RegisterDebuggee(
    google::devtools::clouddebugger::v2::Debuggee const& debuggee,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::devtools::clouddebugger::v2::RegisterDebuggeeRequest request;
  *request.mutable_debuggee() = debuggee;
  return connection_->RegisterDebuggee(request);
}

StatusOr<google::devtools::clouddebugger::v2::RegisterDebuggeeResponse>
Controller2Client::RegisterDebuggee(
    google::devtools::clouddebugger::v2::RegisterDebuggeeRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->RegisterDebuggee(request);
}

StatusOr<google::devtools::clouddebugger::v2::ListActiveBreakpointsResponse>
Controller2Client::ListActiveBreakpoints(std::string const& debuggee_id,
                                         Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::devtools::clouddebugger::v2::ListActiveBreakpointsRequest request;
  request.set_debuggee_id(debuggee_id);
  return connection_->ListActiveBreakpoints(request);
}

StatusOr<google::devtools::clouddebugger::v2::ListActiveBreakpointsResponse>
Controller2Client::ListActiveBreakpoints(
    google::devtools::clouddebugger::v2::ListActiveBreakpointsRequest const&
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListActiveBreakpoints(request);
}

StatusOr<google::devtools::clouddebugger::v2::UpdateActiveBreakpointResponse>
Controller2Client::UpdateActiveBreakpoint(
    std::string const& debuggee_id,
    google::devtools::clouddebugger::v2::Breakpoint const& breakpoint,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::devtools::clouddebugger::v2::UpdateActiveBreakpointRequest request;
  request.set_debuggee_id(debuggee_id);
  *request.mutable_breakpoint() = breakpoint;
  return connection_->UpdateActiveBreakpoint(request);
}

StatusOr<google::devtools::clouddebugger::v2::UpdateActiveBreakpointResponse>
Controller2Client::UpdateActiveBreakpoint(
    google::devtools::clouddebugger::v2::UpdateActiveBreakpointRequest const&
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateActiveBreakpoint(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace debugger
}  // namespace cloud
}  // namespace google
