// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/clouddms/v1/clouddms.proto

#include "google/cloud/datamigration/data_migration_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace datamigration {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

DataMigrationServiceConnectionIdempotencyPolicy::
    ~DataMigrationServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultDataMigrationServiceConnectionIdempotencyPolicy
    : public DataMigrationServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultDataMigrationServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<DataMigrationServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<
        DefaultDataMigrationServiceConnectionIdempotencyPolicy>(*this);
  }

  Idempotency ListMigrationJobs(
      google::cloud::clouddms::v1::ListMigrationJobsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetMigrationJob(
      google::cloud::clouddms::v1::GetMigrationJobRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateMigrationJob(
      google::cloud::clouddms::v1::CreateMigrationJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateMigrationJob(
      google::cloud::clouddms::v1::UpdateMigrationJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteMigrationJob(
      google::cloud::clouddms::v1::DeleteMigrationJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency StartMigrationJob(
      google::cloud::clouddms::v1::StartMigrationJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency StopMigrationJob(
      google::cloud::clouddms::v1::StopMigrationJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ResumeMigrationJob(
      google::cloud::clouddms::v1::ResumeMigrationJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency PromoteMigrationJob(
      google::cloud::clouddms::v1::PromoteMigrationJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency VerifyMigrationJob(
      google::cloud::clouddms::v1::VerifyMigrationJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency RestartMigrationJob(
      google::cloud::clouddms::v1::RestartMigrationJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GenerateSshScript(
      google::cloud::clouddms::v1::GenerateSshScriptRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListConnectionProfiles(
      google::cloud::clouddms::v1::ListConnectionProfilesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetConnectionProfile(
      google::cloud::clouddms::v1::GetConnectionProfileRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateConnectionProfile(
      google::cloud::clouddms::v1::CreateConnectionProfileRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateConnectionProfile(
      google::cloud::clouddms::v1::UpdateConnectionProfileRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteConnectionProfile(
      google::cloud::clouddms::v1::DeleteConnectionProfileRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<DataMigrationServiceConnectionIdempotencyPolicy>
MakeDefaultDataMigrationServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<
      DefaultDataMigrationServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datamigration
}  // namespace cloud
}  // namespace google
