// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: grafeas/v1/grafeas.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONTAINERANALYSIS_GRAFEAS_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONTAINERANALYSIS_GRAFEAS_CONNECTION_H

#include "google/cloud/containeranalysis/grafeas_connection_idempotency_policy.h"
#include "google/cloud/containeranalysis/internal/grafeas_retry_traits.h"
#include "google/cloud/containeranalysis/internal/grafeas_stub.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace containeranalysis {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using GrafeasRetryPolicy = ::google::cloud::internal::TraitBasedRetryPolicy<
    containeranalysis_internal::GrafeasRetryTraits>;

using GrafeasLimitedTimeRetryPolicy =
    ::google::cloud::internal::LimitedTimeRetryPolicy<
        containeranalysis_internal::GrafeasRetryTraits>;

using GrafeasLimitedErrorCountRetryPolicy =
    ::google::cloud::internal::LimitedErrorCountRetryPolicy<
        containeranalysis_internal::GrafeasRetryTraits>;

class GrafeasConnection {
 public:
  virtual ~GrafeasConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<grafeas::v1::Occurrence> GetOccurrence(
      grafeas::v1::GetOccurrenceRequest const& request);

  virtual StreamRange<grafeas::v1::Occurrence> ListOccurrences(
      grafeas::v1::ListOccurrencesRequest request);

  virtual Status DeleteOccurrence(
      grafeas::v1::DeleteOccurrenceRequest const& request);

  virtual StatusOr<grafeas::v1::Occurrence> CreateOccurrence(
      grafeas::v1::CreateOccurrenceRequest const& request);

  virtual StatusOr<grafeas::v1::BatchCreateOccurrencesResponse>
  BatchCreateOccurrences(
      grafeas::v1::BatchCreateOccurrencesRequest const& request);

  virtual StatusOr<grafeas::v1::Occurrence> UpdateOccurrence(
      grafeas::v1::UpdateOccurrenceRequest const& request);

  virtual StatusOr<grafeas::v1::Note> GetOccurrenceNote(
      grafeas::v1::GetOccurrenceNoteRequest const& request);

  virtual StatusOr<grafeas::v1::Note> GetNote(
      grafeas::v1::GetNoteRequest const& request);

  virtual StreamRange<grafeas::v1::Note> ListNotes(
      grafeas::v1::ListNotesRequest request);

  virtual Status DeleteNote(grafeas::v1::DeleteNoteRequest const& request);

  virtual StatusOr<grafeas::v1::Note> CreateNote(
      grafeas::v1::CreateNoteRequest const& request);

  virtual StatusOr<grafeas::v1::BatchCreateNotesResponse> BatchCreateNotes(
      grafeas::v1::BatchCreateNotesRequest const& request);

  virtual StatusOr<grafeas::v1::Note> UpdateNote(
      grafeas::v1::UpdateNoteRequest const& request);

  virtual StreamRange<grafeas::v1::Occurrence> ListNoteOccurrences(
      grafeas::v1::ListNoteOccurrencesRequest request);
};

std::shared_ptr<GrafeasConnection> MakeGrafeasConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace containeranalysis
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace containeranalysis_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<containeranalysis::GrafeasConnection> MakeGrafeasConnection(
    std::shared_ptr<GrafeasStub> stub, Options options);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace containeranalysis_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONTAINERANALYSIS_GRAFEAS_CONNECTION_H
