// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/container/v1/cluster_service.proto

#include "google/cloud/container/internal/cluster_manager_connection_impl.h"
#include "google/cloud/container/internal/cluster_manager_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace container_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ClusterManagerConnectionImpl::ClusterManagerConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<container_internal::ClusterManagerStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), container_internal::ClusterManagerDefaultOptions(
                                  ClusterManagerConnection::options()))) {}

StatusOr<google::container::v1::ListClustersResponse>
ClusterManagerConnectionImpl::ListClusters(
    google::container::v1::ListClustersRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->ListClusters(request),
      [this](grpc::ClientContext& context,
             google::container::v1::ListClustersRequest const& request) {
        return stub_->ListClusters(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Cluster>
ClusterManagerConnectionImpl::GetCluster(
    google::container::v1::GetClusterRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetCluster(request),
      [this](grpc::ClientContext& context,
             google::container::v1::GetClusterRequest const& request) {
        return stub_->GetCluster(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::CreateCluster(
    google::container::v1::CreateClusterRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateCluster(request),
      [this](grpc::ClientContext& context,
             google::container::v1::CreateClusterRequest const& request) {
        return stub_->CreateCluster(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::UpdateCluster(
    google::container::v1::UpdateClusterRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateCluster(request),
      [this](grpc::ClientContext& context,
             google::container::v1::UpdateClusterRequest const& request) {
        return stub_->UpdateCluster(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::UpdateNodePool(
    google::container::v1::UpdateNodePoolRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateNodePool(request),
      [this](grpc::ClientContext& context,
             google::container::v1::UpdateNodePoolRequest const& request) {
        return stub_->UpdateNodePool(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::SetNodePoolAutoscaling(
    google::container::v1::SetNodePoolAutoscalingRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetNodePoolAutoscaling(request),
      [this](
          grpc::ClientContext& context,
          google::container::v1::SetNodePoolAutoscalingRequest const& request) {
        return stub_->SetNodePoolAutoscaling(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::SetLoggingService(
    google::container::v1::SetLoggingServiceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetLoggingService(request),
      [this](grpc::ClientContext& context,
             google::container::v1::SetLoggingServiceRequest const& request) {
        return stub_->SetLoggingService(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::SetMonitoringService(
    google::container::v1::SetMonitoringServiceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetMonitoringService(request),
      [this](
          grpc::ClientContext& context,
          google::container::v1::SetMonitoringServiceRequest const& request) {
        return stub_->SetMonitoringService(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::SetAddonsConfig(
    google::container::v1::SetAddonsConfigRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetAddonsConfig(request),
      [this](grpc::ClientContext& context,
             google::container::v1::SetAddonsConfigRequest const& request) {
        return stub_->SetAddonsConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::SetLocations(
    google::container::v1::SetLocationsRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetLocations(request),
      [this](grpc::ClientContext& context,
             google::container::v1::SetLocationsRequest const& request) {
        return stub_->SetLocations(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::UpdateMaster(
    google::container::v1::UpdateMasterRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateMaster(request),
      [this](grpc::ClientContext& context,
             google::container::v1::UpdateMasterRequest const& request) {
        return stub_->UpdateMaster(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::SetMasterAuth(
    google::container::v1::SetMasterAuthRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetMasterAuth(request),
      [this](grpc::ClientContext& context,
             google::container::v1::SetMasterAuthRequest const& request) {
        return stub_->SetMasterAuth(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::DeleteCluster(
    google::container::v1::DeleteClusterRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteCluster(request),
      [this](grpc::ClientContext& context,
             google::container::v1::DeleteClusterRequest const& request) {
        return stub_->DeleteCluster(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::ListOperationsResponse>
ClusterManagerConnectionImpl::ListOperations(
    google::container::v1::ListOperationsRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->ListOperations(request),
      [this](grpc::ClientContext& context,
             google::container::v1::ListOperationsRequest const& request) {
        return stub_->ListOperations(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::GetOperation(
    google::container::v1::GetOperationRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetOperation(request),
      [this](grpc::ClientContext& context,
             google::container::v1::GetOperationRequest const& request) {
        return stub_->GetOperation(context, request);
      },
      request, __func__);
}

Status ClusterManagerConnectionImpl::CancelOperation(
    google::container::v1::CancelOperationRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CancelOperation(request),
      [this](grpc::ClientContext& context,
             google::container::v1::CancelOperationRequest const& request) {
        return stub_->CancelOperation(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::ServerConfig>
ClusterManagerConnectionImpl::GetServerConfig(
    google::container::v1::GetServerConfigRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetServerConfig(request),
      [this](grpc::ClientContext& context,
             google::container::v1::GetServerConfigRequest const& request) {
        return stub_->GetServerConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::GetJSONWebKeysResponse>
ClusterManagerConnectionImpl::GetJSONWebKeys(
    google::container::v1::GetJSONWebKeysRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetJSONWebKeys(request),
      [this](grpc::ClientContext& context,
             google::container::v1::GetJSONWebKeysRequest const& request) {
        return stub_->GetJSONWebKeys(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::ListNodePoolsResponse>
ClusterManagerConnectionImpl::ListNodePools(
    google::container::v1::ListNodePoolsRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->ListNodePools(request),
      [this](grpc::ClientContext& context,
             google::container::v1::ListNodePoolsRequest const& request) {
        return stub_->ListNodePools(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::NodePool>
ClusterManagerConnectionImpl::GetNodePool(
    google::container::v1::GetNodePoolRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetNodePool(request),
      [this](grpc::ClientContext& context,
             google::container::v1::GetNodePoolRequest const& request) {
        return stub_->GetNodePool(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::CreateNodePool(
    google::container::v1::CreateNodePoolRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateNodePool(request),
      [this](grpc::ClientContext& context,
             google::container::v1::CreateNodePoolRequest const& request) {
        return stub_->CreateNodePool(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::DeleteNodePool(
    google::container::v1::DeleteNodePoolRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteNodePool(request),
      [this](grpc::ClientContext& context,
             google::container::v1::DeleteNodePoolRequest const& request) {
        return stub_->DeleteNodePool(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::RollbackNodePoolUpgrade(
    google::container::v1::RollbackNodePoolUpgradeRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->RollbackNodePoolUpgrade(request),
      [this](grpc::ClientContext& context,
             google::container::v1::RollbackNodePoolUpgradeRequest const&
                 request) {
        return stub_->RollbackNodePoolUpgrade(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::SetNodePoolManagement(
    google::container::v1::SetNodePoolManagementRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetNodePoolManagement(request),
      [this](
          grpc::ClientContext& context,
          google::container::v1::SetNodePoolManagementRequest const& request) {
        return stub_->SetNodePoolManagement(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::SetLabels(
    google::container::v1::SetLabelsRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetLabels(request),
      [this](grpc::ClientContext& context,
             google::container::v1::SetLabelsRequest const& request) {
        return stub_->SetLabels(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::SetLegacyAbac(
    google::container::v1::SetLegacyAbacRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetLegacyAbac(request),
      [this](grpc::ClientContext& context,
             google::container::v1::SetLegacyAbacRequest const& request) {
        return stub_->SetLegacyAbac(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::StartIPRotation(
    google::container::v1::StartIPRotationRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->StartIPRotation(request),
      [this](grpc::ClientContext& context,
             google::container::v1::StartIPRotationRequest const& request) {
        return stub_->StartIPRotation(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::CompleteIPRotation(
    google::container::v1::CompleteIPRotationRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CompleteIPRotation(request),
      [this](grpc::ClientContext& context,
             google::container::v1::CompleteIPRotationRequest const& request) {
        return stub_->CompleteIPRotation(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::SetNodePoolSize(
    google::container::v1::SetNodePoolSizeRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetNodePoolSize(request),
      [this](grpc::ClientContext& context,
             google::container::v1::SetNodePoolSizeRequest const& request) {
        return stub_->SetNodePoolSize(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::SetNetworkPolicy(
    google::container::v1::SetNetworkPolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetNetworkPolicy(request),
      [this](grpc::ClientContext& context,
             google::container::v1::SetNetworkPolicyRequest const& request) {
        return stub_->SetNetworkPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::container::v1::Operation>
ClusterManagerConnectionImpl::SetMaintenancePolicy(
    google::container::v1::SetMaintenancePolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetMaintenancePolicy(request),
      [this](
          grpc::ClientContext& context,
          google::container::v1::SetMaintenancePolicyRequest const& request) {
        return stub_->SetMaintenancePolicy(context, request);
      },
      request, __func__);
}

StreamRange<google::container::v1::UsableSubnetwork>
ClusterManagerConnectionImpl::ListUsableSubnetworks(
    google::container::v1::ListUsableSubnetworksRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<container::ClusterManagerRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListUsableSubnetworks(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::container::v1::UsableSubnetwork>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::container::v1::ListUsableSubnetworksRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::container::v1::ListUsableSubnetworksRequest const&
                       request) {
              return stub->ListUsableSubnetworks(context, request);
            },
            r, function_name);
      },
      [](google::container::v1::ListUsableSubnetworksResponse r) {
        std::vector<google::container::v1::UsableSubnetwork> result(
            r.subnetworks().size());
        auto& messages = *r.mutable_subnetworks();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace container_internal
}  // namespace cloud
}  // namespace google
