// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/container/v1/cluster_service.proto

#include "google/cloud/container/cluster_manager_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace container {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ClusterManagerConnectionIdempotencyPolicy::
    ~ClusterManagerConnectionIdempotencyPolicy() = default;

namespace {
class DefaultClusterManagerConnectionIdempotencyPolicy
    : public ClusterManagerConnectionIdempotencyPolicy {
 public:
  ~DefaultClusterManagerConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<ClusterManagerConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultClusterManagerConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ListClusters(
      google::container::v1::ListClustersRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetCluster(
      google::container::v1::GetClusterRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateCluster(
      google::container::v1::CreateClusterRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateCluster(
      google::container::v1::UpdateClusterRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateNodePool(
      google::container::v1::UpdateNodePoolRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency SetNodePoolAutoscaling(
      google::container::v1::SetNodePoolAutoscalingRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetLoggingService(
      google::container::v1::SetLoggingServiceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetMonitoringService(
      google::container::v1::SetMonitoringServiceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetAddonsConfig(
      google::container::v1::SetAddonsConfigRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetLocations(
      google::container::v1::SetLocationsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateMaster(
      google::container::v1::UpdateMasterRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetMasterAuth(
      google::container::v1::SetMasterAuthRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteCluster(
      google::container::v1::DeleteClusterRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListOperations(
      google::container::v1::ListOperationsRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetOperation(
      google::container::v1::GetOperationRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CancelOperation(
      google::container::v1::CancelOperationRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetServerConfig(
      google::container::v1::GetServerConfigRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetJSONWebKeys(
      google::container::v1::GetJSONWebKeysRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListNodePools(
      google::container::v1::ListNodePoolsRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetNodePool(
      google::container::v1::GetNodePoolRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateNodePool(
      google::container::v1::CreateNodePoolRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteNodePool(
      google::container::v1::DeleteNodePoolRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency RollbackNodePoolUpgrade(
      google::container::v1::RollbackNodePoolUpgradeRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetNodePoolManagement(
      google::container::v1::SetNodePoolManagementRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetLabels(
      google::container::v1::SetLabelsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetLegacyAbac(
      google::container::v1::SetLegacyAbacRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency StartIPRotation(
      google::container::v1::StartIPRotationRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CompleteIPRotation(
      google::container::v1::CompleteIPRotationRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetNodePoolSize(
      google::container::v1::SetNodePoolSizeRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetNetworkPolicy(
      google::container::v1::SetNetworkPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetMaintenancePolicy(
      google::container::v1::SetMaintenancePolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListUsableSubnetworks(
      google::container::v1::ListUsableSubnetworksRequest) override {
    return Idempotency::kIdempotent;
  }
};
}  // namespace

std::unique_ptr<ClusterManagerConnectionIdempotencyPolicy>
MakeDefaultClusterManagerConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultClusterManagerConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace container
}  // namespace cloud
}  // namespace google
