// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/container/v1/cluster_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONTAINER_CLUSTER_MANAGER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONTAINER_CLUSTER_MANAGER_CLIENT_H

#include "google/cloud/container/cluster_manager_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace container {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Google Kubernetes Engine Cluster Manager v1
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ClusterManagerClient {
 public:
  explicit ClusterManagerClient(
      std::shared_ptr<ClusterManagerConnection> connection,
      Options options = {});
  ~ClusterManagerClient();

  //@{
  // @name Copy and move support
  ClusterManagerClient(ClusterManagerClient const&) = default;
  ClusterManagerClient& operator=(ClusterManagerClient const&) = default;
  ClusterManagerClient(ClusterManagerClient&&) = default;
  ClusterManagerClient& operator=(ClusterManagerClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(ClusterManagerClient const& a,
                         ClusterManagerClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ClusterManagerClient const& a,
                         ClusterManagerClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Lists all clusters owned by a project in either the specified zone or all
  /// zones.
  ///
  /// @param parent  The parent (project and location) where the clusters will
  /// be listed.
  ///  Specified in the format `projects/*/locations/*`.
  ///  Location "-" matches all zones and all regions.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::ListClustersResponse,google/container/v1/cluster_service.proto#L2350}
  ///
  /// [google.container.v1.ListClustersRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2331}
  /// [google.container.v1.ListClustersResponse]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2350}
  ///
  StatusOr<google::container::v1::ListClustersResponse> ListClusters(
      std::string const& parent, Options options = {});

  ///
  /// Lists all clusters owned by a project in either the specified zone or all
  /// zones.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::ListClustersRequest,google/container/v1/cluster_service.proto#L2331}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::ListClustersResponse,google/container/v1/cluster_service.proto#L2350}
  ///
  /// [google.container.v1.ListClustersRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2331}
  /// [google.container.v1.ListClustersResponse]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2350}
  ///
  StatusOr<google::container::v1::ListClustersResponse> ListClusters(
      google::container::v1::ListClustersRequest const& request,
      Options options = {});

  ///
  /// Gets the details of a specific cluster.
  ///
  /// @param name  The name (project, location, cluster) of the cluster to
  /// retrieve.
  ///  Specified in the format `projects/*/locations/*/clusters/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Cluster,google/container/v1/cluster_service.proto#L1261}
  ///
  /// [google.container.v1.GetClusterRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1957}
  /// [google.container.v1.Cluster]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1261}
  ///
  StatusOr<google::container::v1::Cluster> GetCluster(std::string const& name,
                                                      Options options = {});

  ///
  /// Gets the details of a specific cluster.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::GetClusterRequest,google/container/v1/cluster_service.proto#L1957}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Cluster,google/container/v1/cluster_service.proto#L1261}
  ///
  /// [google.container.v1.GetClusterRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1957}
  /// [google.container.v1.Cluster]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1261}
  ///
  StatusOr<google::container::v1::Cluster> GetCluster(
      google::container::v1::GetClusterRequest const& request,
      Options options = {});

  ///
  /// Creates a cluster, consisting of the specified number and type of Google
  /// Compute Engine instances.
  ///
  /// By default, the cluster is created in the project's
  /// [default
  /// network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks).
  ///
  /// One firewall is added for the cluster. After cluster creation,
  /// the Kubelet creates routes for each node to allow the containers
  /// on that node to communicate with all other instances in the
  /// cluster.
  ///
  /// Finally, an entry is added to the project's global metadata indicating
  /// which CIDR range the cluster is using.
  ///
  /// @param parent  The parent (project and location) where the cluster will be
  /// created.
  ///  Specified in the format `projects/*/locations/*`.
  /// @param cluster  Required. A [cluster
  ///  resource](https://cloud.google.com/container-engine/reference/rest/v1/projects.locations.clusters)
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.CreateClusterRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1935}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> CreateCluster(
      std::string const& parent, google::container::v1::Cluster const& cluster,
      Options options = {});

  ///
  /// Creates a cluster, consisting of the specified number and type of Google
  /// Compute Engine instances.
  ///
  /// By default, the cluster is created in the project's
  /// [default
  /// network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks).
  ///
  /// One firewall is added for the cluster. After cluster creation,
  /// the Kubelet creates routes for each node to allow the containers
  /// on that node to communicate with all other instances in the
  /// cluster.
  ///
  /// Finally, an entry is added to the project's global metadata indicating
  /// which CIDR range the cluster is using.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::CreateClusterRequest,google/container/v1/cluster_service.proto#L1935}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.CreateClusterRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1935}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> CreateCluster(
      google::container::v1::CreateClusterRequest const& request,
      Options options = {});

  ///
  /// Updates the settings of a specific cluster.
  ///
  /// @param name  The name (project, location, cluster) of the cluster to
  /// update.
  ///  Specified in the format `projects/*/locations/*/clusters/*`.
  /// @param update  Required. A description of the update.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.UpdateClusterRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1979}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> UpdateCluster(
      std::string const& name,
      google::container::v1::ClusterUpdate const& update, Options options = {});

  ///
  /// Updates the settings of a specific cluster.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::UpdateClusterRequest,google/container/v1/cluster_service.proto#L1979}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.UpdateClusterRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1979}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> UpdateCluster(
      google::container::v1::UpdateClusterRequest const& request,
      Options options = {});

  ///
  /// Updates the version and/or image type for the specified node pool.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::UpdateNodePoolRequest,google/container/v1/cluster_service.proto#L2004}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.UpdateNodePoolRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2004}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> UpdateNodePool(
      google::container::v1::UpdateNodePoolRequest const& request,
      Options options = {});

  ///
  /// Sets the autoscaling settings for the specified node pool.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::SetNodePoolAutoscalingRequest,google/container/v1/cluster_service.proto#L2072}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetNodePoolAutoscalingRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2072}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetNodePoolAutoscaling(
      google::container::v1::SetNodePoolAutoscalingRequest const& request,
      Options options = {});

  ///
  /// Sets the logging service for a specific cluster.
  ///
  /// @param name  The name (project, location, cluster) of the cluster to set
  /// logging.
  ///  Specified in the format `projects/*/locations/*/clusters/*`.
  /// @param logging_service  Required. The logging service the cluster should
  /// use to write logs.
  ///  Currently available options:
  ///  * `logging.googleapis.com/kubernetes` - The Cloud Logging
  ///  service with a Kubernetes-native resource model
  ///  * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
  ///    available as of GKE 1.15).
  ///  * `none` - no logs will be exported from the cluster.
  ///  If left as an empty string,`logging.googleapis.com/kubernetes` will be
  ///  used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetLoggingServiceRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2102}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetLoggingService(
      std::string const& name, std::string const& logging_service,
      Options options = {});

  ///
  /// Sets the logging service for a specific cluster.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::SetLoggingServiceRequest,google/container/v1/cluster_service.proto#L2102}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetLoggingServiceRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2102}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetLoggingService(
      google::container::v1::SetLoggingServiceRequest const& request,
      Options options = {});

  ///
  /// Sets the monitoring service for a specific cluster.
  ///
  /// @param name  The name (project, location, cluster) of the cluster to set
  /// monitoring.
  ///  Specified in the format `projects/*/locations/*/clusters/*`.
  /// @param monitoring_service  Required. The monitoring service the cluster
  /// should use to write metrics.
  ///  Currently available options:
  ///  * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
  ///  service with a Kubernetes-native resource model
  ///  * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
  ///    longer available as of GKE 1.15).
  ///  * `none` - No metrics will be exported from the cluster.
  ///  If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
  ///  used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetMonitoringServiceRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2137}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetMonitoringService(
      std::string const& name, std::string const& monitoring_service,
      Options options = {});

  ///
  /// Sets the monitoring service for a specific cluster.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::SetMonitoringServiceRequest,google/container/v1/cluster_service.proto#L2137}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetMonitoringServiceRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2137}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetMonitoringService(
      google::container::v1::SetMonitoringServiceRequest const& request,
      Options options = {});

  ///
  /// Sets the addons for a specific cluster.
  ///
  /// @param name  The name (project, location, cluster) of the cluster to set
  /// addons.
  ///  Specified in the format `projects/*/locations/*/clusters/*`.
  /// @param addons_config  Required. The desired configurations for the various
  /// addons available to run in the
  ///  cluster.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetAddonsConfigRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2172}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetAddonsConfig(
      std::string const& name,
      google::container::v1::AddonsConfig const& addons_config,
      Options options = {});

  ///
  /// Sets the addons for a specific cluster.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::SetAddonsConfigRequest,google/container/v1/cluster_service.proto#L2172}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetAddonsConfigRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2172}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetAddonsConfig(
      google::container::v1::SetAddonsConfigRequest const& request,
      Options options = {});

  ///
  /// Sets the locations for a specific cluster.
  /// Deprecated. Use
  /// [projects.locations.clusters.update](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters/update)
  /// instead.
  ///
  /// @param name  The name (project, location, cluster) of the cluster to set
  /// locations.
  ///  Specified in the format `projects/*/locations/*/clusters/*`.
  /// @param locations  Required. The desired list of Google Compute Engine
  ///  [zones](https://cloud.google.com/compute/docs/zones#available) in which
  ///  the cluster's nodes should be located. Changing the locations a cluster
  ///  is in will result in nodes being either created or removed from the
  ///  cluster, depending on whether locations are being added or removed. This
  ///  list must always include the cluster's primary zone.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetLocationsRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2198}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetLocations(
      std::string const& name, std::vector<std::string> const& locations,
      Options options = {});

  ///
  /// Sets the locations for a specific cluster.
  /// Deprecated. Use
  /// [projects.locations.clusters.update](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters/update)
  /// instead.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::SetLocationsRequest,google/container/v1/cluster_service.proto#L2198}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetLocationsRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2198}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetLocations(
      google::container::v1::SetLocationsRequest const& request,
      Options options = {});

  ///
  /// Updates the master for a specific cluster.
  ///
  /// @param name  The name (project, location, cluster) of the cluster to
  /// update.
  ///  Specified in the format `projects/*/locations/*/clusters/*`.
  /// @param master_version  Required. The Kubernetes version to change the
  /// master to.
  ///  Users may specify either explicit versions offered by Kubernetes Engine
  ///  or version aliases, which have the following behavior:
  ///  - "latest": picks the highest valid Kubernetes version
  ///  - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
  ///  - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
  ///  - "1.X.Y-gke.N": picks an explicit Kubernetes version
  ///  - "-": picks the default Kubernetes version
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.UpdateMasterRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2229}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> UpdateMaster(
      std::string const& name, std::string const& master_version,
      Options options = {});

  ///
  /// Updates the master for a specific cluster.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::UpdateMasterRequest,google/container/v1/cluster_service.proto#L2229}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.UpdateMasterRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2229}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> UpdateMaster(
      google::container::v1::UpdateMasterRequest const& request,
      Options options = {});

  ///
  /// Sets master auth materials. Currently supports changing the admin password
  /// or a specific cluster, either via password generation or explicitly
  /// setting the password.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::SetMasterAuthRequest,google/container/v1/cluster_service.proto#L2263}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetMasterAuthRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2263}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetMasterAuth(
      google::container::v1::SetMasterAuthRequest const& request,
      Options options = {});

  ///
  /// Deletes the cluster, including the Kubernetes endpoint and all worker
  /// nodes.
  ///
  /// Firewalls and routes that were configured during cluster creation
  /// are also deleted.
  ///
  /// Other Google Compute Engine resources that might be in use by the cluster,
  /// such as load balancer resources, are not deleted if they weren't present
  /// when the cluster was initially created.
  ///
  /// @param name  The name (project, location, cluster) of the cluster to
  /// delete.
  ///  Specified in the format `projects/*/locations/*/clusters/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.DeleteClusterRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2309}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> DeleteCluster(
      std::string const& name, Options options = {});

  ///
  /// Deletes the cluster, including the Kubernetes endpoint and all worker
  /// nodes.
  ///
  /// Firewalls and routes that were configured during cluster creation
  /// are also deleted.
  ///
  /// Other Google Compute Engine resources that might be in use by the cluster,
  /// such as load balancer resources, are not deleted if they weren't present
  /// when the cluster was initially created.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::DeleteClusterRequest,google/container/v1/cluster_service.proto#L2309}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.DeleteClusterRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2309}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> DeleteCluster(
      google::container::v1::DeleteClusterRequest const& request,
      Options options = {});

  ///
  /// Lists all operations in a project in a specific zone or all zones.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::ListOperationsRequest,google/container/v1/cluster_service.proto#L2383}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::ListOperationsResponse,google/container/v1/cluster_service.proto#L2424}
  ///
  /// [google.container.v1.ListOperationsRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2383}
  /// [google.container.v1.ListOperationsResponse]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2424}
  ///
  StatusOr<google::container::v1::ListOperationsResponse> ListOperations(
      google::container::v1::ListOperationsRequest const& request,
      Options options = {});

  ///
  /// Gets the specified operation.
  ///
  /// @param name  The name (project, location, operation id) of the operation
  /// to get.
  ///  Specified in the format `projects/*/locations/*/operations/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.GetOperationRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2361}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> GetOperation(
      std::string const& name, Options options = {});

  ///
  /// Gets the specified operation.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::GetOperationRequest,google/container/v1/cluster_service.proto#L2361}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.GetOperationRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2361}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> GetOperation(
      google::container::v1::GetOperationRequest const& request,
      Options options = {});

  ///
  /// Cancels the specified operation.
  ///
  /// @param name  The name (project, location, operation id) of the operation
  /// to cancel.
  ///  Specified in the format `projects/*/locations/*/operations/*`.
  /// @param options  Optional. Operation options.
  ///
  /// [google.container.v1.CancelOperationRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2402}
  ///
  Status CancelOperation(std::string const& name, Options options = {});

  ///
  /// Cancels the specified operation.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::CancelOperationRequest,google/container/v1/cluster_service.proto#L2402}
  /// @param options  Optional. Operation options.
  ///
  /// [google.container.v1.CancelOperationRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2402}
  ///
  Status CancelOperation(
      google::container::v1::CancelOperationRequest const& request,
      Options options = {});

  ///
  /// Returns configuration info about the Google Kubernetes Engine service.
  ///
  /// @param name  The name (project and location) of the server config to get,
  ///  specified in the format `projects/*/locations/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::ServerConfig,google/container/v1/cluster_service.proto#L2452}
  ///
  /// [google.container.v1.GetServerConfigRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2434}
  /// [google.container.v1.ServerConfig]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2452}
  ///
  StatusOr<google::container::v1::ServerConfig> GetServerConfig(
      std::string const& name, Options options = {});

  ///
  /// Returns configuration info about the Google Kubernetes Engine service.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::GetServerConfigRequest,google/container/v1/cluster_service.proto#L2434}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::ServerConfig,google/container/v1/cluster_service.proto#L2452}
  ///
  /// [google.container.v1.GetServerConfigRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2434}
  /// [google.container.v1.ServerConfig]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2452}
  ///
  StatusOr<google::container::v1::ServerConfig> GetServerConfig(
      google::container::v1::GetServerConfigRequest const& request,
      Options options = {});

  ///
  /// Gets the public component of the cluster signing keys in
  /// JSON Web Key format.
  /// This API is not yet intended for general use, and is not available for all
  /// clusters.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::GetJSONWebKeysRequest,google/container/v1/cluster_service.proto#L3424}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::GetJSONWebKeysResponse,google/container/v1/cluster_service.proto#L3461}
  ///
  /// [google.container.v1.GetJSONWebKeysRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L3424}
  /// [google.container.v1.GetJSONWebKeysResponse]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L3461}
  ///
  StatusOr<google::container::v1::GetJSONWebKeysResponse> GetJSONWebKeys(
      google::container::v1::GetJSONWebKeysRequest const& request,
      Options options = {});

  ///
  /// Lists the node pools for a cluster.
  ///
  /// @param parent  The parent (project, location, cluster id) where the node
  /// pools will be
  ///  listed. Specified in the format `projects/*/locations/*/clusters/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::ListNodePoolsResponse,google/container/v1/cluster_service.proto#L2972}
  ///
  /// [google.container.v1.ListNodePoolsRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2538}
  /// [google.container.v1.ListNodePoolsResponse]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2972}
  ///
  StatusOr<google::container::v1::ListNodePoolsResponse> ListNodePools(
      std::string const& parent, Options options = {});

  ///
  /// Lists the node pools for a cluster.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::ListNodePoolsRequest,google/container/v1/cluster_service.proto#L2538}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::ListNodePoolsResponse,google/container/v1/cluster_service.proto#L2972}
  ///
  /// [google.container.v1.ListNodePoolsRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2538}
  /// [google.container.v1.ListNodePoolsResponse]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2972}
  ///
  StatusOr<google::container::v1::ListNodePoolsResponse> ListNodePools(
      google::container::v1::ListNodePoolsRequest const& request,
      Options options = {});

  ///
  /// Retrieves the requested node pool.
  ///
  /// @param name  The name (project, location, cluster, node pool id) of the
  /// node pool to
  ///  get. Specified in the format
  ///  `projects/*/locations/*/clusters/*/nodePools/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::NodePool,google/container/v1/cluster_service.proto#L2592}
  ///
  /// [google.container.v1.GetNodePoolRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2560}
  /// [google.container.v1.NodePool]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2592}
  ///
  StatusOr<google::container::v1::NodePool> GetNodePool(std::string const& name,
                                                        Options options = {});

  ///
  /// Retrieves the requested node pool.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::GetNodePoolRequest,google/container/v1/cluster_service.proto#L2560}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::NodePool,google/container/v1/cluster_service.proto#L2592}
  ///
  /// [google.container.v1.GetNodePoolRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2560}
  /// [google.container.v1.NodePool]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2592}
  ///
  StatusOr<google::container::v1::NodePool> GetNodePool(
      google::container::v1::GetNodePoolRequest const& request,
      Options options = {});

  ///
  /// Creates a node pool for a cluster.
  ///
  /// @param parent  The parent (project, location, cluster id) where the node
  /// pool will be
  ///  created. Specified in the format
  ///  `projects/*/locations/*/clusters/*`.
  /// @param node_pool  Required. The node pool to create.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.CreateNodePoolRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2485}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> CreateNodePool(
      std::string const& parent,
      google::container::v1::NodePool const& node_pool, Options options = {});

  ///
  /// Creates a node pool for a cluster.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::CreateNodePoolRequest,google/container/v1/cluster_service.proto#L2485}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.CreateNodePoolRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2485}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> CreateNodePool(
      google::container::v1::CreateNodePoolRequest const& request,
      Options options = {});

  ///
  /// Deletes a node pool from a cluster.
  ///
  /// @param name  The name (project, location, cluster, node pool id) of the
  /// node pool to
  ///  delete. Specified in the format
  ///  `projects/*/locations/*/clusters/*/nodePools/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.DeleteNodePoolRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2511}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> DeleteNodePool(
      std::string const& name, Options options = {});

  ///
  /// Deletes a node pool from a cluster.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::DeleteNodePoolRequest,google/container/v1/cluster_service.proto#L2511}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.DeleteNodePoolRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2511}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> DeleteNodePool(
      google::container::v1::DeleteNodePoolRequest const& request,
      Options options = {});

  ///
  /// Rolls back a previously Aborted or Failed NodePool upgrade.
  /// This makes no changes if the last upgrade successfully completed.
  ///
  /// @param name  The name (project, location, cluster, node pool id) of the
  /// node poll to
  ///  rollback upgrade.
  ///  Specified in the format `projects/*/locations/*/clusters/*/nodePools/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.RollbackNodePoolUpgradeRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2945}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> RollbackNodePoolUpgrade(
      std::string const& name, Options options = {});

  ///
  /// Rolls back a previously Aborted or Failed NodePool upgrade.
  /// This makes no changes if the last upgrade successfully completed.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::RollbackNodePoolUpgradeRequest,google/container/v1/cluster_service.proto#L2945}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.RollbackNodePoolUpgradeRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2945}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> RollbackNodePoolUpgrade(
      google::container::v1::RollbackNodePoolUpgradeRequest const& request,
      Options options = {});

  ///
  /// Sets the NodeManagement options for a node pool.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::SetNodePoolManagementRequest,google/container/v1/cluster_service.proto#L2883}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetNodePoolManagementRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2883}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetNodePoolManagement(
      google::container::v1::SetNodePoolManagementRequest const& request,
      Options options = {});

  ///
  /// Sets labels on a cluster.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::SetLabelsRequest,google/container/v1/cluster_service.proto#L3101}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetLabelsRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L3101}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetLabels(
      google::container::v1::SetLabelsRequest const& request,
      Options options = {});

  ///
  /// Enables or disables the ABAC authorization mechanism on a cluster.
  ///
  /// @param name  The name (project, location, cluster id) of the cluster to
  /// set legacy abac.
  ///  Specified in the format `projects/*/locations/*/clusters/*`.
  /// @param enabled  Required. Whether ABAC authorization will be enabled in
  /// the cluster.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetLegacyAbacRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L3135}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetLegacyAbac(
      std::string const& name, bool enabled, Options options = {});

  ///
  /// Enables or disables the ABAC authorization mechanism on a cluster.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::SetLegacyAbacRequest,google/container/v1/cluster_service.proto#L3135}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetLegacyAbacRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L3135}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetLegacyAbac(
      google::container::v1::SetLegacyAbacRequest const& request,
      Options options = {});

  ///
  /// Starts master IP rotation.
  ///
  /// @param name  The name (project, location, cluster id) of the cluster to
  /// start IP
  ///  rotation. Specified in the format `projects/*/locations/*/clusters/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.StartIPRotationRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L3161}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> StartIPRotation(
      std::string const& name, Options options = {});

  ///
  /// Starts master IP rotation.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::StartIPRotationRequest,google/container/v1/cluster_service.proto#L3161}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.StartIPRotationRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L3161}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> StartIPRotation(
      google::container::v1::StartIPRotationRequest const& request,
      Options options = {});

  ///
  /// Completes master IP rotation.
  ///
  /// @param name  The name (project, location, cluster id) of the cluster to
  /// complete IP
  ///  rotation. Specified in the format `projects/*/locations/*/clusters/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.CompleteIPRotationRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L3186}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> CompleteIPRotation(
      std::string const& name, Options options = {});

  ///
  /// Completes master IP rotation.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::CompleteIPRotationRequest,google/container/v1/cluster_service.proto#L3186}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.CompleteIPRotationRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L3186}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> CompleteIPRotation(
      google::container::v1::CompleteIPRotationRequest const& request,
      Options options = {});

  ///
  /// Sets the size for a specific node pool. The new size will be used for all
  /// replicas, including future replicas created by modifying
  /// [NodePool.locations][google.container.v1.NodePool.locations].
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::SetNodePoolSizeRequest,google/container/v1/cluster_service.proto#L2913}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetNodePoolSizeRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L2913}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetNodePoolSize(
      google::container::v1::SetNodePoolSizeRequest const& request,
      Options options = {});

  ///
  /// Enables or disables Network Policy for a cluster.
  ///
  /// @param name  The name (project, location, cluster id) of the cluster to
  /// set networking
  ///  policy. Specified in the format `projects/*/locations/*/clusters/*`.
  /// @param network_policy  Required. Configuration options for the
  /// NetworkPolicy feature.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetNetworkPolicyRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L3248}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetNetworkPolicy(
      std::string const& name,
      google::container::v1::NetworkPolicy const& network_policy,
      Options options = {});

  ///
  /// Enables or disables Network Policy for a cluster.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::SetNetworkPolicyRequest,google/container/v1/cluster_service.proto#L3248}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetNetworkPolicyRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L3248}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetNetworkPolicy(
      google::container::v1::SetNetworkPolicyRequest const& request,
      Options options = {});

  ///
  /// Sets the maintenance policy for a cluster.
  ///
  /// @param project_id  Required. The Google Developers Console [project ID or
  /// project
  ///  number](https://support.google.com/cloud/answer/6158840).
  /// @param zone  Required. The name of the Google Compute Engine
  ///  [zone](https://cloud.google.com/compute/docs/zones#available) in which
  ///  the cluster resides.
  /// @param cluster_id  Required. The name of the cluster to update.
  /// @param maintenance_policy  Required. The maintenance policy to be set for
  /// the cluster. An empty field
  ///  clears the existing maintenance policy.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetMaintenancePolicyRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L3273}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetMaintenancePolicy(
      std::string const& project_id, std::string const& zone,
      std::string const& cluster_id,
      google::container::v1::MaintenancePolicy const& maintenance_policy,
      Options options = {});

  ///
  /// Sets the maintenance policy for a cluster.
  ///
  /// @param name  The name (project, location, cluster id) of the cluster to
  /// set maintenance
  ///  policy.
  ///  Specified in the format `projects/*/locations/*/clusters/*`.
  /// @param maintenance_policy  Required. The maintenance policy to be set for
  /// the cluster. An empty field
  ///  clears the existing maintenance policy.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetMaintenancePolicyRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L3273}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetMaintenancePolicy(
      std::string const& name,
      google::container::v1::MaintenancePolicy const& maintenance_policy,
      Options options = {});

  ///
  /// Sets the maintenance policy for a cluster.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::SetMaintenancePolicyRequest,google/container/v1/cluster_service.proto#L3273}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::Operation,google/container/v1/cluster_service.proto#L1761}
  ///
  /// [google.container.v1.SetMaintenancePolicyRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L3273}
  /// [google.container.v1.Operation]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L1761}
  ///
  StatusOr<google::container::v1::Operation> SetMaintenancePolicy(
      google::container::v1::SetMaintenancePolicyRequest const& request,
      Options options = {});

  ///
  /// Lists subnetworks that are usable for creating clusters in a project.
  ///
  /// @param request
  /// @googleapis_link{google::container::v1::ListUsableSubnetworksRequest,google/container/v1/cluster_service.proto#L3600}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::container::v1::UsableSubnetwork,google/container/v1/cluster_service.proto#L3672}
  ///
  /// [google.container.v1.ListUsableSubnetworksRequest]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L3600}
  /// [google.container.v1.UsableSubnetwork]:
  /// @googleapis_reference_link{google/container/v1/cluster_service.proto#L3672}
  ///
  StreamRange<google::container::v1::UsableSubnetwork> ListUsableSubnetworks(
      google::container::v1::ListUsableSubnetworksRequest request,
      Options options = {});

 private:
  std::shared_ptr<ClusterManagerConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace container
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONTAINER_CLUSTER_MANAGER_CLIENT_H
