// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/orchestration/airflow/service/v1/image_versions.proto

#include "google/cloud/composer/image_versions_connection.h"
#include "google/cloud/composer/image_versions_options.h"
#include "google/cloud/composer/internal/image_versions_connection_impl.h"
#include "google/cloud/composer/internal/image_versions_option_defaults.h"
#include "google/cloud/composer/internal/image_versions_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace composer {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ImageVersionsConnection::~ImageVersionsConnection() = default;

StreamRange<google::cloud::orchestration::airflow::service::v1::ImageVersion>
ImageVersionsConnection::ListImageVersions(
    google::cloud::orchestration::airflow::service::v1::ListImageVersionsRequest
        request) {
  return google::cloud::internal::MakePaginationRange<StreamRange<
      google::cloud::orchestration::airflow::service::v1::ImageVersion>>(
      std::move(request),
      [](google::cloud::orchestration::airflow::service::v1::
             ListImageVersionsRequest const&) {
        return StatusOr<google::cloud::orchestration::airflow::service::v1::
                            ListImageVersionsResponse>{};
      },
      [](google::cloud::orchestration::airflow::service::v1::
             ListImageVersionsResponse const&) {
        return std::vector<
            google::cloud::orchestration::airflow::service::v1::ImageVersion>();
      });
}

std::shared_ptr<ImageVersionsConnection> MakeImageVersionsConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 ImageVersionsPolicyOptionList>(options,
                                                                __func__);
  options = composer_internal::ImageVersionsDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = composer_internal::CreateDefaultImageVersionsStub(
      background->cq(), options);
  return std::make_shared<composer_internal::ImageVersionsConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace composer
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace composer_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<composer::ImageVersionsConnection> MakeImageVersionsConnection(
    std::shared_ptr<ImageVersionsStub> stub, Options options) {
  options = ImageVersionsDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<composer_internal::ImageVersionsConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace composer_internal
}  // namespace cloud
}  // namespace google
