// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDBUILD_CLOUD_BUILD_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDBUILD_CLOUD_BUILD_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/internal/retry_policy.h"
#include "google/cloud/version.h"
#include <google/devtools/cloudbuild/v1/cloudbuild.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace cloudbuild {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class CloudBuildConnectionIdempotencyPolicy {
 public:
  virtual ~CloudBuildConnectionIdempotencyPolicy() = 0;

  /// Create a new copy of this object.
  virtual std::unique_ptr<CloudBuildConnectionIdempotencyPolicy> clone()
      const = 0;

  virtual google::cloud::Idempotency CreateBuild(
      google::devtools::cloudbuild::v1::CreateBuildRequest const& request) = 0;

  virtual google::cloud::Idempotency GetBuild(
      google::devtools::cloudbuild::v1::GetBuildRequest const& request) = 0;

  virtual google::cloud::Idempotency ListBuilds(
      google::devtools::cloudbuild::v1::ListBuildsRequest request) = 0;

  virtual google::cloud::Idempotency CancelBuild(
      google::devtools::cloudbuild::v1::CancelBuildRequest const& request) = 0;

  virtual google::cloud::Idempotency RetryBuild(
      google::devtools::cloudbuild::v1::RetryBuildRequest const& request) = 0;

  virtual google::cloud::Idempotency ApproveBuild(
      google::devtools::cloudbuild::v1::ApproveBuildRequest const& request) = 0;

  virtual google::cloud::Idempotency CreateBuildTrigger(
      google::devtools::cloudbuild::v1::CreateBuildTriggerRequest const&
          request) = 0;

  virtual google::cloud::Idempotency GetBuildTrigger(
      google::devtools::cloudbuild::v1::GetBuildTriggerRequest const&
          request) = 0;

  virtual google::cloud::Idempotency ListBuildTriggers(
      google::devtools::cloudbuild::v1::ListBuildTriggersRequest request) = 0;

  virtual google::cloud::Idempotency DeleteBuildTrigger(
      google::devtools::cloudbuild::v1::DeleteBuildTriggerRequest const&
          request) = 0;

  virtual google::cloud::Idempotency UpdateBuildTrigger(
      google::devtools::cloudbuild::v1::UpdateBuildTriggerRequest const&
          request) = 0;

  virtual google::cloud::Idempotency RunBuildTrigger(
      google::devtools::cloudbuild::v1::RunBuildTriggerRequest const&
          request) = 0;

  virtual google::cloud::Idempotency ReceiveTriggerWebhook(
      google::devtools::cloudbuild::v1::ReceiveTriggerWebhookRequest const&
          request) = 0;

  virtual google::cloud::Idempotency CreateWorkerPool(
      google::devtools::cloudbuild::v1::CreateWorkerPoolRequest const&
          request) = 0;

  virtual google::cloud::Idempotency GetWorkerPool(
      google::devtools::cloudbuild::v1::GetWorkerPoolRequest const&
          request) = 0;

  virtual google::cloud::Idempotency DeleteWorkerPool(
      google::devtools::cloudbuild::v1::DeleteWorkerPoolRequest const&
          request) = 0;

  virtual google::cloud::Idempotency UpdateWorkerPool(
      google::devtools::cloudbuild::v1::UpdateWorkerPoolRequest const&
          request) = 0;

  virtual google::cloud::Idempotency ListWorkerPools(
      google::devtools::cloudbuild::v1::ListWorkerPoolsRequest request) = 0;
};

std::unique_ptr<CloudBuildConnectionIdempotencyPolicy>
MakeDefaultCloudBuildConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudbuild
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDBUILD_CLOUD_BUILD_CONNECTION_IDEMPOTENCY_POLICY_H
