// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

#include "google/cloud/cloudbuild/cloud_build_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace cloudbuild {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

CloudBuildConnectionIdempotencyPolicy::
    ~CloudBuildConnectionIdempotencyPolicy() = default;

namespace {
class DefaultCloudBuildConnectionIdempotencyPolicy
    : public CloudBuildConnectionIdempotencyPolicy {
 public:
  ~DefaultCloudBuildConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<CloudBuildConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultCloudBuildConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency CreateBuild(
      google::devtools::cloudbuild::v1::CreateBuildRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetBuild(
      google::devtools::cloudbuild::v1::GetBuildRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListBuilds(
      google::devtools::cloudbuild::v1::ListBuildsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CancelBuild(
      google::devtools::cloudbuild::v1::CancelBuildRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency RetryBuild(
      google::devtools::cloudbuild::v1::RetryBuildRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ApproveBuild(
      google::devtools::cloudbuild::v1::ApproveBuildRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CreateBuildTrigger(
      google::devtools::cloudbuild::v1::CreateBuildTriggerRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetBuildTrigger(
      google::devtools::cloudbuild::v1::GetBuildTriggerRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListBuildTriggers(
      google::devtools::cloudbuild::v1::ListBuildTriggersRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency DeleteBuildTrigger(
      google::devtools::cloudbuild::v1::DeleteBuildTriggerRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateBuildTrigger(
      google::devtools::cloudbuild::v1::UpdateBuildTriggerRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency RunBuildTrigger(
      google::devtools::cloudbuild::v1::RunBuildTriggerRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ReceiveTriggerWebhook(
      google::devtools::cloudbuild::v1::ReceiveTriggerWebhookRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CreateWorkerPool(
      google::devtools::cloudbuild::v1::CreateWorkerPoolRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetWorkerPool(
      google::devtools::cloudbuild::v1::GetWorkerPoolRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency DeleteWorkerPool(
      google::devtools::cloudbuild::v1::DeleteWorkerPoolRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateWorkerPool(
      google::devtools::cloudbuild::v1::UpdateWorkerPoolRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListWorkerPools(
      google::devtools::cloudbuild::v1::ListWorkerPoolsRequest) override {
    return Idempotency::kIdempotent;
  }
};
}  // namespace

std::unique_ptr<CloudBuildConnectionIdempotencyPolicy>
MakeDefaultCloudBuildConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultCloudBuildConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudbuild
}  // namespace cloud
}  // namespace google
