// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

#include "google/cloud/cloudbuild/cloud_build_connection.h"
#include "google/cloud/cloudbuild/cloud_build_options.h"
#include "google/cloud/cloudbuild/internal/cloud_build_connection_impl.h"
#include "google/cloud/cloudbuild/internal/cloud_build_option_defaults.h"
#include "google/cloud/cloudbuild/internal/cloud_build_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace cloudbuild {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudBuildConnection::~CloudBuildConnection() = default;

future<StatusOr<google::devtools::cloudbuild::v1::Build>>
CloudBuildConnection::CreateBuild(
    google::devtools::cloudbuild::v1::CreateBuildRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::cloudbuild::v1::Build>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::devtools::cloudbuild::v1::Build>
CloudBuildConnection::GetBuild(
    google::devtools::cloudbuild::v1::GetBuildRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::devtools::cloudbuild::v1::Build>
CloudBuildConnection::ListBuilds(
    google::devtools::cloudbuild::v1::ListBuildsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::devtools::cloudbuild::v1::Build>>(
      std::move(request),
      [](google::devtools::cloudbuild::v1::ListBuildsRequest const&) {
        return StatusOr<google::devtools::cloudbuild::v1::ListBuildsResponse>{};
      },
      [](google::devtools::cloudbuild::v1::ListBuildsResponse const&) {
        return std::vector<google::devtools::cloudbuild::v1::Build>();
      });
}

StatusOr<google::devtools::cloudbuild::v1::Build>
CloudBuildConnection::CancelBuild(
    google::devtools::cloudbuild::v1::CancelBuildRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::devtools::cloudbuild::v1::Build>>
CloudBuildConnection::RetryBuild(
    google::devtools::cloudbuild::v1::RetryBuildRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::cloudbuild::v1::Build>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::devtools::cloudbuild::v1::Build>>
CloudBuildConnection::ApproveBuild(
    google::devtools::cloudbuild::v1::ApproveBuildRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::cloudbuild::v1::Build>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::devtools::cloudbuild::v1::BuildTrigger>
CloudBuildConnection::CreateBuildTrigger(
    google::devtools::cloudbuild::v1::CreateBuildTriggerRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::devtools::cloudbuild::v1::BuildTrigger>
CloudBuildConnection::GetBuildTrigger(
    google::devtools::cloudbuild::v1::GetBuildTriggerRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::devtools::cloudbuild::v1::BuildTrigger>
CloudBuildConnection::ListBuildTriggers(
    google::devtools::cloudbuild::v1::ListBuildTriggersRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::devtools::cloudbuild::v1::BuildTrigger>>(
      std::move(request),
      [](google::devtools::cloudbuild::v1::ListBuildTriggersRequest const&) {
        return StatusOr<
            google::devtools::cloudbuild::v1::ListBuildTriggersResponse>{};
      },
      [](google::devtools::cloudbuild::v1::ListBuildTriggersResponse const&) {
        return std::vector<google::devtools::cloudbuild::v1::BuildTrigger>();
      });
}

Status CloudBuildConnection::DeleteBuildTrigger(
    google::devtools::cloudbuild::v1::DeleteBuildTriggerRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::devtools::cloudbuild::v1::BuildTrigger>
CloudBuildConnection::UpdateBuildTrigger(
    google::devtools::cloudbuild::v1::UpdateBuildTriggerRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::devtools::cloudbuild::v1::Build>>
CloudBuildConnection::RunBuildTrigger(
    google::devtools::cloudbuild::v1::RunBuildTriggerRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::cloudbuild::v1::Build>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::devtools::cloudbuild::v1::ReceiveTriggerWebhookResponse>
CloudBuildConnection::ReceiveTriggerWebhook(
    google::devtools::cloudbuild::v1::ReceiveTriggerWebhookRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::devtools::cloudbuild::v1::WorkerPool>>
CloudBuildConnection::CreateWorkerPool(
    google::devtools::cloudbuild::v1::CreateWorkerPoolRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::cloudbuild::v1::WorkerPool>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::devtools::cloudbuild::v1::WorkerPool>
CloudBuildConnection::GetWorkerPool(
    google::devtools::cloudbuild::v1::GetWorkerPoolRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<
    google::devtools::cloudbuild::v1::DeleteWorkerPoolOperationMetadata>>
CloudBuildConnection::DeleteWorkerPool(
    google::devtools::cloudbuild::v1::DeleteWorkerPoolRequest const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::devtools::cloudbuild::v1::DeleteWorkerPoolOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::devtools::cloudbuild::v1::WorkerPool>>
CloudBuildConnection::UpdateWorkerPool(
    google::devtools::cloudbuild::v1::UpdateWorkerPoolRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::devtools::cloudbuild::v1::WorkerPool>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::devtools::cloudbuild::v1::WorkerPool>
CloudBuildConnection::ListWorkerPools(
    google::devtools::cloudbuild::v1::ListWorkerPoolsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::devtools::cloudbuild::v1::WorkerPool>>(
      std::move(request),
      [](google::devtools::cloudbuild::v1::ListWorkerPoolsRequest const&) {
        return StatusOr<
            google::devtools::cloudbuild::v1::ListWorkerPoolsResponse>{};
      },
      [](google::devtools::cloudbuild::v1::ListWorkerPoolsResponse const&) {
        return std::vector<google::devtools::cloudbuild::v1::WorkerPool>();
      });
}

std::shared_ptr<CloudBuildConnection> MakeCloudBuildConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 CloudBuildPolicyOptionList>(options, __func__);
  options = cloudbuild_internal::CloudBuildDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = cloudbuild_internal::CreateDefaultCloudBuildStub(background->cq(),
                                                               options);
  return std::make_shared<cloudbuild_internal::CloudBuildConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudbuild
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace cloudbuild_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<cloudbuild::CloudBuildConnection> MakeCloudBuildConnection(
    std::shared_ptr<CloudBuildStub> stub, Options options) {
  options = CloudBuildDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<cloudbuild_internal::CloudBuildConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudbuild_internal
}  // namespace cloud
}  // namespace google
