// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/channel/v1/service.proto

#include "google/cloud/channel/internal/cloud_channel_connection_impl.h"
#include "google/cloud/channel/internal/cloud_channel_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace channel_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudChannelServiceConnectionImpl::CloudChannelServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<channel_internal::CloudChannelServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options),
          channel_internal::CloudChannelServiceDefaultOptions(
              CloudChannelServiceConnection::options()))) {}

StreamRange<google::cloud::channel::v1::Customer>
CloudChannelServiceConnectionImpl::ListCustomers(
    google::cloud::channel::v1::ListCustomersRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<channel::CloudChannelServiceRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListCustomers(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::Customer>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::channel::v1::ListCustomersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::channel::v1::ListCustomersRequest const&
                       request) {
              return stub->ListCustomers(context, request);
            },
            r, function_name);
      },
      [](google::cloud::channel::v1::ListCustomersResponse r) {
        std::vector<google::cloud::channel::v1::Customer> result(
            r.customers().size());
        auto& messages = *r.mutable_customers();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::channel::v1::Customer>
CloudChannelServiceConnectionImpl::GetCustomer(
    google::cloud::channel::v1::GetCustomerRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetCustomer(request),
      [this](grpc::ClientContext& context,
             google::cloud::channel::v1::GetCustomerRequest const& request) {
        return stub_->GetCustomer(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::channel::v1::CheckCloudIdentityAccountsExistResponse>
CloudChannelServiceConnectionImpl::CheckCloudIdentityAccountsExist(
    google::cloud::channel::v1::CheckCloudIdentityAccountsExistRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CheckCloudIdentityAccountsExist(request),
      [this](grpc::ClientContext& context,
             google::cloud::channel::v1::
                 CheckCloudIdentityAccountsExistRequest const& request) {
        return stub_->CheckCloudIdentityAccountsExist(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::channel::v1::Customer>
CloudChannelServiceConnectionImpl::CreateCustomer(
    google::cloud::channel::v1::CreateCustomerRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateCustomer(request),
      [this](grpc::ClientContext& context,
             google::cloud::channel::v1::CreateCustomerRequest const& request) {
        return stub_->CreateCustomer(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::channel::v1::Customer>
CloudChannelServiceConnectionImpl::UpdateCustomer(
    google::cloud::channel::v1::UpdateCustomerRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateCustomer(request),
      [this](grpc::ClientContext& context,
             google::cloud::channel::v1::UpdateCustomerRequest const& request) {
        return stub_->UpdateCustomer(context, request);
      },
      request, __func__);
}

Status CloudChannelServiceConnectionImpl::DeleteCustomer(
    google::cloud::channel::v1::DeleteCustomerRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteCustomer(request),
      [this](grpc::ClientContext& context,
             google::cloud::channel::v1::DeleteCustomerRequest const& request) {
        return stub_->DeleteCustomer(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::channel::v1::Customer>
CloudChannelServiceConnectionImpl::ImportCustomer(
    google::cloud::channel::v1::ImportCustomerRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->ImportCustomer(request),
      [this](grpc::ClientContext& context,
             google::cloud::channel::v1::ImportCustomerRequest const& request) {
        return stub_->ImportCustomer(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::channel::v1::Customer>>
CloudChannelServiceConnectionImpl::ProvisionCloudIdentity(
    google::cloud::channel::v1::ProvisionCloudIdentityRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::channel::v1::Customer>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::channel::v1::ProvisionCloudIdentityRequest const&
                 request) {
        return stub->AsyncProvisionCloudIdentity(cq, std::move(context),
                                                 request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::channel::v1::Customer>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->ProvisionCloudIdentity(request), polling_policy(),
      __func__);
}

StreamRange<google::cloud::channel::v1::Entitlement>
CloudChannelServiceConnectionImpl::ListEntitlements(
    google::cloud::channel::v1::ListEntitlementsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<channel::CloudChannelServiceRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListEntitlements(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::Entitlement>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::channel::v1::ListEntitlementsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::channel::v1::ListEntitlementsRequest const&
                       request) {
              return stub->ListEntitlements(context, request);
            },
            r, function_name);
      },
      [](google::cloud::channel::v1::ListEntitlementsResponse r) {
        std::vector<google::cloud::channel::v1::Entitlement> result(
            r.entitlements().size());
        auto& messages = *r.mutable_entitlements();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::channel::v1::TransferableSku>
CloudChannelServiceConnectionImpl::ListTransferableSkus(
    google::cloud::channel::v1::ListTransferableSkusRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<channel::CloudChannelServiceRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListTransferableSkus(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::TransferableSku>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::channel::v1::ListTransferableSkusRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::channel::v1::ListTransferableSkusRequest const&
                    request) {
              return stub->ListTransferableSkus(context, request);
            },
            r, function_name);
      },
      [](google::cloud::channel::v1::ListTransferableSkusResponse r) {
        std::vector<google::cloud::channel::v1::TransferableSku> result(
            r.transferable_skus().size());
        auto& messages = *r.mutable_transferable_skus();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::channel::v1::TransferableOffer>
CloudChannelServiceConnectionImpl::ListTransferableOffers(
    google::cloud::channel::v1::ListTransferableOffersRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<channel::CloudChannelServiceRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListTransferableOffers(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::TransferableOffer>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::channel::v1::ListTransferableOffersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::channel::v1::ListTransferableOffersRequest const&
                    request) {
              return stub->ListTransferableOffers(context, request);
            },
            r, function_name);
      },
      [](google::cloud::channel::v1::ListTransferableOffersResponse r) {
        std::vector<google::cloud::channel::v1::TransferableOffer> result(
            r.transferable_offers().size());
        auto& messages = *r.mutable_transferable_offers();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::channel::v1::Entitlement>
CloudChannelServiceConnectionImpl::GetEntitlement(
    google::cloud::channel::v1::GetEntitlementRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetEntitlement(request),
      [this](grpc::ClientContext& context,
             google::cloud::channel::v1::GetEntitlementRequest const& request) {
        return stub_->GetEntitlement(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceConnectionImpl::CreateEntitlement(
    google::cloud::channel::v1::CreateEntitlementRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::channel::v1::Entitlement>(
      background_->cq(), request,
      [stub](
          google::cloud::CompletionQueue& cq,
          std::unique_ptr<grpc::ClientContext> context,
          google::cloud::channel::v1::CreateEntitlementRequest const& request) {
        return stub->AsyncCreateEntitlement(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::channel::v1::Entitlement>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateEntitlement(request), polling_policy(),
      __func__);
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceConnectionImpl::ChangeParameters(
    google::cloud::channel::v1::ChangeParametersRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::channel::v1::Entitlement>(
      background_->cq(), request,
      [stub](
          google::cloud::CompletionQueue& cq,
          std::unique_ptr<grpc::ClientContext> context,
          google::cloud::channel::v1::ChangeParametersRequest const& request) {
        return stub->AsyncChangeParameters(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::channel::v1::Entitlement>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->ChangeParameters(request), polling_policy(),
      __func__);
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceConnectionImpl::ChangeRenewalSettings(
    google::cloud::channel::v1::ChangeRenewalSettingsRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::channel::v1::Entitlement>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::channel::v1::ChangeRenewalSettingsRequest const&
                 request) {
        return stub->AsyncChangeRenewalSettings(cq, std::move(context),
                                                request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::channel::v1::Entitlement>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->ChangeRenewalSettings(request), polling_policy(),
      __func__);
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceConnectionImpl::ChangeOffer(
    google::cloud::channel::v1::ChangeOfferRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::channel::v1::Entitlement>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::channel::v1::ChangeOfferRequest const& request) {
        return stub->AsyncChangeOffer(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::channel::v1::Entitlement>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->ChangeOffer(request), polling_policy(), __func__);
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceConnectionImpl::StartPaidService(
    google::cloud::channel::v1::StartPaidServiceRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::channel::v1::Entitlement>(
      background_->cq(), request,
      [stub](
          google::cloud::CompletionQueue& cq,
          std::unique_ptr<grpc::ClientContext> context,
          google::cloud::channel::v1::StartPaidServiceRequest const& request) {
        return stub->AsyncStartPaidService(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::channel::v1::Entitlement>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->StartPaidService(request), polling_policy(),
      __func__);
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceConnectionImpl::SuspendEntitlement(
    google::cloud::channel::v1::SuspendEntitlementRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::channel::v1::Entitlement>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::channel::v1::SuspendEntitlementRequest const&
                 request) {
        return stub->AsyncSuspendEntitlement(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::channel::v1::Entitlement>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->SuspendEntitlement(request), polling_policy(),
      __func__);
}

future<StatusOr<google::cloud::channel::v1::OperationMetadata>>
CloudChannelServiceConnectionImpl::CancelEntitlement(
    google::cloud::channel::v1::CancelEntitlementRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::channel::v1::OperationMetadata>(
      background_->cq(), request,
      [stub](
          google::cloud::CompletionQueue& cq,
          std::unique_ptr<grpc::ClientContext> context,
          google::cloud::channel::v1::CancelEntitlementRequest const& request) {
        return stub->AsyncCancelEntitlement(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::channel::v1::OperationMetadata>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->CancelEntitlement(request), polling_policy(),
      __func__);
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceConnectionImpl::ActivateEntitlement(
    google::cloud::channel::v1::ActivateEntitlementRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::channel::v1::Entitlement>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::channel::v1::ActivateEntitlementRequest const&
                 request) {
        return stub->AsyncActivateEntitlement(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::channel::v1::Entitlement>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->ActivateEntitlement(request), polling_policy(),
      __func__);
}

future<StatusOr<google::cloud::channel::v1::TransferEntitlementsResponse>>
CloudChannelServiceConnectionImpl::TransferEntitlements(
    google::cloud::channel::v1::TransferEntitlementsRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::channel::v1::TransferEntitlementsResponse>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::channel::v1::TransferEntitlementsRequest const&
                 request) {
        return stub->AsyncTransferEntitlements(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::channel::v1::TransferEntitlementsResponse>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->TransferEntitlements(request), polling_policy(),
      __func__);
}

future<StatusOr<google::cloud::channel::v1::OperationMetadata>>
CloudChannelServiceConnectionImpl::TransferEntitlementsToGoogle(
    google::cloud::channel::v1::TransferEntitlementsToGoogleRequest const&
        request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::channel::v1::OperationMetadata>(
      background_->cq(), request,
      [stub](
          google::cloud::CompletionQueue& cq,
          std::unique_ptr<grpc::ClientContext> context,
          google::cloud::channel::v1::TransferEntitlementsToGoogleRequest const&
              request) {
        return stub->AsyncTransferEntitlementsToGoogle(cq, std::move(context),
                                                       request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::channel::v1::OperationMetadata>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->TransferEntitlementsToGoogle(request),
      polling_policy(), __func__);
}

StreamRange<google::cloud::channel::v1::ChannelPartnerLink>
CloudChannelServiceConnectionImpl::ListChannelPartnerLinks(
    google::cloud::channel::v1::ListChannelPartnerLinksRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<channel::CloudChannelServiceRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListChannelPartnerLinks(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::ChannelPartnerLink>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::channel::v1::ListChannelPartnerLinksRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::channel::v1::
                       ListChannelPartnerLinksRequest const& request) {
              return stub->ListChannelPartnerLinks(context, request);
            },
            r, function_name);
      },
      [](google::cloud::channel::v1::ListChannelPartnerLinksResponse r) {
        std::vector<google::cloud::channel::v1::ChannelPartnerLink> result(
            r.channel_partner_links().size());
        auto& messages = *r.mutable_channel_partner_links();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::channel::v1::ChannelPartnerLink>
CloudChannelServiceConnectionImpl::GetChannelPartnerLink(
    google::cloud::channel::v1::GetChannelPartnerLinkRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetChannelPartnerLink(request),
      [this](grpc::ClientContext& context,
             google::cloud::channel::v1::GetChannelPartnerLinkRequest const&
                 request) {
        return stub_->GetChannelPartnerLink(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::channel::v1::ChannelPartnerLink>
CloudChannelServiceConnectionImpl::CreateChannelPartnerLink(
    google::cloud::channel::v1::CreateChannelPartnerLinkRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateChannelPartnerLink(request),
      [this](grpc::ClientContext& context,
             google::cloud::channel::v1::CreateChannelPartnerLinkRequest const&
                 request) {
        return stub_->CreateChannelPartnerLink(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::channel::v1::ChannelPartnerLink>
CloudChannelServiceConnectionImpl::UpdateChannelPartnerLink(
    google::cloud::channel::v1::UpdateChannelPartnerLinkRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateChannelPartnerLink(request),
      [this](grpc::ClientContext& context,
             google::cloud::channel::v1::UpdateChannelPartnerLinkRequest const&
                 request) {
        return stub_->UpdateChannelPartnerLink(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::channel::v1::Offer>
CloudChannelServiceConnectionImpl::LookupOffer(
    google::cloud::channel::v1::LookupOfferRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->LookupOffer(request),
      [this](grpc::ClientContext& context,
             google::cloud::channel::v1::LookupOfferRequest const& request) {
        return stub_->LookupOffer(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::channel::v1::Product>
CloudChannelServiceConnectionImpl::ListProducts(
    google::cloud::channel::v1::ListProductsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<channel::CloudChannelServiceRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListProducts(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::Product>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::channel::v1::ListProductsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::channel::v1::ListProductsRequest const&
                       request) {
              return stub->ListProducts(context, request);
            },
            r, function_name);
      },
      [](google::cloud::channel::v1::ListProductsResponse r) {
        std::vector<google::cloud::channel::v1::Product> result(
            r.products().size());
        auto& messages = *r.mutable_products();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::channel::v1::Sku>
CloudChannelServiceConnectionImpl::ListSkus(
    google::cloud::channel::v1::ListSkusRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<channel::CloudChannelServiceRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListSkus(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::Sku>>(
      std::move(request),
      [stub, retry, backoff, idempotency,
       function_name](google::cloud::channel::v1::ListSkusRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::channel::v1::ListSkusRequest const& request) {
              return stub->ListSkus(context, request);
            },
            r, function_name);
      },
      [](google::cloud::channel::v1::ListSkusResponse r) {
        std::vector<google::cloud::channel::v1::Sku> result(r.skus().size());
        auto& messages = *r.mutable_skus();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::channel::v1::Offer>
CloudChannelServiceConnectionImpl::ListOffers(
    google::cloud::channel::v1::ListOffersRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<channel::CloudChannelServiceRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListOffers(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::Offer>>(
      std::move(request),
      [stub, retry, backoff, idempotency,
       function_name](google::cloud::channel::v1::ListOffersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::channel::v1::ListOffersRequest const& request) {
              return stub->ListOffers(context, request);
            },
            r, function_name);
      },
      [](google::cloud::channel::v1::ListOffersResponse r) {
        std::vector<google::cloud::channel::v1::Offer> result(
            r.offers().size());
        auto& messages = *r.mutable_offers();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::channel::v1::PurchasableSku>
CloudChannelServiceConnectionImpl::ListPurchasableSkus(
    google::cloud::channel::v1::ListPurchasableSkusRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<channel::CloudChannelServiceRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListPurchasableSkus(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::PurchasableSku>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::channel::v1::ListPurchasableSkusRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::channel::v1::ListPurchasableSkusRequest const&
                       request) {
              return stub->ListPurchasableSkus(context, request);
            },
            r, function_name);
      },
      [](google::cloud::channel::v1::ListPurchasableSkusResponse r) {
        std::vector<google::cloud::channel::v1::PurchasableSku> result(
            r.purchasable_skus().size());
        auto& messages = *r.mutable_purchasable_skus();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::channel::v1::PurchasableOffer>
CloudChannelServiceConnectionImpl::ListPurchasableOffers(
    google::cloud::channel::v1::ListPurchasableOffersRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<channel::CloudChannelServiceRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListPurchasableOffers(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::PurchasableOffer>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::channel::v1::ListPurchasableOffersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::channel::v1::ListPurchasableOffersRequest const&
                    request) {
              return stub->ListPurchasableOffers(context, request);
            },
            r, function_name);
      },
      [](google::cloud::channel::v1::ListPurchasableOffersResponse r) {
        std::vector<google::cloud::channel::v1::PurchasableOffer> result(
            r.purchasable_offers().size());
        auto& messages = *r.mutable_purchasable_offers();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::channel::v1::RegisterSubscriberResponse>
CloudChannelServiceConnectionImpl::RegisterSubscriber(
    google::cloud::channel::v1::RegisterSubscriberRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->RegisterSubscriber(request),
      [this](grpc::ClientContext& context,
             google::cloud::channel::v1::RegisterSubscriberRequest const&
                 request) {
        return stub_->RegisterSubscriber(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::channel::v1::UnregisterSubscriberResponse>
CloudChannelServiceConnectionImpl::UnregisterSubscriber(
    google::cloud::channel::v1::UnregisterSubscriberRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UnregisterSubscriber(request),
      [this](grpc::ClientContext& context,
             google::cloud::channel::v1::UnregisterSubscriberRequest const&
                 request) {
        return stub_->UnregisterSubscriber(context, request);
      },
      request, __func__);
}

StreamRange<std::string> CloudChannelServiceConnectionImpl::ListSubscribers(
    google::cloud::channel::v1::ListSubscribersRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<channel::CloudChannelServiceRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListSubscribers(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<std::string>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::channel::v1::ListSubscribersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::channel::v1::ListSubscribersRequest const&
                       request) {
              return stub->ListSubscribers(context, request);
            },
            r, function_name);
      },
      [](google::cloud::channel::v1::ListSubscribersResponse r) {
        std::vector<std::string> result(r.service_accounts().size());
        auto& messages = *r.mutable_service_accounts();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace channel_internal
}  // namespace cloud
}  // namespace google
