// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/channel/v1/service.proto

#include "google/cloud/channel/cloud_channel_connection.h"
#include "google/cloud/channel/cloud_channel_options.h"
#include "google/cloud/channel/internal/cloud_channel_connection_impl.h"
#include "google/cloud/channel/internal/cloud_channel_option_defaults.h"
#include "google/cloud/channel/internal/cloud_channel_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace channel {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudChannelServiceConnection::~CloudChannelServiceConnection() = default;

StreamRange<google::cloud::channel::v1::Customer>
CloudChannelServiceConnection::ListCustomers(
    google::cloud::channel::v1::ListCustomersRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::Customer>>(
      std::move(request),
      [](google::cloud::channel::v1::ListCustomersRequest const&) {
        return StatusOr<google::cloud::channel::v1::ListCustomersResponse>{};
      },
      [](google::cloud::channel::v1::ListCustomersResponse const&) {
        return std::vector<google::cloud::channel::v1::Customer>();
      });
}

StatusOr<google::cloud::channel::v1::Customer>
CloudChannelServiceConnection::GetCustomer(
    google::cloud::channel::v1::GetCustomerRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::channel::v1::CheckCloudIdentityAccountsExistResponse>
CloudChannelServiceConnection::CheckCloudIdentityAccountsExist(
    google::cloud::channel::v1::CheckCloudIdentityAccountsExistRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::channel::v1::Customer>
CloudChannelServiceConnection::CreateCustomer(
    google::cloud::channel::v1::CreateCustomerRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::channel::v1::Customer>
CloudChannelServiceConnection::UpdateCustomer(
    google::cloud::channel::v1::UpdateCustomerRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status CloudChannelServiceConnection::DeleteCustomer(
    google::cloud::channel::v1::DeleteCustomerRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::channel::v1::Customer>
CloudChannelServiceConnection::ImportCustomer(
    google::cloud::channel::v1::ImportCustomerRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::channel::v1::Customer>>
CloudChannelServiceConnection::ProvisionCloudIdentity(
    google::cloud::channel::v1::ProvisionCloudIdentityRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::channel::v1::Customer>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::channel::v1::Entitlement>
CloudChannelServiceConnection::ListEntitlements(
    google::cloud::channel::v1::ListEntitlementsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::Entitlement>>(
      std::move(request),
      [](google::cloud::channel::v1::ListEntitlementsRequest const&) {
        return StatusOr<google::cloud::channel::v1::ListEntitlementsResponse>{};
      },
      [](google::cloud::channel::v1::ListEntitlementsResponse const&) {
        return std::vector<google::cloud::channel::v1::Entitlement>();
      });
}

StreamRange<google::cloud::channel::v1::TransferableSku>
CloudChannelServiceConnection::ListTransferableSkus(
    google::cloud::channel::v1::ListTransferableSkusRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::TransferableSku>>(
      std::move(request),
      [](google::cloud::channel::v1::ListTransferableSkusRequest const&) {
        return StatusOr<
            google::cloud::channel::v1::ListTransferableSkusResponse>{};
      },
      [](google::cloud::channel::v1::ListTransferableSkusResponse const&) {
        return std::vector<google::cloud::channel::v1::TransferableSku>();
      });
}

StreamRange<google::cloud::channel::v1::TransferableOffer>
CloudChannelServiceConnection::ListTransferableOffers(
    google::cloud::channel::v1::ListTransferableOffersRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::TransferableOffer>>(
      std::move(request),
      [](google::cloud::channel::v1::ListTransferableOffersRequest const&) {
        return StatusOr<
            google::cloud::channel::v1::ListTransferableOffersResponse>{};
      },
      [](google::cloud::channel::v1::ListTransferableOffersResponse const&) {
        return std::vector<google::cloud::channel::v1::TransferableOffer>();
      });
}

StatusOr<google::cloud::channel::v1::Entitlement>
CloudChannelServiceConnection::GetEntitlement(
    google::cloud::channel::v1::GetEntitlementRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceConnection::CreateEntitlement(
    google::cloud::channel::v1::CreateEntitlementRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::channel::v1::Entitlement>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceConnection::ChangeParameters(
    google::cloud::channel::v1::ChangeParametersRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::channel::v1::Entitlement>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceConnection::ChangeRenewalSettings(
    google::cloud::channel::v1::ChangeRenewalSettingsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::channel::v1::Entitlement>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceConnection::ChangeOffer(
    google::cloud::channel::v1::ChangeOfferRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::channel::v1::Entitlement>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceConnection::StartPaidService(
    google::cloud::channel::v1::StartPaidServiceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::channel::v1::Entitlement>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceConnection::SuspendEntitlement(
    google::cloud::channel::v1::SuspendEntitlementRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::channel::v1::Entitlement>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::channel::v1::OperationMetadata>>
CloudChannelServiceConnection::CancelEntitlement(
    google::cloud::channel::v1::CancelEntitlementRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::channel::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::channel::v1::Entitlement>>
CloudChannelServiceConnection::ActivateEntitlement(
    google::cloud::channel::v1::ActivateEntitlementRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::channel::v1::Entitlement>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::channel::v1::TransferEntitlementsResponse>>
CloudChannelServiceConnection::TransferEntitlements(
    google::cloud::channel::v1::TransferEntitlementsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::channel::v1::TransferEntitlementsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::channel::v1::OperationMetadata>>
CloudChannelServiceConnection::TransferEntitlementsToGoogle(
    google::cloud::channel::v1::TransferEntitlementsToGoogleRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::channel::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::channel::v1::ChannelPartnerLink>
CloudChannelServiceConnection::ListChannelPartnerLinks(
    google::cloud::channel::v1::ListChannelPartnerLinksRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::ChannelPartnerLink>>(
      std::move(request),
      [](google::cloud::channel::v1::ListChannelPartnerLinksRequest const&) {
        return StatusOr<
            google::cloud::channel::v1::ListChannelPartnerLinksResponse>{};
      },
      [](google::cloud::channel::v1::ListChannelPartnerLinksResponse const&) {
        return std::vector<google::cloud::channel::v1::ChannelPartnerLink>();
      });
}

StatusOr<google::cloud::channel::v1::ChannelPartnerLink>
CloudChannelServiceConnection::GetChannelPartnerLink(
    google::cloud::channel::v1::GetChannelPartnerLinkRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::channel::v1::ChannelPartnerLink>
CloudChannelServiceConnection::CreateChannelPartnerLink(
    google::cloud::channel::v1::CreateChannelPartnerLinkRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::channel::v1::ChannelPartnerLink>
CloudChannelServiceConnection::UpdateChannelPartnerLink(
    google::cloud::channel::v1::UpdateChannelPartnerLinkRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::channel::v1::Offer>
CloudChannelServiceConnection::LookupOffer(
    google::cloud::channel::v1::LookupOfferRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::channel::v1::Product>
CloudChannelServiceConnection::ListProducts(
    google::cloud::channel::v1::ListProductsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::Product>>(
      std::move(request),
      [](google::cloud::channel::v1::ListProductsRequest const&) {
        return StatusOr<google::cloud::channel::v1::ListProductsResponse>{};
      },
      [](google::cloud::channel::v1::ListProductsResponse const&) {
        return std::vector<google::cloud::channel::v1::Product>();
      });
}

StreamRange<google::cloud::channel::v1::Sku>
CloudChannelServiceConnection::ListSkus(
    google::cloud::channel::v1::ListSkusRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::Sku>>(
      std::move(request),
      [](google::cloud::channel::v1::ListSkusRequest const&) {
        return StatusOr<google::cloud::channel::v1::ListSkusResponse>{};
      },
      [](google::cloud::channel::v1::ListSkusResponse const&) {
        return std::vector<google::cloud::channel::v1::Sku>();
      });
}

StreamRange<google::cloud::channel::v1::Offer>
CloudChannelServiceConnection::ListOffers(
    google::cloud::channel::v1::ListOffersRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::Offer>>(
      std::move(request),
      [](google::cloud::channel::v1::ListOffersRequest const&) {
        return StatusOr<google::cloud::channel::v1::ListOffersResponse>{};
      },
      [](google::cloud::channel::v1::ListOffersResponse const&) {
        return std::vector<google::cloud::channel::v1::Offer>();
      });
}

StreamRange<google::cloud::channel::v1::PurchasableSku>
CloudChannelServiceConnection::ListPurchasableSkus(
    google::cloud::channel::v1::ListPurchasableSkusRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::PurchasableSku>>(
      std::move(request),
      [](google::cloud::channel::v1::ListPurchasableSkusRequest const&) {
        return StatusOr<
            google::cloud::channel::v1::ListPurchasableSkusResponse>{};
      },
      [](google::cloud::channel::v1::ListPurchasableSkusResponse const&) {
        return std::vector<google::cloud::channel::v1::PurchasableSku>();
      });
}

StreamRange<google::cloud::channel::v1::PurchasableOffer>
CloudChannelServiceConnection::ListPurchasableOffers(
    google::cloud::channel::v1::ListPurchasableOffersRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::channel::v1::PurchasableOffer>>(
      std::move(request),
      [](google::cloud::channel::v1::ListPurchasableOffersRequest const&) {
        return StatusOr<
            google::cloud::channel::v1::ListPurchasableOffersResponse>{};
      },
      [](google::cloud::channel::v1::ListPurchasableOffersResponse const&) {
        return std::vector<google::cloud::channel::v1::PurchasableOffer>();
      });
}

StatusOr<google::cloud::channel::v1::RegisterSubscriberResponse>
CloudChannelServiceConnection::RegisterSubscriber(
    google::cloud::channel::v1::RegisterSubscriberRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::channel::v1::UnregisterSubscriberResponse>
CloudChannelServiceConnection::UnregisterSubscriber(
    google::cloud::channel::v1::UnregisterSubscriberRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<std::string> CloudChannelServiceConnection::ListSubscribers(
    google::cloud::channel::v1::ListSubscribersRequest request) {
  return google::cloud::internal::MakePaginationRange<StreamRange<std::string>>(
      std::move(request),
      [](google::cloud::channel::v1::ListSubscribersRequest const&) {
        return StatusOr<google::cloud::channel::v1::ListSubscribersResponse>{};
      },
      [](google::cloud::channel::v1::ListSubscribersResponse const&) {
        return std::vector<std::string>();
      });
}

std::shared_ptr<CloudChannelServiceConnection>
MakeCloudChannelServiceConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 CloudChannelServicePolicyOptionList>(options,
                                                                      __func__);
  options =
      channel_internal::CloudChannelServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = channel_internal::CreateDefaultCloudChannelServiceStub(
      background->cq(), options);
  return std::make_shared<channel_internal::CloudChannelServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace channel
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace channel_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<channel::CloudChannelServiceConnection>
MakeCloudChannelServiceConnection(std::shared_ptr<CloudChannelServiceStub> stub,
                                  Options options) {
  options = CloudChannelServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<channel_internal::CloudChannelServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace channel_internal
}  // namespace cloud
}  // namespace google
