// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/channel/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CHANNEL_CLOUD_CHANNEL_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CHANNEL_CLOUD_CHANNEL_CLIENT_H

#include "google/cloud/channel/cloud_channel_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace channel {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// CloudChannelService lets Google cloud resellers and distributors manage
/// their customers, channel partners, entitlements, and reports.
///
/// Using this service:
/// 1. Resellers and distributors can manage a customer entity.
/// 2. Distributors can register an authorized reseller in their channel and
///    provide them with delegated admin access.
/// 3. Resellers and distributors can manage customer entitlements.
///
/// CloudChannelService exposes the following resources:
/// - [Customer][google.cloud.channel.v1.Customer]s: An entity—usually an
/// enterprise—managed by a reseller or distributor.
///
/// - [Entitlement][google.cloud.channel.v1.Entitlement]s: An entity that
/// provides a customer with the means to use a service. Entitlements are
/// created or updated as a result of a successful fulfillment.
///
/// - [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]s: An
/// entity that identifies links between distributors and their indirect
/// resellers in a channel.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class CloudChannelServiceClient {
 public:
  explicit CloudChannelServiceClient(
      std::shared_ptr<CloudChannelServiceConnection> connection,
      Options options = {});
  ~CloudChannelServiceClient();

  //@{
  // @name Copy and move support
  CloudChannelServiceClient(CloudChannelServiceClient const&) = default;
  CloudChannelServiceClient& operator=(CloudChannelServiceClient const&) =
      default;
  CloudChannelServiceClient(CloudChannelServiceClient&&) = default;
  CloudChannelServiceClient& operator=(CloudChannelServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(CloudChannelServiceClient const& a,
                         CloudChannelServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(CloudChannelServiceClient const& a,
                         CloudChannelServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// List [Customer][google.cloud.channel.v1.Customer]s.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// Return value:
  /// List of [Customer][google.cloud.channel.v1.Customer]s, or an empty list if
  /// there are no customers.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::ListCustomersRequest,google/cloud/channel/v1/service.proto#L987}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Customer,google/cloud/channel/v1/customers.proto#L32}
  ///
  /// [google.cloud.channel.v1.ListCustomersRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L987}
  /// [google.cloud.channel.v1.Customer]:
  /// @googleapis_reference_link{google/cloud/channel/v1/customers.proto#L32}
  ///
  StreamRange<google::cloud::channel::v1::Customer> ListCustomers(
      google::cloud::channel::v1::ListCustomersRequest request,
      Options options = {});

  ///
  /// Returns the requested [Customer][google.cloud.channel.v1.Customer]
  /// resource.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: The customer resource doesn't exist. Usually the result of an
  /// invalid name parameter.
  ///
  /// Return value:
  /// The [Customer][google.cloud.channel.v1.Customer] resource.
  ///
  /// @param name  Required. The resource name of the customer to retrieve.
  ///  Name uses the format: accounts/{account_id}/customers/{customer_id}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Customer,google/cloud/channel/v1/customers.proto#L32}
  ///
  /// [google.cloud.channel.v1.GetCustomerRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1015}
  /// [google.cloud.channel.v1.Customer]:
  /// @googleapis_reference_link{google/cloud/channel/v1/customers.proto#L32}
  ///
  StatusOr<google::cloud::channel::v1::Customer> GetCustomer(
      std::string const& name, Options options = {});

  ///
  /// Returns the requested [Customer][google.cloud.channel.v1.Customer]
  /// resource.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: The customer resource doesn't exist. Usually the result of an
  /// invalid name parameter.
  ///
  /// Return value:
  /// The [Customer][google.cloud.channel.v1.Customer] resource.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::GetCustomerRequest,google/cloud/channel/v1/service.proto#L1015}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Customer,google/cloud/channel/v1/customers.proto#L32}
  ///
  /// [google.cloud.channel.v1.GetCustomerRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1015}
  /// [google.cloud.channel.v1.Customer]:
  /// @googleapis_reference_link{google/cloud/channel/v1/customers.proto#L32}
  ///
  StatusOr<google::cloud::channel::v1::Customer> GetCustomer(
      google::cloud::channel::v1::GetCustomerRequest const& request,
      Options options = {});

  ///
  /// Confirms the existence of Cloud Identity accounts based on the domain and
  /// if the Cloud Identity accounts are owned by the reseller.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * INVALID_VALUE: Invalid domain value in the request.
  ///
  /// Return value:
  /// A list of
  /// [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
  /// resources for the domain (may be empty)
  ///
  /// Note: in the v1alpha1 version of the API, a NOT_FOUND error returns if
  /// no
  /// [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
  /// resources match the domain.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::CheckCloudIdentityAccountsExistRequest,google/cloud/channel/v1/service.proto#L950}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::CheckCloudIdentityAccountsExistResponse,google/cloud/channel/v1/service.proto#L981}
  ///
  /// [google.cloud.channel.v1.CheckCloudIdentityAccountsExistRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L950}
  /// [google.cloud.channel.v1.CheckCloudIdentityAccountsExistResponse]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L981}
  ///
  StatusOr<google::cloud::channel::v1::CheckCloudIdentityAccountsExistResponse>
  CheckCloudIdentityAccountsExist(
      google::cloud::channel::v1::CheckCloudIdentityAccountsExistRequest const&
          request,
      Options options = {});

  ///
  /// Creates a new [Customer][google.cloud.channel.v1.Customer] resource under
  /// the reseller or distributor account.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT:
  ///     * Required request parameters are missing or invalid.
  ///     * Domain field value doesn't match the primary email domain.
  ///
  /// Return value:
  /// The newly created [Customer][google.cloud.channel.v1.Customer] resource.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::CreateCustomerRequest,google/cloud/channel/v1/service.proto#L1027}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Customer,google/cloud/channel/v1/customers.proto#L32}
  ///
  /// [google.cloud.channel.v1.CreateCustomerRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1027}
  /// [google.cloud.channel.v1.Customer]:
  /// @googleapis_reference_link{google/cloud/channel/v1/customers.proto#L32}
  ///
  StatusOr<google::cloud::channel::v1::Customer> CreateCustomer(
      google::cloud::channel::v1::CreateCustomerRequest const& request,
      Options options = {});

  ///
  /// Updates an existing [Customer][google.cloud.channel.v1.Customer] resource
  /// for the reseller or distributor.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource
  /// found for the name in the request.
  ///
  /// Return value:
  /// The updated [Customer][google.cloud.channel.v1.Customer] resource.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::UpdateCustomerRequest,google/cloud/channel/v1/service.proto#L1037}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Customer,google/cloud/channel/v1/customers.proto#L32}
  ///
  /// [google.cloud.channel.v1.UpdateCustomerRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1037}
  /// [google.cloud.channel.v1.Customer]:
  /// @googleapis_reference_link{google/cloud/channel/v1/customers.proto#L32}
  ///
  StatusOr<google::cloud::channel::v1::Customer> UpdateCustomer(
      google::cloud::channel::v1::UpdateCustomerRequest const& request,
      Options options = {});

  ///
  /// Deletes the given [Customer][google.cloud.channel.v1.Customer]
  /// permanently.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The account making the request does not own
  /// this customer.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * FAILED_PRECONDITION: The customer has existing entitlements.
  /// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource
  /// found for the name in the request.
  ///
  /// @param name  Required. The resource name of the customer to delete.
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.channel.v1.DeleteCustomerRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1047}
  ///
  Status DeleteCustomer(std::string const& name, Options options = {});

  ///
  /// Deletes the given [Customer][google.cloud.channel.v1.Customer]
  /// permanently.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The account making the request does not own
  /// this customer.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * FAILED_PRECONDITION: The customer has existing entitlements.
  /// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource
  /// found for the name in the request.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::DeleteCustomerRequest,google/cloud/channel/v1/service.proto#L1047}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.channel.v1.DeleteCustomerRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1047}
  ///
  Status DeleteCustomer(
      google::cloud::channel::v1::DeleteCustomerRequest const& request,
      Options options = {});

  ///
  /// Imports a [Customer][google.cloud.channel.v1.Customer] from the Cloud
  /// Identity associated with the provided Cloud Identity ID or domain before a
  /// TransferEntitlements call. If a linked Customer already exists and
  /// overwrite_if_exists is true, it will update that Customer's data.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * NOT_FOUND: Cloud Identity doesn't exist or was deleted.
  /// * INVALID_ARGUMENT: Required parameters are missing, or the auth_token is
  /// expired or invalid.
  /// * ALREADY_EXISTS: A customer already exists and has conflicting critical
  /// fields. Requires an overwrite.
  ///
  /// Return value:
  /// The [Customer][google.cloud.channel.v1.Customer].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::ImportCustomerRequest,google/cloud/channel/v1/service.proto#L1058}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Customer,google/cloud/channel/v1/customers.proto#L32}
  ///
  /// [google.cloud.channel.v1.ImportCustomerRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1058}
  /// [google.cloud.channel.v1.Customer]:
  /// @googleapis_reference_link{google/cloud/channel/v1/customers.proto#L32}
  ///
  StatusOr<google::cloud::channel::v1::Customer> ImportCustomer(
      google::cloud::channel::v1::ImportCustomerRequest const& request,
      Options options = {});

  ///
  /// Creates a Cloud Identity for the given customer using the customer's
  /// information, or the information provided here.
  ///
  /// Possible error codes:
  ///
  /// *  PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// *  INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// *  NOT_FOUND: The customer was not found.
  /// *  ALREADY_EXISTS: The customer's primary email already exists. Retry
  ///    after changing the customer's primary contact email.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata contains an
  /// instance of
  /// [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::ProvisionCloudIdentityRequest,google/cloud/channel/v1/service.proto#L1104}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Customer,google/cloud/channel/v1/customers.proto#L32}
  ///
  /// [google.cloud.channel.v1.ProvisionCloudIdentityRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1104}
  /// [google.cloud.channel.v1.Customer]:
  /// @googleapis_reference_link{google/cloud/channel/v1/customers.proto#L32}
  ///
  future<StatusOr<google::cloud::channel::v1::Customer>> ProvisionCloudIdentity(
      google::cloud::channel::v1::ProvisionCloudIdentityRequest const& request,
      Options options = {});

  ///
  /// Lists [Entitlement][google.cloud.channel.v1.Entitlement]s belonging to a
  /// customer.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// Return value:
  /// A list of the customer's
  /// [Entitlement][google.cloud.channel.v1.Entitlement]s.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::ListEntitlementsRequest,google/cloud/channel/v1/service.proto#L1125}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Entitlement,google/cloud/channel/v1/entitlements.proto#L34}
  ///
  /// [google.cloud.channel.v1.ListEntitlementsRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1125}
  /// [google.cloud.channel.v1.Entitlement]:
  /// @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L34}
  ///
  StreamRange<google::cloud::channel::v1::Entitlement> ListEntitlements(
      google::cloud::channel::v1::ListEntitlementsRequest request,
      Options options = {});

  ///
  /// List [TransferableSku][google.cloud.channel.v1.TransferableSku]s of a
  /// customer based on the Cloud Identity ID or Customer Name in the request.
  ///
  /// Use this method to list the entitlements information of an
  /// unowned customer. You should provide the customer's
  /// Cloud Identity ID or Customer Name.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED:
  ///     * The customer doesn't belong to the reseller and has no auth token.
  ///     * The supplied auth token is invalid.
  ///     * The reseller account making the request is different
  ///     from the reseller account in the query.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// Return value:
  /// A list of the customer's
  /// [TransferableSku][google.cloud.channel.v1.TransferableSku].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::ListTransferableSkusRequest,google/cloud/channel/v1/service.proto#L1159}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::TransferableSku,google/cloud/channel/v1/entitlements.proto#L214}
  ///
  /// [google.cloud.channel.v1.ListTransferableSkusRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1159}
  /// [google.cloud.channel.v1.TransferableSku]:
  /// @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L214}
  ///
  StreamRange<google::cloud::channel::v1::TransferableSku> ListTransferableSkus(
      google::cloud::channel::v1::ListTransferableSkusRequest request,
      Options options = {});

  ///
  /// List [TransferableOffer][google.cloud.channel.v1.TransferableOffer]s of a
  /// customer based on Cloud Identity ID or Customer Name in the request.
  ///
  /// Use this method when a reseller gets the entitlement information of an
  /// unowned customer. The reseller should provide the customer's
  /// Cloud Identity ID or Customer Name.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED:
  ///     * The customer doesn't belong to the reseller and has no auth token.
  ///     * The supplied auth token is invalid.
  ///     * The reseller account making the request is different
  ///     from the reseller account in the query.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// Return value:
  /// List of [TransferableOffer][google.cloud.channel.v1.TransferableOffer] for
  /// the given customer and SKU.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::ListTransferableOffersRequest,google/cloud/channel/v1/service.proto#L1216}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::TransferableOffer,google/cloud/channel/v1/service.proto#L1266}
  ///
  /// [google.cloud.channel.v1.ListTransferableOffersRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1216}
  /// [google.cloud.channel.v1.TransferableOffer]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1266}
  ///
  StreamRange<google::cloud::channel::v1::TransferableOffer>
  ListTransferableOffers(
      google::cloud::channel::v1::ListTransferableOffersRequest request,
      Options options = {});

  ///
  /// Returns the requested [Entitlement][google.cloud.channel.v1.Entitlement]
  /// resource.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: The customer entitlement was not found.
  ///
  /// Return value:
  /// The requested [Entitlement][google.cloud.channel.v1.Entitlement] resource.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::GetEntitlementRequest,google/cloud/channel/v1/service.proto#L1272}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Entitlement,google/cloud/channel/v1/entitlements.proto#L34}
  ///
  /// [google.cloud.channel.v1.GetEntitlementRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1272}
  /// [google.cloud.channel.v1.Entitlement]:
  /// @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L34}
  ///
  StatusOr<google::cloud::channel::v1::Entitlement> GetEntitlement(
      google::cloud::channel::v1::GetEntitlementRequest const& request,
      Options options = {});

  ///
  /// Creates an entitlement for a customer.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT:
  ///     * Required request parameters are missing or invalid.
  ///     * There is already a customer entitlement for a SKU from the same
  ///     product family.
  /// * INVALID_VALUE: Make sure the OfferId is valid. If it is, contact
  /// Google Channel support for further troubleshooting.
  /// * NOT_FOUND: The customer or offer resource was not found.
  /// * ALREADY_EXISTS:
  ///     * The SKU was already purchased for the customer.
  ///     * The customer's primary email already exists. Retry
  ///     after changing the customer's primary contact email.
  /// * CONDITION_NOT_MET or FAILED_PRECONDITION:
  ///     * The domain required for purchasing a SKU has not been verified.
  ///     * A pre-requisite SKU required to purchase an Add-On SKU is missing.
  ///     For example, Google Workspace Business Starter is required to purchase
  ///     Vault or Drive.
  ///     * (Developer accounts only) Reseller and resold domain must meet the
  ///     following naming requirements:
  ///         * Domain names must start with goog-test.
  ///         * Domain names must include the reseller domain.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata will contain an
  /// instance of
  /// [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::CreateEntitlementRequest,google/cloud/channel/v1/service.proto#L1358}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Entitlement,google/cloud/channel/v1/entitlements.proto#L34}
  ///
  /// [google.cloud.channel.v1.CreateEntitlementRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1358}
  /// [google.cloud.channel.v1.Entitlement]:
  /// @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L34}
  ///
  future<StatusOr<google::cloud::channel::v1::Entitlement>> CreateEntitlement(
      google::cloud::channel::v1::CreateEntitlementRequest const& request,
      Options options = {});

  ///
  /// Change parameters of the entitlement.
  ///
  /// An entitlement update is a long-running operation and it updates the
  /// entitlement as a result of fulfillment.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// For example, the number of seats being changed is greater than the allowed
  /// number of max seats, or decreasing seats for a commitment based plan.
  /// * NOT_FOUND: Entitlement resource not found.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata will contain an
  /// instance of
  /// [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::ChangeParametersRequest,google/cloud/channel/v1/service.proto#L1448}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Entitlement,google/cloud/channel/v1/entitlements.proto#L34}
  ///
  /// [google.cloud.channel.v1.ChangeParametersRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1448}
  /// [google.cloud.channel.v1.Entitlement]:
  /// @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L34}
  ///
  future<StatusOr<google::cloud::channel::v1::Entitlement>> ChangeParameters(
      google::cloud::channel::v1::ChangeParametersRequest const& request,
      Options options = {});

  ///
  /// Updates the renewal settings for an existing customer entitlement.
  ///
  /// An entitlement update is a long-running operation and it updates the
  /// entitlement as a result of fulfillment.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: Entitlement resource not found.
  /// * NOT_COMMITMENT_PLAN: Renewal Settings are only applicable for a
  /// commitment plan. Can't enable or disable renewals for non-commitment
  /// plans.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  ///   Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata will contain an
  /// instance of
  /// [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::ChangeRenewalSettingsRequest,google/cloud/channel/v1/service.proto#L1478}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Entitlement,google/cloud/channel/v1/entitlements.proto#L34}
  ///
  /// [google.cloud.channel.v1.ChangeRenewalSettingsRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1478}
  /// [google.cloud.channel.v1.Entitlement]:
  /// @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L34}
  ///
  future<StatusOr<google::cloud::channel::v1::Entitlement>>
  ChangeRenewalSettings(
      google::cloud::channel::v1::ChangeRenewalSettingsRequest const& request,
      Options options = {});

  ///
  /// Updates the Offer for an existing customer entitlement.
  ///
  /// An entitlement update is a long-running operation and it updates the
  /// entitlement as a result of fulfillment.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: Offer or Entitlement resource not found.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata will contain an
  /// instance of
  /// [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::ChangeOfferRequest,google/cloud/channel/v1/service.proto#L1502}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Entitlement,google/cloud/channel/v1/entitlements.proto#L34}
  ///
  /// [google.cloud.channel.v1.ChangeOfferRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1502}
  /// [google.cloud.channel.v1.Entitlement]:
  /// @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L34}
  ///
  future<StatusOr<google::cloud::channel::v1::Entitlement>> ChangeOffer(
      google::cloud::channel::v1::ChangeOfferRequest const& request,
      Options options = {});

  ///
  /// Starts paid service for a trial entitlement.
  ///
  /// Starts paid service for a trial entitlement immediately. This method is
  /// only applicable if a plan is set up for a trial entitlement but has some
  /// trial days remaining.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: Entitlement resource not found.
  /// * FAILED_PRECONDITION/NOT_IN_TRIAL: This method only works for
  /// entitlement on trial plans.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata will contain an
  /// instance of
  /// [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::StartPaidServiceRequest,google/cloud/channel/v1/service.proto#L1539}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Entitlement,google/cloud/channel/v1/entitlements.proto#L34}
  ///
  /// [google.cloud.channel.v1.StartPaidServiceRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1539}
  /// [google.cloud.channel.v1.Entitlement]:
  /// @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L34}
  ///
  future<StatusOr<google::cloud::channel::v1::Entitlement>> StartPaidService(
      google::cloud::channel::v1::StartPaidServiceRequest const& request,
      Options options = {});

  ///
  /// Suspends a previously fulfilled entitlement.
  ///
  /// An entitlement suspension is a long-running operation.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: Entitlement resource not found.
  /// * NOT_ACTIVE: Entitlement is not active.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata will contain an
  /// instance of
  /// [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::SuspendEntitlementRequest,google/cloud/channel/v1/service.proto#L1581}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Entitlement,google/cloud/channel/v1/entitlements.proto#L34}
  ///
  /// [google.cloud.channel.v1.SuspendEntitlementRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1581}
  /// [google.cloud.channel.v1.Entitlement]:
  /// @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L34}
  ///
  future<StatusOr<google::cloud::channel::v1::Entitlement>> SuspendEntitlement(
      google::cloud::channel::v1::SuspendEntitlementRequest const& request,
      Options options = {});

  ///
  /// Cancels a previously fulfilled entitlement.
  ///
  /// An entitlement cancellation is a long-running operation.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * FAILED_PRECONDITION: There are Google Cloud projects linked to the
  /// Google Cloud entitlement's Cloud Billing subaccount.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: Entitlement resource not found.
  /// * DELETION_TYPE_NOT_ALLOWED: Cancel is only allowed for Google Workspace
  /// add-ons, or entitlements for Google Cloud's development platform.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The response will contain
  /// google.protobuf.Empty on success. The Operation metadata will contain an
  /// instance of
  /// [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::CancelEntitlementRequest,google/cloud/channel/v1/service.proto#L1560}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::OperationMetadata,google/cloud/channel/v1/operations.proto#L27}
  ///
  /// [google.cloud.channel.v1.CancelEntitlementRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1560}
  /// [google.cloud.channel.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/channel/v1/operations.proto#L27}
  ///
  future<StatusOr<google::cloud::channel::v1::OperationMetadata>>
  CancelEntitlement(
      google::cloud::channel::v1::CancelEntitlementRequest const& request,
      Options options = {});

  ///
  /// Activates a previously suspended entitlement. Entitlements suspended for
  /// pending ToS acceptance can't be activated using this method.
  ///
  /// An entitlement activation is a long-running operation and it updates
  /// the state of the customer entitlement.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: Entitlement resource not found.
  /// * SUSPENSION_NOT_RESELLER_INITIATED: Can only activate reseller-initiated
  /// suspensions and entitlements that have accepted the TOS.
  /// * NOT_SUSPENDED: Can only activate suspended entitlements not in an ACTIVE
  /// state.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata will contain an
  /// instance of
  /// [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::ActivateEntitlementRequest,google/cloud/channel/v1/service.proto#L1602}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Entitlement,google/cloud/channel/v1/entitlements.proto#L34}
  ///
  /// [google.cloud.channel.v1.ActivateEntitlementRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1602}
  /// [google.cloud.channel.v1.Entitlement]:
  /// @googleapis_reference_link{google/cloud/channel/v1/entitlements.proto#L34}
  ///
  future<StatusOr<google::cloud::channel::v1::Entitlement>> ActivateEntitlement(
      google::cloud::channel::v1::ActivateEntitlementRequest const& request,
      Options options = {});

  ///
  /// Transfers customer entitlements to new reseller.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: The customer or offer resource was not found.
  /// * ALREADY_EXISTS: The SKU was already transferred for the customer.
  /// * CONDITION_NOT_MET or FAILED_PRECONDITION:
  ///     * The SKU requires domain verification to transfer, but the domain is
  ///     not verified.
  ///     * An Add-On SKU (example, Vault or Drive) is missing the
  ///     pre-requisite SKU (example, G Suite Basic).
  ///     * (Developer accounts only) Reseller and resold domain must meet the
  ///     following naming requirements:
  ///         * Domain names must start with goog-test.
  ///         * Domain names must include the reseller domain.
  ///     * Specify all transferring entitlements.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The Operation metadata will contain an
  /// instance of
  /// [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::TransferEntitlementsRequest,google/cloud/channel/v1/service.proto#L1387}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::TransferEntitlementsResponse,google/cloud/channel/v1/service.proto#L1418}
  ///
  /// [google.cloud.channel.v1.TransferEntitlementsRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1387}
  /// [google.cloud.channel.v1.TransferEntitlementsResponse]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1418}
  ///
  future<StatusOr<google::cloud::channel::v1::TransferEntitlementsResponse>>
  TransferEntitlements(
      google::cloud::channel::v1::TransferEntitlementsRequest const& request,
      Options options = {});

  ///
  /// Transfers customer entitlements from their current reseller to Google.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: The customer or offer resource was not found.
  /// * ALREADY_EXISTS: The SKU was already transferred for the customer.
  /// * CONDITION_NOT_MET or FAILED_PRECONDITION:
  ///     * The SKU requires domain verification to transfer, but the domain is
  ///     not verified.
  ///     * An Add-On SKU (example, Vault or Drive) is missing the
  ///     pre-requisite SKU (example, G Suite Basic).
  ///     * (Developer accounts only) Reseller and resold domain must meet the
  ///     following naming requirements:
  ///         * Domain names must start with goog-test.
  ///         * Domain names must include the reseller domain.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The ID of a long-running operation.
  ///
  /// To get the results of the operation, call the GetOperation method of
  /// CloudChannelOperationsService. The response will contain
  /// google.protobuf.Empty on success. The Operation metadata will contain an
  /// instance of
  /// [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::TransferEntitlementsToGoogleRequest,google/cloud/channel/v1/service.proto#L1424}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::OperationMetadata,google/cloud/channel/v1/operations.proto#L27}
  ///
  /// [google.cloud.channel.v1.TransferEntitlementsToGoogleRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1424}
  /// [google.cloud.channel.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/channel/v1/operations.proto#L27}
  ///
  future<StatusOr<google::cloud::channel::v1::OperationMetadata>>
  TransferEntitlementsToGoogle(
      google::cloud::channel::v1::TransferEntitlementsToGoogleRequest const&
          request,
      Options options = {});

  ///
  /// List [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]s
  /// belonging to a distributor. You must be a distributor to call this method.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// Return value:
  /// The list of the distributor account's
  /// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
  /// resources.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::ListChannelPartnerLinksRequest,google/cloud/channel/v1/service.proto#L1285}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::ChannelPartnerLink,google/cloud/channel/v1/channel_partner_links.proto#L65}
  ///
  /// [google.cloud.channel.v1.ListChannelPartnerLinksRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1285}
  /// [google.cloud.channel.v1.ChannelPartnerLink]:
  /// @googleapis_reference_link{google/cloud/channel/v1/channel_partner_links.proto#L65}
  ///
  StreamRange<google::cloud::channel::v1::ChannelPartnerLink>
  ListChannelPartnerLinks(
      google::cloud::channel::v1::ListChannelPartnerLinksRequest request,
      Options options = {});

  ///
  /// Returns the requested
  /// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
  /// You must be a distributor to call this method.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: ChannelPartnerLink resource not found because of an
  /// invalid channel partner link name.
  ///
  /// Return value:
  /// The [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
  /// resource.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::GetChannelPartnerLinkRequest,google/cloud/channel/v1/service.proto#L1317}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::ChannelPartnerLink,google/cloud/channel/v1/channel_partner_links.proto#L65}
  ///
  /// [google.cloud.channel.v1.GetChannelPartnerLinkRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1317}
  /// [google.cloud.channel.v1.ChannelPartnerLink]:
  /// @googleapis_reference_link{google/cloud/channel/v1/channel_partner_links.proto#L65}
  ///
  StatusOr<google::cloud::channel::v1::ChannelPartnerLink>
  GetChannelPartnerLink(
      google::cloud::channel::v1::GetChannelPartnerLinkRequest const& request,
      Options options = {});

  ///
  /// Initiates a channel partner link between a distributor and a reseller, or
  /// between resellers in an n-tier reseller channel.
  /// Invited partners need to follow the invite_link_uri provided in the
  /// response to accept. After accepting the invitation, a link is set up
  /// between the two parties.
  /// You must be a distributor to call this method.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * ALREADY_EXISTS: The ChannelPartnerLink sent in the request already
  /// exists.
  /// * NOT_FOUND: No Cloud Identity customer exists for provided domain.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The new [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
  /// resource.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::CreateChannelPartnerLinkRequest,google/cloud/channel/v1/service.proto#L1328}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::ChannelPartnerLink,google/cloud/channel/v1/channel_partner_links.proto#L65}
  ///
  /// [google.cloud.channel.v1.CreateChannelPartnerLinkRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1328}
  /// [google.cloud.channel.v1.ChannelPartnerLink]:
  /// @googleapis_reference_link{google/cloud/channel/v1/channel_partner_links.proto#L65}
  ///
  StatusOr<google::cloud::channel::v1::ChannelPartnerLink>
  CreateChannelPartnerLink(
      google::cloud::channel::v1::CreateChannelPartnerLinkRequest const&
          request,
      Options options = {});

  ///
  /// Updates a channel partner link. Distributors call this method to change a
  /// link's status. For example, to suspend a partner link.
  /// You must be a distributor to call this method.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request is different
  /// from the reseller account in the API request.
  /// * INVALID_ARGUMENT:
  ///     * Required request parameters are missing or invalid.
  ///     * Link state cannot change from invited to active or suspended.
  ///     * Cannot send reseller_cloud_identity_id, invite_url, or name in
  ///     update mask.
  /// * NOT_FOUND: ChannelPartnerLink resource not found.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The updated
  /// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::UpdateChannelPartnerLinkRequest,google/cloud/channel/v1/service.proto#L1341}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::ChannelPartnerLink,google/cloud/channel/v1/channel_partner_links.proto#L65}
  ///
  /// [google.cloud.channel.v1.UpdateChannelPartnerLinkRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1341}
  /// [google.cloud.channel.v1.ChannelPartnerLink]:
  /// @googleapis_reference_link{google/cloud/channel/v1/channel_partner_links.proto#L65}
  ///
  StatusOr<google::cloud::channel::v1::ChannelPartnerLink>
  UpdateChannelPartnerLink(
      google::cloud::channel::v1::UpdateChannelPartnerLinkRequest const&
          request,
      Options options = {});

  ///
  /// Returns the requested [Offer][google.cloud.channel.v1.Offer] resource.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The entitlement doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: Entitlement or offer was not found.
  ///
  /// Return value:
  /// The [Offer][google.cloud.channel.v1.Offer] resource.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::LookupOfferRequest,google/cloud/channel/v1/service.proto#L1623}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Offer,google/cloud/channel/v1/offers.proto#L131}
  ///
  /// [google.cloud.channel.v1.LookupOfferRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1623}
  /// [google.cloud.channel.v1.Offer]:
  /// @googleapis_reference_link{google/cloud/channel/v1/offers.proto#L131}
  ///
  StatusOr<google::cloud::channel::v1::Offer> LookupOffer(
      google::cloud::channel::v1::LookupOfferRequest const& request,
      Options options = {});

  ///
  /// Lists the Products the reseller is authorized to sell.
  ///
  /// Possible error codes:
  ///
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::ListProductsRequest,google/cloud/channel/v1/service.proto#L1636}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Product,google/cloud/channel/v1/products.proto#L38}
  ///
  /// [google.cloud.channel.v1.ListProductsRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1636}
  /// [google.cloud.channel.v1.Product]:
  /// @googleapis_reference_link{google/cloud/channel/v1/products.proto#L38}
  ///
  StreamRange<google::cloud::channel::v1::Product> ListProducts(
      google::cloud::channel::v1::ListProductsRequest request,
      Options options = {});

  ///
  /// Lists the SKUs for a product the reseller is authorized to sell.
  ///
  /// Possible error codes:
  ///
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::ListSkusRequest,google/cloud/channel/v1/service.proto#L1665}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Sku,google/cloud/channel/v1/products.proto#L56}
  ///
  /// [google.cloud.channel.v1.ListSkusRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1665}
  /// [google.cloud.channel.v1.Sku]:
  /// @googleapis_reference_link{google/cloud/channel/v1/products.proto#L56}
  ///
  StreamRange<google::cloud::channel::v1::Sku> ListSkus(
      google::cloud::channel::v1::ListSkusRequest request,
      Options options = {});

  ///
  /// Lists the Offers the reseller can sell.
  ///
  /// Possible error codes:
  ///
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::ListOffersRequest,google/cloud/channel/v1/service.proto#L1705}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::Offer,google/cloud/channel/v1/offers.proto#L131}
  ///
  /// [google.cloud.channel.v1.ListOffersRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1705}
  /// [google.cloud.channel.v1.Offer]:
  /// @googleapis_reference_link{google/cloud/channel/v1/offers.proto#L131}
  ///
  StreamRange<google::cloud::channel::v1::Offer> ListOffers(
      google::cloud::channel::v1::ListOffersRequest request,
      Options options = {});

  ///
  /// Lists the following:
  ///
  /// * SKUs that you can purchase for a customer
  /// * SKUs that you can upgrade or downgrade for an entitlement.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::ListPurchasableSkusRequest,google/cloud/channel/v1/service.proto#L1741}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::PurchasableSku,google/cloud/channel/v1/service.proto#L1818}
  ///
  /// [google.cloud.channel.v1.ListPurchasableSkusRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1741}
  /// [google.cloud.channel.v1.PurchasableSku]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1818}
  ///
  StreamRange<google::cloud::channel::v1::PurchasableSku> ListPurchasableSkus(
      google::cloud::channel::v1::ListPurchasableSkusRequest request,
      Options options = {});

  ///
  /// Lists the following:
  ///
  /// * Offers that you can purchase for a customer.
  /// * Offers that you can change for an entitlement.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The customer doesn't belong to the reseller
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::ListPurchasableOffersRequest,google/cloud/channel/v1/service.proto#L1824}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::PurchasableOffer,google/cloud/channel/v1/service.proto#L1888}
  ///
  /// [google.cloud.channel.v1.ListPurchasableOffersRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1824}
  /// [google.cloud.channel.v1.PurchasableOffer]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1888}
  ///
  StreamRange<google::cloud::channel::v1::PurchasableOffer>
  ListPurchasableOffers(
      google::cloud::channel::v1::ListPurchasableOffersRequest request,
      Options options = {});

  ///
  /// Registers a service account with subscriber privileges on the Cloud
  /// Pub/Sub topic for this Channel Services account. After you create a
  /// subscriber, you get the events through
  /// [SubscriberEvent][google.cloud.channel.v1.SubscriberEvent]
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request and the
  /// provided reseller account are different, or the impersonated user
  /// is not a super admin.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The topic name with the registered service email address.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::RegisterSubscriberRequest,google/cloud/channel/v1/service.proto#L1894}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::RegisterSubscriberResponse,google/cloud/channel/v1/service.proto#L1903}
  ///
  /// [google.cloud.channel.v1.RegisterSubscriberRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1894}
  /// [google.cloud.channel.v1.RegisterSubscriberResponse]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1903}
  ///
  StatusOr<google::cloud::channel::v1::RegisterSubscriberResponse>
  RegisterSubscriber(
      google::cloud::channel::v1::RegisterSubscriberRequest const& request,
      Options options = {});

  ///
  /// Unregisters a service account with subscriber privileges on the Cloud
  /// Pub/Sub topic created for this Channel Services account. If there are no
  /// service accounts left with subscriber privileges, this deletes the topic.
  /// You can call ListSubscribers to check for these accounts.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request and the
  /// provided reseller account are different, or the impersonated user
  /// is not a super admin.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: The topic resource doesn't exist.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// The topic name that unregistered the service email address.
  /// Returns a success response if the service email address wasn't registered
  /// with the topic.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::UnregisterSubscriberRequest,google/cloud/channel/v1/service.proto#L1909}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::channel::v1::UnregisterSubscriberResponse,google/cloud/channel/v1/service.proto#L1918}
  ///
  /// [google.cloud.channel.v1.UnregisterSubscriberRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1909}
  /// [google.cloud.channel.v1.UnregisterSubscriberResponse]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1918}
  ///
  StatusOr<google::cloud::channel::v1::UnregisterSubscriberResponse>
  UnregisterSubscriber(
      google::cloud::channel::v1::UnregisterSubscriberRequest const& request,
      Options options = {});

  ///
  /// Lists service accounts with subscriber privileges on the Cloud Pub/Sub
  /// topic created for this Channel Services account.
  ///
  /// Possible error codes:
  ///
  /// * PERMISSION_DENIED: The reseller account making the request and the
  /// provided reseller account are different, or the impersonated user
  /// is not a super admin.
  /// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
  /// * NOT_FOUND: The topic resource doesn't exist.
  /// * INTERNAL: Any non-user error related to a technical issue in the
  /// backend. Contact Cloud Channel support.
  /// * UNKNOWN: Any non-user error related to a technical issue in the backend.
  /// Contact Cloud Channel support.
  ///
  /// Return value:
  /// A list of service email addresses.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::channel::v1::ListSubscribersRequest,google/cloud/channel/v1/service.proto#L1924}
  /// @param options  Optional. Operation options.
  /// @return std::string
  ///
  /// [google.cloud.channel.v1.ListSubscribersRequest]:
  /// @googleapis_reference_link{google/cloud/channel/v1/service.proto#L1924}
  ///
  StreamRange<std::string> ListSubscribers(
      google::cloud::channel::v1::ListSubscribersRequest request,
      Options options = {});

 private:
  std::shared_ptr<CloudChannelServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace channel
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CHANNEL_CLOUD_CHANNEL_CLIENT_H
