// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/binaryauthorization/v1/service.proto

#include "google/cloud/binaryauthorization/system_policy_v1_client.h"
#include "google/cloud/binaryauthorization/internal/system_policy_v1_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace binaryauthorization {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SystemPolicyV1Client::SystemPolicyV1Client(
    std::shared_ptr<SystemPolicyV1Connection> connection, Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options),
          binaryauthorization_internal::SystemPolicyV1DefaultOptions(
              connection_->options()))) {}
SystemPolicyV1Client::~SystemPolicyV1Client() = default;

StatusOr<google::cloud::binaryauthorization::v1::Policy>
SystemPolicyV1Client::GetSystemPolicy(std::string const& name,
                                      Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::binaryauthorization::v1::GetSystemPolicyRequest request;
  request.set_name(name);
  return connection_->GetSystemPolicy(request);
}

StatusOr<google::cloud::binaryauthorization::v1::Policy>
SystemPolicyV1Client::GetSystemPolicy(
    google::cloud::binaryauthorization::v1::GetSystemPolicyRequest const&
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetSystemPolicy(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace binaryauthorization
}  // namespace cloud
}  // namespace google
