// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/binaryauthorization/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BINARYAUTHORIZATION_INTERNAL_BINAUTHZ_MANAGEMENT_SERVICE_V1_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BINARYAUTHORIZATION_INTERNAL_BINAUTHZ_MANAGEMENT_SERVICE_V1_CONNECTION_IMPL_H

#include "google/cloud/binaryauthorization/binauthz_management_service_v1_connection.h"
#include "google/cloud/binaryauthorization/binauthz_management_service_v1_connection_idempotency_policy.h"
#include "google/cloud/binaryauthorization/binauthz_management_service_v1_options.h"
#include "google/cloud/binaryauthorization/internal/binauthz_management_service_v1_retry_traits.h"
#include "google/cloud/binaryauthorization/internal/binauthz_management_service_v1_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace binaryauthorization_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class BinauthzManagementServiceV1ConnectionImpl
    : public binaryauthorization::BinauthzManagementServiceV1Connection {
 public:
  ~BinauthzManagementServiceV1ConnectionImpl() override = default;

  BinauthzManagementServiceV1ConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<
          binaryauthorization_internal::BinauthzManagementServiceV1Stub>
          stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::cloud::binaryauthorization::v1::Policy> GetPolicy(
      google::cloud::binaryauthorization::v1::GetPolicyRequest const& request)
      override;

  StatusOr<google::cloud::binaryauthorization::v1::Policy> UpdatePolicy(
      google::cloud::binaryauthorization::v1::UpdatePolicyRequest const&
          request) override;

  StatusOr<google::cloud::binaryauthorization::v1::Attestor> CreateAttestor(
      google::cloud::binaryauthorization::v1::CreateAttestorRequest const&
          request) override;

  StatusOr<google::cloud::binaryauthorization::v1::Attestor> GetAttestor(
      google::cloud::binaryauthorization::v1::GetAttestorRequest const& request)
      override;

  StatusOr<google::cloud::binaryauthorization::v1::Attestor> UpdateAttestor(
      google::cloud::binaryauthorization::v1::UpdateAttestorRequest const&
          request) override;

  StreamRange<google::cloud::binaryauthorization::v1::Attestor> ListAttestors(
      google::cloud::binaryauthorization::v1::ListAttestorsRequest request)
      override;

  Status DeleteAttestor(
      google::cloud::binaryauthorization::v1::DeleteAttestorRequest const&
          request) override;

 private:
  std::unique_ptr<binaryauthorization::BinauthzManagementServiceV1RetryPolicy>
  retry_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<binaryauthorization::
                        BinauthzManagementServiceV1RetryPolicyOption>()) {
      return options
          .get<binaryauthorization::
                   BinauthzManagementServiceV1RetryPolicyOption>()
          ->clone();
    }
    return options_
        .get<
            binaryauthorization::BinauthzManagementServiceV1RetryPolicyOption>()
        ->clone();
  }

  std::unique_ptr<BackoffPolicy> backoff_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<binaryauthorization::
                        BinauthzManagementServiceV1BackoffPolicyOption>()) {
      return options
          .get<binaryauthorization::
                   BinauthzManagementServiceV1BackoffPolicyOption>()
          ->clone();
    }
    return options_
        .get<binaryauthorization::
                 BinauthzManagementServiceV1BackoffPolicyOption>()
        ->clone();
  }

  std::unique_ptr<binaryauthorization::
                      BinauthzManagementServiceV1ConnectionIdempotencyPolicy>
  idempotency_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<
            binaryauthorization::
                BinauthzManagementServiceV1ConnectionIdempotencyPolicyOption>()) {
      return options
          .get<
              binaryauthorization::
                  BinauthzManagementServiceV1ConnectionIdempotencyPolicyOption>()
          ->clone();
    }
    return options_
        .get<binaryauthorization::
                 BinauthzManagementServiceV1ConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<binaryauthorization_internal::BinauthzManagementServiceV1Stub>
      stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace binaryauthorization_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BINARYAUTHORIZATION_INTERNAL_BINAUTHZ_MANAGEMENT_SERVICE_V1_CONNECTION_IMPL_H
