// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/binaryauthorization/v1/service.proto

#include "google/cloud/binaryauthorization/binauthz_management_service_v1_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace binaryauthorization {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

BinauthzManagementServiceV1ConnectionIdempotencyPolicy::
    ~BinauthzManagementServiceV1ConnectionIdempotencyPolicy() = default;

namespace {
class DefaultBinauthzManagementServiceV1ConnectionIdempotencyPolicy
    : public BinauthzManagementServiceV1ConnectionIdempotencyPolicy {
 public:
  ~DefaultBinauthzManagementServiceV1ConnectionIdempotencyPolicy() override =
      default;

  /// Create a new copy of this object.
  std::unique_ptr<BinauthzManagementServiceV1ConnectionIdempotencyPolicy>
  clone() const override {
    return absl::make_unique<
        DefaultBinauthzManagementServiceV1ConnectionIdempotencyPolicy>(*this);
  }

  Idempotency GetPolicy(
      google::cloud::binaryauthorization::v1::GetPolicyRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdatePolicy(
      google::cloud::binaryauthorization::v1::UpdatePolicyRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateAttestor(
      google::cloud::binaryauthorization::v1::CreateAttestorRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetAttestor(
      google::cloud::binaryauthorization::v1::GetAttestorRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateAttestor(
      google::cloud::binaryauthorization::v1::UpdateAttestorRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListAttestors(
      google::cloud::binaryauthorization::v1::ListAttestorsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency DeleteAttestor(
      google::cloud::binaryauthorization::v1::DeleteAttestorRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<BinauthzManagementServiceV1ConnectionIdempotencyPolicy>
MakeDefaultBinauthzManagementServiceV1ConnectionIdempotencyPolicy() {
  return absl::make_unique<
      DefaultBinauthzManagementServiceV1ConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace binaryauthorization
}  // namespace cloud
}  // namespace google
