// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/binaryauthorization/v1/service.proto

#include "google/cloud/binaryauthorization/binauthz_management_service_v1_client.h"
#include "google/cloud/binaryauthorization/internal/binauthz_management_service_v1_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace binaryauthorization {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BinauthzManagementServiceV1Client::BinauthzManagementServiceV1Client(
    std::shared_ptr<BinauthzManagementServiceV1Connection> connection,
    Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options), binaryauthorization_internal::
                                  BinauthzManagementServiceV1DefaultOptions(
                                      connection_->options()))) {}
BinauthzManagementServiceV1Client::~BinauthzManagementServiceV1Client() =
    default;

StatusOr<google::cloud::binaryauthorization::v1::Policy>
BinauthzManagementServiceV1Client::GetPolicy(std::string const& name,
                                             Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::binaryauthorization::v1::GetPolicyRequest request;
  request.set_name(name);
  return connection_->GetPolicy(request);
}

StatusOr<google::cloud::binaryauthorization::v1::Policy>
BinauthzManagementServiceV1Client::GetPolicy(
    google::cloud::binaryauthorization::v1::GetPolicyRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetPolicy(request);
}

StatusOr<google::cloud::binaryauthorization::v1::Policy>
BinauthzManagementServiceV1Client::UpdatePolicy(
    google::cloud::binaryauthorization::v1::Policy const& policy,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::binaryauthorization::v1::UpdatePolicyRequest request;
  *request.mutable_policy() = policy;
  return connection_->UpdatePolicy(request);
}

StatusOr<google::cloud::binaryauthorization::v1::Policy>
BinauthzManagementServiceV1Client::UpdatePolicy(
    google::cloud::binaryauthorization::v1::UpdatePolicyRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdatePolicy(request);
}

StatusOr<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1Client::CreateAttestor(
    std::string const& parent, std::string const& attestor_id,
    google::cloud::binaryauthorization::v1::Attestor const& attestor,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::binaryauthorization::v1::CreateAttestorRequest request;
  request.set_parent(parent);
  request.set_attestor_id(attestor_id);
  *request.mutable_attestor() = attestor;
  return connection_->CreateAttestor(request);
}

StatusOr<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1Client::CreateAttestor(
    google::cloud::binaryauthorization::v1::CreateAttestorRequest const&
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateAttestor(request);
}

StatusOr<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1Client::GetAttestor(std::string const& name,
                                               Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::binaryauthorization::v1::GetAttestorRequest request;
  request.set_name(name);
  return connection_->GetAttestor(request);
}

StatusOr<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1Client::GetAttestor(
    google::cloud::binaryauthorization::v1::GetAttestorRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetAttestor(request);
}

StatusOr<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1Client::UpdateAttestor(
    google::cloud::binaryauthorization::v1::Attestor const& attestor,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::binaryauthorization::v1::UpdateAttestorRequest request;
  *request.mutable_attestor() = attestor;
  return connection_->UpdateAttestor(request);
}

StatusOr<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1Client::UpdateAttestor(
    google::cloud::binaryauthorization::v1::UpdateAttestorRequest const&
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateAttestor(request);
}

StreamRange<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1Client::ListAttestors(std::string const& parent,
                                                 Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::binaryauthorization::v1::ListAttestorsRequest request;
  request.set_parent(parent);
  return connection_->ListAttestors(request);
}

StreamRange<google::cloud::binaryauthorization::v1::Attestor>
BinauthzManagementServiceV1Client::ListAttestors(
    google::cloud::binaryauthorization::v1::ListAttestorsRequest request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListAttestors(std::move(request));
}

Status BinauthzManagementServiceV1Client::DeleteAttestor(
    std::string const& name, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::binaryauthorization::v1::DeleteAttestorRequest request;
  request.set_name(name);
  return connection_->DeleteAttestor(request);
}

Status BinauthzManagementServiceV1Client::DeleteAttestor(
    google::cloud::binaryauthorization::v1::DeleteAttestorRequest const&
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteAttestor(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace binaryauthorization
}  // namespace cloud
}  // namespace google
