// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/billing/v1/cloud_billing.proto

#include "google/cloud/billing/internal/cloud_billing_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/billing/v1/cloud_billing.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace billing_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudBillingLogging::CloudBillingLogging(
    std::shared_ptr<CloudBillingStub> child, TracingOptions tracing_options,
    std::set<std::string> components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      components_(std::move(components)) {}

StatusOr<google::cloud::billing::v1::BillingAccount>
CloudBillingLogging::GetBillingAccount(
    grpc::ClientContext& context,
    google::cloud::billing::v1::GetBillingAccountRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::billing::v1::GetBillingAccountRequest const& request) {
        return child_->GetBillingAccount(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::billing::v1::ListBillingAccountsResponse>
CloudBillingLogging::ListBillingAccounts(
    grpc::ClientContext& context,
    google::cloud::billing::v1::ListBillingAccountsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::billing::v1::ListBillingAccountsRequest const&
                 request) {
        return child_->ListBillingAccounts(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::billing::v1::BillingAccount>
CloudBillingLogging::UpdateBillingAccount(
    grpc::ClientContext& context,
    google::cloud::billing::v1::UpdateBillingAccountRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::billing::v1::UpdateBillingAccountRequest const&
                 request) {
        return child_->UpdateBillingAccount(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::billing::v1::BillingAccount>
CloudBillingLogging::CreateBillingAccount(
    grpc::ClientContext& context,
    google::cloud::billing::v1::CreateBillingAccountRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::billing::v1::CreateBillingAccountRequest const&
                 request) {
        return child_->CreateBillingAccount(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::billing::v1::ListProjectBillingInfoResponse>
CloudBillingLogging::ListProjectBillingInfo(
    grpc::ClientContext& context,
    google::cloud::billing::v1::ListProjectBillingInfoRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::billing::v1::ListProjectBillingInfoRequest const&
                 request) {
        return child_->ListProjectBillingInfo(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::billing::v1::ProjectBillingInfo>
CloudBillingLogging::GetProjectBillingInfo(
    grpc::ClientContext& context,
    google::cloud::billing::v1::GetProjectBillingInfoRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::billing::v1::GetProjectBillingInfoRequest const&
                 request) {
        return child_->GetProjectBillingInfo(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::billing::v1::ProjectBillingInfo>
CloudBillingLogging::UpdateProjectBillingInfo(
    grpc::ClientContext& context,
    google::cloud::billing::v1::UpdateProjectBillingInfoRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::billing::v1::UpdateProjectBillingInfoRequest const&
                 request) {
        return child_->UpdateProjectBillingInfo(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> CloudBillingLogging::GetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::GetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return child_->GetIamPolicy(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> CloudBillingLogging::SetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::SetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return child_->SetIamPolicy(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
CloudBillingLogging::TestIamPermissions(
    grpc::ClientContext& context,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return child_->TestIamPermissions(context, request);
      },
      context, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace billing_internal
}  // namespace cloud
}  // namespace google
