// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/billing/budgets/v1/budget_service.proto

#include "google/cloud/billing/internal/budget_connection_impl.h"
#include "google/cloud/billing/internal/budget_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace billing_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BudgetServiceConnectionImpl::BudgetServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<billing_internal::BudgetServiceStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), billing_internal::BudgetServiceDefaultOptions(
                                  BudgetServiceConnection::options()))) {}

StatusOr<google::cloud::billing::budgets::v1::Budget>
BudgetServiceConnectionImpl::CreateBudget(
    google::cloud::billing::budgets::v1::CreateBudgetRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateBudget(request),
      [this](grpc::ClientContext& context,
             google::cloud::billing::budgets::v1::CreateBudgetRequest const&
                 request) { return stub_->CreateBudget(context, request); },
      request, __func__);
}

StatusOr<google::cloud::billing::budgets::v1::Budget>
BudgetServiceConnectionImpl::UpdateBudget(
    google::cloud::billing::budgets::v1::UpdateBudgetRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateBudget(request),
      [this](grpc::ClientContext& context,
             google::cloud::billing::budgets::v1::UpdateBudgetRequest const&
                 request) { return stub_->UpdateBudget(context, request); },
      request, __func__);
}

StatusOr<google::cloud::billing::budgets::v1::Budget>
BudgetServiceConnectionImpl::GetBudget(
    google::cloud::billing::budgets::v1::GetBudgetRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetBudget(request),
      [this](grpc::ClientContext& context,
             google::cloud::billing::budgets::v1::GetBudgetRequest const&
                 request) { return stub_->GetBudget(context, request); },
      request, __func__);
}

StreamRange<google::cloud::billing::budgets::v1::Budget>
BudgetServiceConnectionImpl::ListBudgets(
    google::cloud::billing::budgets::v1::ListBudgetsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<billing::BudgetServiceRetryPolicy const>(retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListBudgets(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::billing::budgets::v1::Budget>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::billing::budgets::v1::ListBudgetsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::billing::budgets::v1::ListBudgetsRequest const&
                    request) { return stub->ListBudgets(context, request); },
            r, function_name);
      },
      [](google::cloud::billing::budgets::v1::ListBudgetsResponse r) {
        std::vector<google::cloud::billing::budgets::v1::Budget> result(
            r.budgets().size());
        auto& messages = *r.mutable_budgets();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status BudgetServiceConnectionImpl::DeleteBudget(
    google::cloud::billing::budgets::v1::DeleteBudgetRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteBudget(request),
      [this](grpc::ClientContext& context,
             google::cloud::billing::budgets::v1::DeleteBudgetRequest const&
                 request) { return stub_->DeleteBudget(context, request); },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace billing_internal
}  // namespace cloud
}  // namespace google
