// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/billing/v1/cloud_catalog.proto

#include "google/cloud/billing/cloud_catalog_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace billing {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

CloudCatalogConnectionIdempotencyPolicy::
    ~CloudCatalogConnectionIdempotencyPolicy() = default;

namespace {
class DefaultCloudCatalogConnectionIdempotencyPolicy
    : public CloudCatalogConnectionIdempotencyPolicy {
 public:
  ~DefaultCloudCatalogConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<CloudCatalogConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultCloudCatalogConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ListServices(
      google::cloud::billing::v1::ListServicesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListSkus(google::cloud::billing::v1::ListSkusRequest) override {
    return Idempotency::kIdempotent;
  }
};
}  // namespace

std::unique_ptr<CloudCatalogConnectionIdempotencyPolicy>
MakeDefaultCloudCatalogConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultCloudCatalogConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace billing
}  // namespace cloud
}  // namespace google
