// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/billing/budgets/v1/budget_service.proto

#include "google/cloud/billing/budget_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace billing {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

BudgetServiceConnectionIdempotencyPolicy::
    ~BudgetServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultBudgetServiceConnectionIdempotencyPolicy
    : public BudgetServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultBudgetServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<BudgetServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultBudgetServiceConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency CreateBudget(
      google::cloud::billing::budgets::v1::CreateBudgetRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateBudget(
      google::cloud::billing::budgets::v1::UpdateBudgetRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetBudget(
      google::cloud::billing::budgets::v1::GetBudgetRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListBudgets(
      google::cloud::billing::budgets::v1::ListBudgetsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency DeleteBudget(
      google::cloud::billing::budgets::v1::DeleteBudgetRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<BudgetServiceConnectionIdempotencyPolicy>
MakeDefaultBudgetServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultBudgetServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace billing
}  // namespace cloud
}  // namespace google
