// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/bigtable/admin/v2/bigtable_table_admin.proto

#include "google/cloud/bigtable/admin/internal/bigtable_table_admin_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/bigtable/admin/v2/bigtable_table_admin.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace bigtable_admin_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BigtableTableAdminStub::~BigtableTableAdminStub() = default;

StatusOr<google::bigtable::admin::v2::Table>
DefaultBigtableTableAdminStub::CreateTable(
    grpc::ClientContext& client_context,
    google::bigtable::admin::v2::CreateTableRequest const& request) {
  google::bigtable::admin::v2::Table response;
  auto status = grpc_stub_->CreateTable(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::bigtable::admin::v2::ListTablesResponse>
DefaultBigtableTableAdminStub::ListTables(
    grpc::ClientContext& client_context,
    google::bigtable::admin::v2::ListTablesRequest const& request) {
  google::bigtable::admin::v2::ListTablesResponse response;
  auto status = grpc_stub_->ListTables(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::bigtable::admin::v2::Table>
DefaultBigtableTableAdminStub::GetTable(
    grpc::ClientContext& client_context,
    google::bigtable::admin::v2::GetTableRequest const& request) {
  google::bigtable::admin::v2::Table response;
  auto status = grpc_stub_->GetTable(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultBigtableTableAdminStub::DeleteTable(
    grpc::ClientContext& client_context,
    google::bigtable::admin::v2::DeleteTableRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteTable(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::bigtable::admin::v2::Table>
DefaultBigtableTableAdminStub::ModifyColumnFamilies(
    grpc::ClientContext& client_context,
    google::bigtable::admin::v2::ModifyColumnFamiliesRequest const& request) {
  google::bigtable::admin::v2::Table response;
  auto status =
      grpc_stub_->ModifyColumnFamilies(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultBigtableTableAdminStub::DropRowRange(
    grpc::ClientContext& client_context,
    google::bigtable::admin::v2::DropRowRangeRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DropRowRange(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::bigtable::admin::v2::GenerateConsistencyTokenResponse>
DefaultBigtableTableAdminStub::GenerateConsistencyToken(
    grpc::ClientContext& client_context,
    google::bigtable::admin::v2::GenerateConsistencyTokenRequest const&
        request) {
  google::bigtable::admin::v2::GenerateConsistencyTokenResponse response;
  auto status =
      grpc_stub_->GenerateConsistencyToken(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::bigtable::admin::v2::CheckConsistencyResponse>
DefaultBigtableTableAdminStub::CheckConsistency(
    grpc::ClientContext& client_context,
    google::bigtable::admin::v2::CheckConsistencyRequest const& request) {
  google::bigtable::admin::v2::CheckConsistencyResponse response;
  auto status =
      grpc_stub_->CheckConsistency(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultBigtableTableAdminStub::AsyncCreateBackup(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::bigtable::admin::v2::CreateBackupRequest const& request) {
  return cq.MakeUnaryRpc(
      [this](grpc::ClientContext* context,
             google::bigtable::admin::v2::CreateBackupRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateBackup(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::bigtable::admin::v2::Backup>
DefaultBigtableTableAdminStub::GetBackup(
    grpc::ClientContext& client_context,
    google::bigtable::admin::v2::GetBackupRequest const& request) {
  google::bigtable::admin::v2::Backup response;
  auto status = grpc_stub_->GetBackup(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::bigtable::admin::v2::Backup>
DefaultBigtableTableAdminStub::UpdateBackup(
    grpc::ClientContext& client_context,
    google::bigtable::admin::v2::UpdateBackupRequest const& request) {
  google::bigtable::admin::v2::Backup response;
  auto status = grpc_stub_->UpdateBackup(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultBigtableTableAdminStub::DeleteBackup(
    grpc::ClientContext& client_context,
    google::bigtable::admin::v2::DeleteBackupRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteBackup(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::bigtable::admin::v2::ListBackupsResponse>
DefaultBigtableTableAdminStub::ListBackups(
    grpc::ClientContext& client_context,
    google::bigtable::admin::v2::ListBackupsRequest const& request) {
  google::bigtable::admin::v2::ListBackupsResponse response;
  auto status = grpc_stub_->ListBackups(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultBigtableTableAdminStub::AsyncRestoreTable(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::bigtable::admin::v2::RestoreTableRequest const& request) {
  return cq.MakeUnaryRpc(
      [this](grpc::ClientContext* context,
             google::bigtable::admin::v2::RestoreTableRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncRestoreTable(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::iam::v1::Policy> DefaultBigtableTableAdminStub::GetIamPolicy(
    grpc::ClientContext& client_context,
    google::iam::v1::GetIamPolicyRequest const& request) {
  google::iam::v1::Policy response;
  auto status = grpc_stub_->GetIamPolicy(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::iam::v1::Policy> DefaultBigtableTableAdminStub::SetIamPolicy(
    grpc::ClientContext& client_context,
    google::iam::v1::SetIamPolicyRequest const& request) {
  google::iam::v1::Policy response;
  auto status = grpc_stub_->SetIamPolicy(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DefaultBigtableTableAdminStub::TestIamPermissions(
    grpc::ClientContext& client_context,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  google::iam::v1::TestIamPermissionsResponse response;
  auto status =
      grpc_stub_->TestIamPermissions(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::bigtable::admin::v2::CheckConsistencyResponse>>
DefaultBigtableTableAdminStub::AsyncCheckConsistency(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::bigtable::admin::v2::CheckConsistencyRequest const& request) {
  return cq.MakeUnaryRpc(
      [this](
          grpc::ClientContext* context,
          google::bigtable::admin::v2::CheckConsistencyRequest const& request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCheckConsistency(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultBigtableTableAdminStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::GetOperationRequest const& request) {
  return cq.MakeUnaryRpc(
      [this](grpc::ClientContext* context,
             google::longrunning::GetOperationRequest const& request,
             grpc::CompletionQueue* cq) {
        return operations_->AsyncGetOperation(context, request, cq);
      },
      request, std::move(context));
}

future<Status> DefaultBigtableTableAdminStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::CancelOperationRequest const& request) {
  return cq
      .MakeUnaryRpc(
          [this](grpc::ClientContext* context,
                 google::longrunning::CancelOperationRequest const& request,
                 grpc::CompletionQueue* cq) {
            return operations_->AsyncCancelOperation(context, request, cq);
          },
          request, std::move(context))
      .then([](future<StatusOr<google::protobuf::Empty>> f) {
        return f.get().status();
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigtable_admin_internal
}  // namespace cloud
}  // namespace google
