// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/bigtable/admin/v2/bigtable_table_admin.proto

#include "google/cloud/bigtable/admin/bigtable_table_admin_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigtable_admin {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

BigtableTableAdminConnectionIdempotencyPolicy::
    ~BigtableTableAdminConnectionIdempotencyPolicy() = default;

namespace {
class DefaultBigtableTableAdminConnectionIdempotencyPolicy
    : public BigtableTableAdminConnectionIdempotencyPolicy {
 public:
  ~DefaultBigtableTableAdminConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<BigtableTableAdminConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<
        DefaultBigtableTableAdminConnectionIdempotencyPolicy>(*this);
  }

  Idempotency CreateTable(
      google::bigtable::admin::v2::CreateTableRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListTables(
      google::bigtable::admin::v2::ListTablesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetTable(
      google::bigtable::admin::v2::GetTableRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency DeleteTable(
      google::bigtable::admin::v2::DeleteTableRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ModifyColumnFamilies(
      google::bigtable::admin::v2::ModifyColumnFamiliesRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DropRowRange(
      google::bigtable::admin::v2::DropRowRangeRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GenerateConsistencyToken(
      google::bigtable::admin::v2::GenerateConsistencyTokenRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CheckConsistency(
      google::bigtable::admin::v2::CheckConsistencyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CreateBackup(
      google::bigtable::admin::v2::CreateBackupRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetBackup(
      google::bigtable::admin::v2::GetBackupRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateBackup(
      google::bigtable::admin::v2::UpdateBackupRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteBackup(
      google::bigtable::admin::v2::DeleteBackupRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListBackups(
      google::bigtable::admin::v2::ListBackupsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency RestoreTable(
      google::bigtable::admin::v2::RestoreTableRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<BigtableTableAdminConnectionIdempotencyPolicy>
MakeDefaultBigtableTableAdminConnectionIdempotencyPolicy() {
  return absl::make_unique<
      DefaultBigtableTableAdminConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigtable_admin
}  // namespace cloud
}  // namespace google
