// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/storage/v1/storage.proto

#include "google/cloud/bigquery/bigquery_read_client.h"
#include "google/cloud/bigquery/internal/bigquery_read_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BigQueryReadClient::BigQueryReadClient(
    std::shared_ptr<BigQueryReadConnection> connection, Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options), bigquery_internal::BigQueryReadDefaultOptions(
                                  connection_->options()))) {}
BigQueryReadClient::~BigQueryReadClient() = default;

StatusOr<google::cloud::bigquery::storage::v1::ReadSession>
BigQueryReadClient::CreateReadSession(
    std::string const& parent,
    google::cloud::bigquery::storage::v1::ReadSession const& read_session,
    std::int32_t max_stream_count, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::bigquery::storage::v1::CreateReadSessionRequest request;
  request.set_parent(parent);
  *request.mutable_read_session() = read_session;
  request.set_max_stream_count(max_stream_count);
  return connection_->CreateReadSession(request);
}

StatusOr<google::cloud::bigquery::storage::v1::ReadSession>
BigQueryReadClient::CreateReadSession(
    google::cloud::bigquery::storage::v1::CreateReadSessionRequest const&
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateReadSession(request);
}

StreamRange<google::cloud::bigquery::storage::v1::ReadRowsResponse>
BigQueryReadClient::ReadRows(std::string const& read_stream,
                             std::int64_t offset, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::bigquery::storage::v1::ReadRowsRequest request;
  request.set_read_stream(read_stream);
  request.set_offset(offset);
  return connection_->ReadRows(request);
}

StreamRange<google::cloud::bigquery::storage::v1::ReadRowsResponse>
BigQueryReadClient::ReadRows(
    google::cloud::bigquery::storage::v1::ReadRowsRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ReadRows(request);
}

StatusOr<google::cloud::bigquery::storage::v1::SplitReadStreamResponse>
BigQueryReadClient::SplitReadStream(
    google::cloud::bigquery::storage::v1::SplitReadStreamRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->SplitReadStream(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
namespace gcpcxxV1 = GOOGLE_CLOUD_CPP_NS;  // NOLINT(misc-unused-alias-decls)
}  // namespace bigquery
}  // namespace cloud
}  // namespace google
