// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/automl/v1/prediction_service.proto

#include "google/cloud/automl/prediction_connection.h"
#include "google/cloud/automl/internal/prediction_connection_impl.h"
#include "google/cloud/automl/internal/prediction_option_defaults.h"
#include "google/cloud/automl/internal/prediction_stub_factory.h"
#include "google/cloud/automl/prediction_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include <memory>

namespace google {
namespace cloud {
namespace automl {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PredictionServiceConnection::~PredictionServiceConnection() = default;

StatusOr<google::cloud::automl::v1::PredictResponse>
PredictionServiceConnection::Predict(
    google::cloud::automl::v1::PredictRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::automl::v1::BatchPredictResult>>
PredictionServiceConnection::BatchPredict(
    google::cloud::automl::v1::BatchPredictRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::automl::v1::BatchPredictResult>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<PredictionServiceConnection> MakePredictionServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 PredictionServicePolicyOptionList>(options,
                                                                    __func__);
  options =
      automl_internal::PredictionServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = automl_internal::CreateDefaultPredictionServiceStub(
      background->cq(), options);
  return std::make_shared<automl_internal::PredictionServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace automl
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace automl_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<automl::PredictionServiceConnection>
MakePredictionServiceConnection(std::shared_ptr<PredictionServiceStub> stub,
                                Options options) {
  options = PredictionServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<automl_internal::PredictionServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace automl_internal
}  // namespace cloud
}  // namespace google
