// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/automl/v1/service.proto

#include "google/cloud/automl/internal/auto_ml_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/automl/v1/service.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace automl_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AutoMlStub::~AutoMlStub() = default;

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncCreateDataset(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::automl::v1::CreateDatasetRequest const& request) {
  return cq.MakeUnaryRpc(
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::CreateDatasetRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateDataset(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::cloud::automl::v1::Dataset> DefaultAutoMlStub::GetDataset(
    grpc::ClientContext& client_context,
    google::cloud::automl::v1::GetDatasetRequest const& request) {
  google::cloud::automl::v1::Dataset response;
  auto status = grpc_stub_->GetDataset(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::automl::v1::ListDatasetsResponse>
DefaultAutoMlStub::ListDatasets(
    grpc::ClientContext& client_context,
    google::cloud::automl::v1::ListDatasetsRequest const& request) {
  google::cloud::automl::v1::ListDatasetsResponse response;
  auto status = grpc_stub_->ListDatasets(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::automl::v1::Dataset> DefaultAutoMlStub::UpdateDataset(
    grpc::ClientContext& client_context,
    google::cloud::automl::v1::UpdateDatasetRequest const& request) {
  google::cloud::automl::v1::Dataset response;
  auto status = grpc_stub_->UpdateDataset(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncDeleteDataset(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::automl::v1::DeleteDatasetRequest const& request) {
  return cq.MakeUnaryRpc(
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::DeleteDatasetRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteDataset(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncImportData(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::automl::v1::ImportDataRequest const& request) {
  return cq.MakeUnaryRpc(
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::ImportDataRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncImportData(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncExportData(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::automl::v1::ExportDataRequest const& request) {
  return cq.MakeUnaryRpc(
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::ExportDataRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncExportData(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::cloud::automl::v1::AnnotationSpec>
DefaultAutoMlStub::GetAnnotationSpec(
    grpc::ClientContext& client_context,
    google::cloud::automl::v1::GetAnnotationSpecRequest const& request) {
  google::cloud::automl::v1::AnnotationSpec response;
  auto status =
      grpc_stub_->GetAnnotationSpec(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncCreateModel(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::automl::v1::CreateModelRequest const& request) {
  return cq.MakeUnaryRpc(
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::CreateModelRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateModel(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::cloud::automl::v1::Model> DefaultAutoMlStub::GetModel(
    grpc::ClientContext& client_context,
    google::cloud::automl::v1::GetModelRequest const& request) {
  google::cloud::automl::v1::Model response;
  auto status = grpc_stub_->GetModel(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::automl::v1::ListModelsResponse>
DefaultAutoMlStub::ListModels(
    grpc::ClientContext& client_context,
    google::cloud::automl::v1::ListModelsRequest const& request) {
  google::cloud::automl::v1::ListModelsResponse response;
  auto status = grpc_stub_->ListModels(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncDeleteModel(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::automl::v1::DeleteModelRequest const& request) {
  return cq.MakeUnaryRpc(
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::DeleteModelRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteModel(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::cloud::automl::v1::Model> DefaultAutoMlStub::UpdateModel(
    grpc::ClientContext& client_context,
    google::cloud::automl::v1::UpdateModelRequest const& request) {
  google::cloud::automl::v1::Model response;
  auto status = grpc_stub_->UpdateModel(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncDeployModel(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::automl::v1::DeployModelRequest const& request) {
  return cq.MakeUnaryRpc(
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::DeployModelRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeployModel(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncUndeployModel(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::automl::v1::UndeployModelRequest const& request) {
  return cq.MakeUnaryRpc(
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::UndeployModelRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUndeployModel(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncExportModel(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::automl::v1::ExportModelRequest const& request) {
  return cq.MakeUnaryRpc(
      [this](grpc::ClientContext* context,
             google::cloud::automl::v1::ExportModelRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncExportModel(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::cloud::automl::v1::ModelEvaluation>
DefaultAutoMlStub::GetModelEvaluation(
    grpc::ClientContext& client_context,
    google::cloud::automl::v1::GetModelEvaluationRequest const& request) {
  google::cloud::automl::v1::ModelEvaluation response;
  auto status =
      grpc_stub_->GetModelEvaluation(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::automl::v1::ListModelEvaluationsResponse>
DefaultAutoMlStub::ListModelEvaluations(
    grpc::ClientContext& client_context,
    google::cloud::automl::v1::ListModelEvaluationsRequest const& request) {
  google::cloud::automl::v1::ListModelEvaluationsResponse response;
  auto status =
      grpc_stub_->ListModelEvaluations(&client_context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultAutoMlStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::GetOperationRequest const& request) {
  return cq.MakeUnaryRpc(
      [this](grpc::ClientContext* context,
             google::longrunning::GetOperationRequest const& request,
             grpc::CompletionQueue* cq) {
        return operations_->AsyncGetOperation(context, request, cq);
      },
      request, std::move(context));
}

future<Status> DefaultAutoMlStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::CancelOperationRequest const& request) {
  return cq
      .MakeUnaryRpc(
          [this](grpc::ClientContext* context,
                 google::longrunning::CancelOperationRequest const& request,
                 grpc::CompletionQueue* cq) {
            return operations_->AsyncCancelOperation(context, request, cq);
          },
          request, std::move(context))
      .then([](future<StatusOr<google::protobuf::Empty>> f) {
        return f.get().status();
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace automl_internal
}  // namespace cloud
}  // namespace google
