// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/automl/v1/service.proto

#include "google/cloud/automl/auto_ml_client.h"
#include "google/cloud/automl/internal/auto_ml_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace automl {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AutoMlClient::AutoMlClient(std::shared_ptr<AutoMlConnection> connection,
                           Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options),
          automl_internal::AutoMlDefaultOptions(connection_->options()))) {}
AutoMlClient::~AutoMlClient() = default;

future<StatusOr<google::cloud::automl::v1::Dataset>>
AutoMlClient::CreateDataset(std::string const& parent,
                            google::cloud::automl::v1::Dataset const& dataset,
                            Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::CreateDatasetRequest request;
  request.set_parent(parent);
  *request.mutable_dataset() = dataset;
  return connection_->CreateDataset(request);
}

future<StatusOr<google::cloud::automl::v1::Dataset>>
AutoMlClient::CreateDataset(
    google::cloud::automl::v1::CreateDatasetRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateDataset(request);
}

StatusOr<google::cloud::automl::v1::Dataset> AutoMlClient::GetDataset(
    std::string const& name, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::GetDatasetRequest request;
  request.set_name(name);
  return connection_->GetDataset(request);
}

StatusOr<google::cloud::automl::v1::Dataset> AutoMlClient::GetDataset(
    google::cloud::automl::v1::GetDatasetRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetDataset(request);
}

StreamRange<google::cloud::automl::v1::Dataset> AutoMlClient::ListDatasets(
    std::string const& parent, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::ListDatasetsRequest request;
  request.set_parent(parent);
  return connection_->ListDatasets(request);
}

StreamRange<google::cloud::automl::v1::Dataset> AutoMlClient::ListDatasets(
    google::cloud::automl::v1::ListDatasetsRequest request, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListDatasets(std::move(request));
}

StatusOr<google::cloud::automl::v1::Dataset> AutoMlClient::UpdateDataset(
    google::cloud::automl::v1::Dataset const& dataset,
    google::protobuf::FieldMask const& update_mask, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::UpdateDatasetRequest request;
  *request.mutable_dataset() = dataset;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDataset(request);
}

StatusOr<google::cloud::automl::v1::Dataset> AutoMlClient::UpdateDataset(
    google::cloud::automl::v1::UpdateDatasetRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateDataset(request);
}

future<StatusOr<google::cloud::automl::v1::OperationMetadata>>
AutoMlClient::DeleteDataset(std::string const& name, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::DeleteDatasetRequest request;
  request.set_name(name);
  return connection_->DeleteDataset(request);
}

future<StatusOr<google::cloud::automl::v1::OperationMetadata>>
AutoMlClient::DeleteDataset(
    google::cloud::automl::v1::DeleteDatasetRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteDataset(request);
}

future<StatusOr<google::cloud::automl::v1::OperationMetadata>>
AutoMlClient::ImportData(
    std::string const& name,
    google::cloud::automl::v1::InputConfig const& input_config,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::ImportDataRequest request;
  request.set_name(name);
  *request.mutable_input_config() = input_config;
  return connection_->ImportData(request);
}

future<StatusOr<google::cloud::automl::v1::OperationMetadata>>
AutoMlClient::ImportData(
    google::cloud::automl::v1::ImportDataRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ImportData(request);
}

future<StatusOr<google::cloud::automl::v1::OperationMetadata>>
AutoMlClient::ExportData(
    std::string const& name,
    google::cloud::automl::v1::OutputConfig const& output_config,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::ExportDataRequest request;
  request.set_name(name);
  *request.mutable_output_config() = output_config;
  return connection_->ExportData(request);
}

future<StatusOr<google::cloud::automl::v1::OperationMetadata>>
AutoMlClient::ExportData(
    google::cloud::automl::v1::ExportDataRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ExportData(request);
}

StatusOr<google::cloud::automl::v1::AnnotationSpec>
AutoMlClient::GetAnnotationSpec(std::string const& name, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::GetAnnotationSpecRequest request;
  request.set_name(name);
  return connection_->GetAnnotationSpec(request);
}

StatusOr<google::cloud::automl::v1::AnnotationSpec>
AutoMlClient::GetAnnotationSpec(
    google::cloud::automl::v1::GetAnnotationSpecRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetAnnotationSpec(request);
}

future<StatusOr<google::cloud::automl::v1::Model>> AutoMlClient::CreateModel(
    std::string const& parent, google::cloud::automl::v1::Model const& model,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::CreateModelRequest request;
  request.set_parent(parent);
  *request.mutable_model() = model;
  return connection_->CreateModel(request);
}

future<StatusOr<google::cloud::automl::v1::Model>> AutoMlClient::CreateModel(
    google::cloud::automl::v1::CreateModelRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateModel(request);
}

StatusOr<google::cloud::automl::v1::Model> AutoMlClient::GetModel(
    std::string const& name, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::GetModelRequest request;
  request.set_name(name);
  return connection_->GetModel(request);
}

StatusOr<google::cloud::automl::v1::Model> AutoMlClient::GetModel(
    google::cloud::automl::v1::GetModelRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetModel(request);
}

StreamRange<google::cloud::automl::v1::Model> AutoMlClient::ListModels(
    std::string const& parent, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::ListModelsRequest request;
  request.set_parent(parent);
  return connection_->ListModels(request);
}

StreamRange<google::cloud::automl::v1::Model> AutoMlClient::ListModels(
    google::cloud::automl::v1::ListModelsRequest request, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListModels(std::move(request));
}

future<StatusOr<google::cloud::automl::v1::OperationMetadata>>
AutoMlClient::DeleteModel(std::string const& name, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::DeleteModelRequest request;
  request.set_name(name);
  return connection_->DeleteModel(request);
}

future<StatusOr<google::cloud::automl::v1::OperationMetadata>>
AutoMlClient::DeleteModel(
    google::cloud::automl::v1::DeleteModelRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteModel(request);
}

StatusOr<google::cloud::automl::v1::Model> AutoMlClient::UpdateModel(
    google::cloud::automl::v1::Model const& model,
    google::protobuf::FieldMask const& update_mask, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::UpdateModelRequest request;
  *request.mutable_model() = model;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateModel(request);
}

StatusOr<google::cloud::automl::v1::Model> AutoMlClient::UpdateModel(
    google::cloud::automl::v1::UpdateModelRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateModel(request);
}

future<StatusOr<google::cloud::automl::v1::OperationMetadata>>
AutoMlClient::DeployModel(std::string const& name, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::DeployModelRequest request;
  request.set_name(name);
  return connection_->DeployModel(request);
}

future<StatusOr<google::cloud::automl::v1::OperationMetadata>>
AutoMlClient::DeployModel(
    google::cloud::automl::v1::DeployModelRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeployModel(request);
}

future<StatusOr<google::cloud::automl::v1::OperationMetadata>>
AutoMlClient::UndeployModel(std::string const& name, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::UndeployModelRequest request;
  request.set_name(name);
  return connection_->UndeployModel(request);
}

future<StatusOr<google::cloud::automl::v1::OperationMetadata>>
AutoMlClient::UndeployModel(
    google::cloud::automl::v1::UndeployModelRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UndeployModel(request);
}

future<StatusOr<google::cloud::automl::v1::OperationMetadata>>
AutoMlClient::ExportModel(
    std::string const& name,
    google::cloud::automl::v1::ModelExportOutputConfig const& output_config,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::ExportModelRequest request;
  request.set_name(name);
  *request.mutable_output_config() = output_config;
  return connection_->ExportModel(request);
}

future<StatusOr<google::cloud::automl::v1::OperationMetadata>>
AutoMlClient::ExportModel(
    google::cloud::automl::v1::ExportModelRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ExportModel(request);
}

StatusOr<google::cloud::automl::v1::ModelEvaluation>
AutoMlClient::GetModelEvaluation(std::string const& name, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::GetModelEvaluationRequest request;
  request.set_name(name);
  return connection_->GetModelEvaluation(request);
}

StatusOr<google::cloud::automl::v1::ModelEvaluation>
AutoMlClient::GetModelEvaluation(
    google::cloud::automl::v1::GetModelEvaluationRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetModelEvaluation(request);
}

StreamRange<google::cloud::automl::v1::ModelEvaluation>
AutoMlClient::ListModelEvaluations(std::string const& parent,
                                   std::string const& filter, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::automl::v1::ListModelEvaluationsRequest request;
  request.set_parent(parent);
  request.set_filter(filter);
  return connection_->ListModelEvaluations(request);
}

StreamRange<google::cloud::automl::v1::ModelEvaluation>
AutoMlClient::ListModelEvaluations(
    google::cloud::automl::v1::ListModelEvaluationsRequest request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListModelEvaluations(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace automl
}  // namespace cloud
}  // namespace google
