// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/assuredworkloads/v1/assuredworkloads.proto

#include "google/cloud/assuredworkloads/assured_workloads_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace assuredworkloads {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

AssuredWorkloadsServiceConnectionIdempotencyPolicy::
    ~AssuredWorkloadsServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultAssuredWorkloadsServiceConnectionIdempotencyPolicy
    : public AssuredWorkloadsServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultAssuredWorkloadsServiceConnectionIdempotencyPolicy() override =
      default;

  /// Create a new copy of this object.
  std::unique_ptr<AssuredWorkloadsServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<
        DefaultAssuredWorkloadsServiceConnectionIdempotencyPolicy>(*this);
  }

  Idempotency CreateWorkload(
      google::cloud::assuredworkloads::v1::CreateWorkloadRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateWorkload(
      google::cloud::assuredworkloads::v1::UpdateWorkloadRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteWorkload(
      google::cloud::assuredworkloads::v1::DeleteWorkloadRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetWorkload(
      google::cloud::assuredworkloads::v1::GetWorkloadRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListWorkloads(
      google::cloud::assuredworkloads::v1::ListWorkloadsRequest) override {
    return Idempotency::kIdempotent;
  }
};
}  // namespace

std::unique_ptr<AssuredWorkloadsServiceConnectionIdempotencyPolicy>
MakeDefaultAssuredWorkloadsServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<
      DefaultAssuredWorkloadsServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace assuredworkloads
}  // namespace cloud
}  // namespace google
