// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/assuredworkloads/v1/assuredworkloads.proto

#include "google/cloud/assuredworkloads/assured_workloads_connection.h"
#include "google/cloud/assuredworkloads/assured_workloads_options.h"
#include "google/cloud/assuredworkloads/internal/assured_workloads_connection_impl.h"
#include "google/cloud/assuredworkloads/internal/assured_workloads_option_defaults.h"
#include "google/cloud/assuredworkloads/internal/assured_workloads_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace assuredworkloads {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AssuredWorkloadsServiceConnection::~AssuredWorkloadsServiceConnection() =
    default;

future<StatusOr<google::cloud::assuredworkloads::v1::Workload>>
AssuredWorkloadsServiceConnection::CreateWorkload(
    google::cloud::assuredworkloads::v1::CreateWorkloadRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::assuredworkloads::v1::Workload>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::assuredworkloads::v1::Workload>
AssuredWorkloadsServiceConnection::UpdateWorkload(
    google::cloud::assuredworkloads::v1::UpdateWorkloadRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status AssuredWorkloadsServiceConnection::DeleteWorkload(
    google::cloud::assuredworkloads::v1::DeleteWorkloadRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::assuredworkloads::v1::Workload>
AssuredWorkloadsServiceConnection::GetWorkload(
    google::cloud::assuredworkloads::v1::GetWorkloadRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::assuredworkloads::v1::Workload>
AssuredWorkloadsServiceConnection::ListWorkloads(
    google::cloud::assuredworkloads::v1::ListWorkloadsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::assuredworkloads::v1::Workload>>(
      std::move(request),
      [](google::cloud::assuredworkloads::v1::ListWorkloadsRequest const&) {
        return StatusOr<
            google::cloud::assuredworkloads::v1::ListWorkloadsResponse>{};
      },
      [](google::cloud::assuredworkloads::v1::ListWorkloadsResponse const&) {
        return std::vector<google::cloud::assuredworkloads::v1::Workload>();
      });
}

std::shared_ptr<AssuredWorkloadsServiceConnection>
MakeAssuredWorkloadsServiceConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 AssuredWorkloadsServicePolicyOptionList>(
      options, __func__);
  options = assuredworkloads_internal::AssuredWorkloadsServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub =
      assuredworkloads_internal::CreateDefaultAssuredWorkloadsServiceStub(
          background->cq(), options);
  return std::make_shared<
      assuredworkloads_internal::AssuredWorkloadsServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace assuredworkloads
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace assuredworkloads_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<assuredworkloads::AssuredWorkloadsServiceConnection>
MakeAssuredWorkloadsServiceConnection(
    std::shared_ptr<AssuredWorkloadsServiceStub> stub, Options options) {
  options = AssuredWorkloadsServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<
      assuredworkloads_internal::AssuredWorkloadsServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace assuredworkloads_internal
}  // namespace cloud
}  // namespace google
