// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/asset/v1/asset_service.proto

#include "google/cloud/asset/internal/asset_auth_decorator.h"
#include <google/cloud/asset/v1/asset_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace asset_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AssetServiceAuth::AssetServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<AssetServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

future<StatusOr<google::longrunning::Operation>>
AssetServiceAuth::AsyncExportAssets(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::asset::v1::ExportAssetsRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  auto child = child_;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child,
             request](future<StatusOr<std::unique_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncExportAssets(cq, *std::move(context), request);
      });
}

StatusOr<google::cloud::asset::v1::ListAssetsResponse>
AssetServiceAuth::ListAssets(
    grpc::ClientContext& context,
    google::cloud::asset::v1::ListAssetsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListAssets(context, request);
}

StatusOr<google::cloud::asset::v1::BatchGetAssetsHistoryResponse>
AssetServiceAuth::BatchGetAssetsHistory(
    grpc::ClientContext& context,
    google::cloud::asset::v1::BatchGetAssetsHistoryRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->BatchGetAssetsHistory(context, request);
}

StatusOr<google::cloud::asset::v1::Feed> AssetServiceAuth::CreateFeed(
    grpc::ClientContext& context,
    google::cloud::asset::v1::CreateFeedRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateFeed(context, request);
}

StatusOr<google::cloud::asset::v1::Feed> AssetServiceAuth::GetFeed(
    grpc::ClientContext& context,
    google::cloud::asset::v1::GetFeedRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetFeed(context, request);
}

StatusOr<google::cloud::asset::v1::ListFeedsResponse>
AssetServiceAuth::ListFeeds(
    grpc::ClientContext& context,
    google::cloud::asset::v1::ListFeedsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListFeeds(context, request);
}

StatusOr<google::cloud::asset::v1::Feed> AssetServiceAuth::UpdateFeed(
    grpc::ClientContext& context,
    google::cloud::asset::v1::UpdateFeedRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateFeed(context, request);
}

Status AssetServiceAuth::DeleteFeed(
    grpc::ClientContext& context,
    google::cloud::asset::v1::DeleteFeedRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteFeed(context, request);
}

StatusOr<google::cloud::asset::v1::SearchAllResourcesResponse>
AssetServiceAuth::SearchAllResources(
    grpc::ClientContext& context,
    google::cloud::asset::v1::SearchAllResourcesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SearchAllResources(context, request);
}

StatusOr<google::cloud::asset::v1::SearchAllIamPoliciesResponse>
AssetServiceAuth::SearchAllIamPolicies(
    grpc::ClientContext& context,
    google::cloud::asset::v1::SearchAllIamPoliciesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SearchAllIamPolicies(context, request);
}

StatusOr<google::cloud::asset::v1::AnalyzeIamPolicyResponse>
AssetServiceAuth::AnalyzeIamPolicy(
    grpc::ClientContext& context,
    google::cloud::asset::v1::AnalyzeIamPolicyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->AnalyzeIamPolicy(context, request);
}

future<StatusOr<google::longrunning::Operation>>
AssetServiceAuth::AsyncAnalyzeIamPolicyLongrunning(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::asset::v1::AnalyzeIamPolicyLongrunningRequest const&
        request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  auto child = child_;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child,
             request](future<StatusOr<std::unique_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncAnalyzeIamPolicyLongrunning(cq, *std::move(context),
                                                       request);
      });
}

StatusOr<google::cloud::asset::v1::AnalyzeMoveResponse>
AssetServiceAuth::AnalyzeMove(
    grpc::ClientContext& context,
    google::cloud::asset::v1::AnalyzeMoveRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->AnalyzeMove(context, request);
}

future<StatusOr<google::longrunning::Operation>>
AssetServiceAuth::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::GetOperationRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  auto child = child_;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child,
             request](future<StatusOr<std::unique_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncGetOperation(cq, *std::move(context), request);
      });
}

future<Status> AssetServiceAuth::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::CancelOperationRequest const& request) {
  auto child = child_;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child,
             request](future<StatusOr<std::unique_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) return make_ready_future(std::move(context).status());
        return child->AsyncCancelOperation(cq, *std::move(context), request);
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace asset_internal
}  // namespace cloud
}  // namespace google
